/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;

public class LibDescr
implements Serializable {
    long magic;
    Cell lib;
    TonHashMap publishers;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(0, 2).storeRef(this.lib).storeDict(this.publishers.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeBit(Boolean.valueOf(true)).endCell())).endCell();
    }

    public static LibDescr deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).longValue();
        assert (magic == 0L) : "LibDescr: magic not equal to 0b00, found 0x" + Long.toHexString(magic);
        return LibDescr.builder().magic(0L).lib(cs.loadRef()).publishers(cs.loadDict(256, k -> k.readInt(256), v -> CellSlice.beginParse((Cell)v).loadBit())).build();
    }

    LibDescr(long magic, Cell lib, TonHashMap publishers) {
        this.magic = magic;
        this.lib = lib;
        this.publishers = publishers;
    }

    public static LibDescrBuilder builder() {
        return new LibDescrBuilder();
    }

    public Cell getLib() {
        return this.lib;
    }

    public TonHashMap getPublishers() {
        return this.publishers;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setLib(Cell lib) {
        this.lib = lib;
    }

    public void setPublishers(TonHashMap publishers) {
        this.publishers = publishers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LibDescr)) {
            return false;
        }
        LibDescr other = (LibDescr)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        Cell this$lib = this.getLib();
        Cell other$lib = other.getLib();
        if (this$lib == null ? other$lib != null : !this$lib.equals(other$lib)) {
            return false;
        }
        TonHashMap this$publishers = this.getPublishers();
        TonHashMap other$publishers = other.getPublishers();
        return !(this$publishers == null ? other$publishers != null : !this$publishers.equals(other$publishers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LibDescr;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        Cell $lib = this.getLib();
        result = result * 59 + ($lib == null ? 43 : $lib.hashCode());
        TonHashMap $publishers = this.getPublishers();
        result = result * 59 + ($publishers == null ? 43 : $publishers.hashCode());
        return result;
    }

    public String toString() {
        return "LibDescr(magic=" + this.getMagic() + ", lib=" + String.valueOf(this.getLib()) + ", publishers=" + String.valueOf(this.getPublishers()) + ")";
    }

    public static class LibDescrBuilder {
        private long magic;
        private Cell lib;
        private TonHashMap publishers;

        LibDescrBuilder() {
        }

        public LibDescrBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public LibDescrBuilder lib(Cell lib) {
            this.lib = lib;
            return this;
        }

        public LibDescrBuilder publishers(TonHashMap publishers) {
            this.publishers = publishers;
            return this;
        }

        public LibDescr build() {
            return new LibDescr(this.magic, this.lib, this.publishers);
        }

        public String toString() {
            return "LibDescr.LibDescrBuilder(magic=" + this.magic + ", lib=" + String.valueOf(this.lib) + ", publishers=" + String.valueOf(this.publishers) + ")";
        }
    }
}

