/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.MsgAddress;
import org.ton.java.tlb.MsgAddressExt;
import org.ton.java.tlb.MsgAddressExtNone;

public class ExternalMessageOutInfoRelaxed
implements CommonMsgInfoRelaxed,
Serializable {
    long magic;
    MsgAddress srcAddr;
    MsgAddressExt dstAddr;
    BigInteger createdLt;
    long createdAt;

    private String getMagic() {
        return Long.toBinaryString(this.magic);
    }

    @Override
    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell().storeUint(3, 2).storeCell(Objects.isNull(this.srcAddr) ? MsgAddressExtNone.builder().build().toCell() : this.srcAddr.toCell()).storeCell(this.dstAddr.toCell()).storeUint(Objects.isNull(this.createdLt) ? BigInteger.ZERO : this.createdLt, 64).storeUint(this.createdAt, 32);
        return result.endCell();
    }

    public static ExternalMessageOutInfoRelaxed deserialize(CellSlice cs) {
        long magic = cs.loadUint(2).intValue();
        assert (magic == 3L) : "ExternalMessageOutInfoRelaxed: magic not equal to 0b11, found 0b" + Long.toBinaryString(magic);
        return ExternalMessageOutInfoRelaxed.builder().magic(3L).srcAddr(MsgAddress.deserialize(cs)).dstAddr(MsgAddressExt.deserialize(cs)).createdLt(cs.loadUint(64)).createdAt(cs.loadUint(32).longValue()).build();
    }

    ExternalMessageOutInfoRelaxed(long magic, MsgAddress srcAddr, MsgAddressExt dstAddr, BigInteger createdLt, long createdAt) {
        this.magic = magic;
        this.srcAddr = srcAddr;
        this.dstAddr = dstAddr;
        this.createdLt = createdLt;
        this.createdAt = createdAt;
    }

    public static ExternalMessageOutInfoRelaxedBuilder builder() {
        return new ExternalMessageOutInfoRelaxedBuilder();
    }

    public MsgAddress getSrcAddr() {
        return this.srcAddr;
    }

    public MsgAddressExt getDstAddr() {
        return this.dstAddr;
    }

    public BigInteger getCreatedLt() {
        return this.createdLt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setSrcAddr(MsgAddress srcAddr) {
        this.srcAddr = srcAddr;
    }

    public void setDstAddr(MsgAddressExt dstAddr) {
        this.dstAddr = dstAddr;
    }

    public void setCreatedLt(BigInteger createdLt) {
        this.createdLt = createdLt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExternalMessageOutInfoRelaxed)) {
            return false;
        }
        ExternalMessageOutInfoRelaxed other = (ExternalMessageOutInfoRelaxed)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getCreatedAt() != other.getCreatedAt()) {
            return false;
        }
        MsgAddress this$srcAddr = this.getSrcAddr();
        MsgAddress other$srcAddr = other.getSrcAddr();
        if (this$srcAddr == null ? other$srcAddr != null : !this$srcAddr.equals(other$srcAddr)) {
            return false;
        }
        MsgAddressExt this$dstAddr = this.getDstAddr();
        MsgAddressExt other$dstAddr = other.getDstAddr();
        if (this$dstAddr == null ? other$dstAddr != null : !this$dstAddr.equals(other$dstAddr)) {
            return false;
        }
        BigInteger this$createdLt = this.getCreatedLt();
        BigInteger other$createdLt = other.getCreatedLt();
        return !(this$createdLt == null ? other$createdLt != null : !((Object)this$createdLt).equals(other$createdLt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExternalMessageOutInfoRelaxed;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $createdAt = this.getCreatedAt();
        result = result * 59 + (int)($createdAt >>> 32 ^ $createdAt);
        MsgAddress $srcAddr = this.getSrcAddr();
        result = result * 59 + ($srcAddr == null ? 43 : $srcAddr.hashCode());
        MsgAddressExt $dstAddr = this.getDstAddr();
        result = result * 59 + ($dstAddr == null ? 43 : $dstAddr.hashCode());
        BigInteger $createdLt = this.getCreatedLt();
        result = result * 59 + ($createdLt == null ? 43 : ((Object)$createdLt).hashCode());
        return result;
    }

    public String toString() {
        return "ExternalMessageOutInfoRelaxed(magic=" + this.getMagic() + ", srcAddr=" + String.valueOf(this.getSrcAddr()) + ", dstAddr=" + String.valueOf(this.getDstAddr()) + ", createdLt=" + String.valueOf(this.getCreatedLt()) + ", createdAt=" + this.getCreatedAt() + ")";
    }

    public static class ExternalMessageOutInfoRelaxedBuilder {
        private long magic;
        private MsgAddress srcAddr;
        private MsgAddressExt dstAddr;
        private BigInteger createdLt;
        private long createdAt;

        ExternalMessageOutInfoRelaxedBuilder() {
        }

        public ExternalMessageOutInfoRelaxedBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public ExternalMessageOutInfoRelaxedBuilder srcAddr(MsgAddress srcAddr) {
            this.srcAddr = srcAddr;
            return this;
        }

        public ExternalMessageOutInfoRelaxedBuilder dstAddr(MsgAddressExt dstAddr) {
            this.dstAddr = dstAddr;
            return this;
        }

        public ExternalMessageOutInfoRelaxedBuilder createdLt(BigInteger createdLt) {
            this.createdLt = createdLt;
            return this;
        }

        public ExternalMessageOutInfoRelaxedBuilder createdAt(long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public ExternalMessageOutInfoRelaxed build() {
            return new ExternalMessageOutInfoRelaxed(this.magic, this.srcAddr, this.dstAddr, this.createdLt, this.createdAt);
        }

        public String toString() {
            return "ExternalMessageOutInfoRelaxed.ExternalMessageOutInfoRelaxedBuilder(magic=" + this.magic + ", srcAddr=" + String.valueOf(this.srcAddr) + ", dstAddr=" + String.valueOf(this.dstAddr) + ", createdLt=" + String.valueOf(this.createdLt) + ", createdAt=" + this.createdAt + ")";
        }
    }
}

