/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ExtendedActionType;

public class ExtendedAction
implements Serializable {
    ExtendedActionType actionType;
    Address address;
    Boolean isSignatureAllowed;

    public Cell toCell() {
        CellBuilder cb = CellBuilder.beginCell();
        if (this.actionType == ExtendedActionType.ADD_EXTENSION) {
            cb.storeUint(2, 8).storeAddress(this.address);
        } else if (this.actionType == ExtendedActionType.REMOVE_EXTENSION) {
            cb.storeUint(3, 8).storeAddress(this.address);
        } else {
            cb.storeUint(4, 8).storeBit(this.isSignatureAllowed);
        }
        return cb.endCell();
    }

    public static ExtendedAction deserialize(CellSlice cs) {
        ExtendedAction extendedAction = ExtendedAction.builder().build();
        int actionType = cs.loadUint(8).intValue();
        if (actionType == 2 || actionType == 3) {
            extendedAction.setActionType(ExtendedActionType.getExtensionType(actionType));
            extendedAction.setAddress(cs.loadAddress());
        } else if (actionType == 4) {
            extendedAction.setIsSignatureAllowed(cs.loadBit());
        } else {
            throw new Error("Wrong action type");
        }
        return extendedAction;
    }

    ExtendedAction(ExtendedActionType actionType, Address address, Boolean isSignatureAllowed) {
        this.actionType = actionType;
        this.address = address;
        this.isSignatureAllowed = isSignatureAllowed;
    }

    public static ExtendedActionBuilder builder() {
        return new ExtendedActionBuilder();
    }

    public ExtendedActionType getActionType() {
        return this.actionType;
    }

    public Address getAddress() {
        return this.address;
    }

    public Boolean getIsSignatureAllowed() {
        return this.isSignatureAllowed;
    }

    public void setActionType(ExtendedActionType actionType) {
        this.actionType = actionType;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setIsSignatureAllowed(Boolean isSignatureAllowed) {
        this.isSignatureAllowed = isSignatureAllowed;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedAction)) {
            return false;
        }
        ExtendedAction other = (ExtendedAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isSignatureAllowed = this.getIsSignatureAllowed();
        Boolean other$isSignatureAllowed = other.getIsSignatureAllowed();
        if (this$isSignatureAllowed == null ? other$isSignatureAllowed != null : !((Object)this$isSignatureAllowed).equals(other$isSignatureAllowed)) {
            return false;
        }
        ExtendedActionType this$actionType = this.getActionType();
        ExtendedActionType other$actionType = other.getActionType();
        if (this$actionType == null ? other$actionType != null : !this$actionType.equals(other$actionType)) {
            return false;
        }
        Address this$address = this.getAddress();
        Address other$address = other.getAddress();
        return !(this$address == null ? other$address != null : !this$address.equals(other$address));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtendedAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isSignatureAllowed = this.getIsSignatureAllowed();
        result = result * 59 + ($isSignatureAllowed == null ? 43 : ((Object)$isSignatureAllowed).hashCode());
        ExtendedActionType $actionType = this.getActionType();
        result = result * 59 + ($actionType == null ? 43 : $actionType.hashCode());
        Address $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        return result;
    }

    public String toString() {
        return "ExtendedAction(actionType=" + String.valueOf(this.getActionType()) + ", address=" + String.valueOf(this.getAddress()) + ", isSignatureAllowed=" + this.getIsSignatureAllowed() + ")";
    }

    public static class ExtendedActionBuilder {
        private ExtendedActionType actionType;
        private Address address;
        private Boolean isSignatureAllowed;

        ExtendedActionBuilder() {
        }

        public ExtendedActionBuilder actionType(ExtendedActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public ExtendedActionBuilder address(Address address) {
            this.address = address;
            return this;
        }

        public ExtendedActionBuilder isSignatureAllowed(Boolean isSignatureAllowed) {
            this.isSignatureAllowed = isSignatureAllowed;
            return this;
        }

        public ExtendedAction build() {
            return new ExtendedAction(this.actionType, this.address, this.isSignatureAllowed);
        }

        public String toString() {
            return "ExtendedAction.ExtendedActionBuilder(actionType=" + String.valueOf(this.actionType) + ", address=" + String.valueOf(this.address) + ", isSignatureAllowed=" + this.isSignatureAllowed + ")";
        }
    }
}

