/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.utils.Utils;

public class DepthBalanceInfo
implements Serializable {
    int depth;
    CurrencyCollection currencies;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.depth, Utils.log2Ceil((int)this.depth)).storeCell(this.currencies.toCell()).endCell();
    }

    public static DepthBalanceInfo deserialize(CellSlice cs) {
        return DepthBalanceInfo.builder().depth(cs.loadUint(5).intValue()).currencies(CurrencyCollection.deserialize(cs)).build();
    }

    DepthBalanceInfo(int depth, CurrencyCollection currencies) {
        this.depth = depth;
        this.currencies = currencies;
    }

    public static DepthBalanceInfoBuilder builder() {
        return new DepthBalanceInfoBuilder();
    }

    public int getDepth() {
        return this.depth;
    }

    public CurrencyCollection getCurrencies() {
        return this.currencies;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setCurrencies(CurrencyCollection currencies) {
        this.currencies = currencies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DepthBalanceInfo)) {
            return false;
        }
        DepthBalanceInfo other = (DepthBalanceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        CurrencyCollection this$currencies = this.getCurrencies();
        CurrencyCollection other$currencies = other.getCurrencies();
        return !(this$currencies == null ? other$currencies != null : !((Object)this$currencies).equals(other$currencies));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DepthBalanceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        CurrencyCollection $currencies = this.getCurrencies();
        result = result * 59 + ($currencies == null ? 43 : ((Object)$currencies).hashCode());
        return result;
    }

    public String toString() {
        return "DepthBalanceInfo(depth=" + this.getDepth() + ", currencies=" + String.valueOf(this.getCurrencies()) + ")";
    }

    public static class DepthBalanceInfoBuilder {
        private int depth;
        private CurrencyCollection currencies;

        DepthBalanceInfoBuilder() {
        }

        public DepthBalanceInfoBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public DepthBalanceInfoBuilder currencies(CurrencyCollection currencies) {
            this.currencies = currencies;
            return this;
        }

        public DepthBalanceInfo build() {
            return new DepthBalanceInfo(this.depth, this.currencies);
        }

        public String toString() {
            return "DepthBalanceInfo.DepthBalanceInfoBuilder(depth=" + this.depth + ", currencies=" + String.valueOf(this.currencies) + ")";
        }
    }
}

