/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CryptoSignature;

public class CryptoSignaturePair
implements Serializable {
    BigInteger nodeIdShort;
    CryptoSignature sign;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.nodeIdShort, 256).storeCell(this.sign.toCell()).endCell();
    }

    public static CryptoSignaturePair deserialize(CellSlice cs) {
        return CryptoSignaturePair.builder().nodeIdShort(cs.loadUint(256)).sign(CryptoSignature.deserialize(cs)).build();
    }

    CryptoSignaturePair(BigInteger nodeIdShort, CryptoSignature sign) {
        this.nodeIdShort = nodeIdShort;
        this.sign = sign;
    }

    public static CryptoSignaturePairBuilder builder() {
        return new CryptoSignaturePairBuilder();
    }

    public BigInteger getNodeIdShort() {
        return this.nodeIdShort;
    }

    public CryptoSignature getSign() {
        return this.sign;
    }

    public void setNodeIdShort(BigInteger nodeIdShort) {
        this.nodeIdShort = nodeIdShort;
    }

    public void setSign(CryptoSignature sign) {
        this.sign = sign;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoSignaturePair)) {
            return false;
        }
        CryptoSignaturePair other = (CryptoSignaturePair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$nodeIdShort = this.getNodeIdShort();
        BigInteger other$nodeIdShort = other.getNodeIdShort();
        if (this$nodeIdShort == null ? other$nodeIdShort != null : !((Object)this$nodeIdShort).equals(other$nodeIdShort)) {
            return false;
        }
        CryptoSignature this$sign = this.getSign();
        CryptoSignature other$sign = other.getSign();
        return !(this$sign == null ? other$sign != null : !((Object)this$sign).equals(other$sign));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoSignaturePair;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $nodeIdShort = this.getNodeIdShort();
        result = result * 59 + ($nodeIdShort == null ? 43 : ((Object)$nodeIdShort).hashCode());
        CryptoSignature $sign = this.getSign();
        result = result * 59 + ($sign == null ? 43 : ((Object)$sign).hashCode());
        return result;
    }

    public String toString() {
        return "CryptoSignaturePair(nodeIdShort=" + String.valueOf(this.getNodeIdShort()) + ", sign=" + String.valueOf(this.getSign()) + ")";
    }

    public static class CryptoSignaturePairBuilder {
        private BigInteger nodeIdShort;
        private CryptoSignature sign;

        CryptoSignaturePairBuilder() {
        }

        public CryptoSignaturePairBuilder nodeIdShort(BigInteger nodeIdShort) {
            this.nodeIdShort = nodeIdShort;
            return this;
        }

        public CryptoSignaturePairBuilder sign(CryptoSignature sign) {
            this.sign = sign;
            return this;
        }

        public CryptoSignaturePair build() {
            return new CryptoSignaturePair(this.nodeIdShort, this.sign);
        }

        public String toString() {
            return "CryptoSignaturePair.CryptoSignaturePairBuilder(nodeIdShort=" + String.valueOf(this.nodeIdShort) + ", sign=" + String.valueOf(this.sign) + ")";
        }
    }
}

