/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class CryptoSignature
implements Serializable {
    int magic;
    BigInteger r;
    BigInteger s;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(5, 8).storeUint(this.r, 256).storeUint(this.s, 256).endCell();
    }

    public static CryptoSignature deserialize(CellSlice cs) {
        long magic = cs.loadUint(4).longValue();
        assert (magic == 5L) : "CryptoSignature: magic not equal to 0x5, found 0x" + Long.toHexString(magic);
        return CryptoSignature.builder().magic(5).r(cs.loadUint(256)).s(cs.loadUint(256)).build();
    }

    CryptoSignature(int magic, BigInteger r, BigInteger s) {
        this.magic = magic;
        this.r = r;
        this.s = s;
    }

    public static CryptoSignatureBuilder builder() {
        return new CryptoSignatureBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getR() {
        return this.r;
    }

    public BigInteger getS() {
        return this.s;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setR(BigInteger r) {
        this.r = r;
    }

    public void setS(BigInteger s) {
        this.s = s;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CryptoSignature)) {
            return false;
        }
        CryptoSignature other = (CryptoSignature)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$r = this.getR();
        BigInteger other$r = other.getR();
        if (this$r == null ? other$r != null : !((Object)this$r).equals(other$r)) {
            return false;
        }
        BigInteger this$s = this.getS();
        BigInteger other$s = other.getS();
        return !(this$s == null ? other$s != null : !((Object)this$s).equals(other$s));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CryptoSignature;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        BigInteger $r = this.getR();
        result = result * 59 + ($r == null ? 43 : ((Object)$r).hashCode());
        BigInteger $s = this.getS();
        result = result * 59 + ($s == null ? 43 : ((Object)$s).hashCode());
        return result;
    }

    public String toString() {
        return "CryptoSignature(magic=" + this.getMagic() + ", r=" + String.valueOf(this.getR()) + ", s=" + String.valueOf(this.getS()) + ")";
    }

    public static class CryptoSignatureBuilder {
        private int magic;
        private BigInteger r;
        private BigInteger s;

        CryptoSignatureBuilder() {
        }

        public CryptoSignatureBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public CryptoSignatureBuilder r(BigInteger r) {
            this.r = r;
            return this;
        }

        public CryptoSignatureBuilder s(BigInteger s) {
            this.s = s;
            return this;
        }

        public CryptoSignature build() {
            return new CryptoSignature(this.magic, this.r, this.s);
        }

        public String toString() {
            return "CryptoSignature.CryptoSignatureBuilder(magic=" + this.magic + ", r=" + String.valueOf(this.r) + ", s=" + String.valueOf(this.s) + ")";
        }
    }
}

