/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CurrencyCollection;

public class CreditPhase
implements Serializable {
    BigInteger dueFeesCollected;
    CurrencyCollection credit;

    public Cell toCell() {
        return CellBuilder.beginCell().storeCoinsMaybe(this.dueFeesCollected).storeSlice(CellSlice.beginParse((Cell)this.credit.toCell())).endCell();
    }

    public static CreditPhase deserialize(CellSlice cs) {
        return CreditPhase.builder().dueFeesCollected(cs.loadBit() ? cs.loadCoins() : null).credit(CurrencyCollection.deserialize(cs)).build();
    }

    CreditPhase(BigInteger dueFeesCollected, CurrencyCollection credit) {
        this.dueFeesCollected = dueFeesCollected;
        this.credit = credit;
    }

    public static CreditPhaseBuilder builder() {
        return new CreditPhaseBuilder();
    }

    public BigInteger getDueFeesCollected() {
        return this.dueFeesCollected;
    }

    public CurrencyCollection getCredit() {
        return this.credit;
    }

    public void setDueFeesCollected(BigInteger dueFeesCollected) {
        this.dueFeesCollected = dueFeesCollected;
    }

    public void setCredit(CurrencyCollection credit) {
        this.credit = credit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreditPhase)) {
            return false;
        }
        CreditPhase other = (CreditPhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$dueFeesCollected = this.getDueFeesCollected();
        BigInteger other$dueFeesCollected = other.getDueFeesCollected();
        if (this$dueFeesCollected == null ? other$dueFeesCollected != null : !((Object)this$dueFeesCollected).equals(other$dueFeesCollected)) {
            return false;
        }
        CurrencyCollection this$credit = this.getCredit();
        CurrencyCollection other$credit = other.getCredit();
        return !(this$credit == null ? other$credit != null : !((Object)this$credit).equals(other$credit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreditPhase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $dueFeesCollected = this.getDueFeesCollected();
        result = result * 59 + ($dueFeesCollected == null ? 43 : ((Object)$dueFeesCollected).hashCode());
        CurrencyCollection $credit = this.getCredit();
        result = result * 59 + ($credit == null ? 43 : ((Object)$credit).hashCode());
        return result;
    }

    public String toString() {
        return "CreditPhase(dueFeesCollected=" + String.valueOf(this.getDueFeesCollected()) + ", credit=" + String.valueOf(this.getCredit()) + ")";
    }

    public static class CreditPhaseBuilder {
        private BigInteger dueFeesCollected;
        private CurrencyCollection credit;

        CreditPhaseBuilder() {
        }

        public CreditPhaseBuilder dueFeesCollected(BigInteger dueFeesCollected) {
            this.dueFeesCollected = dueFeesCollected;
            return this;
        }

        public CreditPhaseBuilder credit(CurrencyCollection credit) {
            this.credit = credit;
            return this;
        }

        public CreditPhase build() {
            return new CreditPhase(this.dueFeesCollected, this.credit);
        }

        public String toString() {
            return "CreditPhase.CreditPhaseBuilder(dueFeesCollected=" + String.valueOf(this.dueFeesCollected) + ", credit=" + String.valueOf(this.credit) + ")";
        }
    }
}

