/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ConsensusConfig;

public class ConsensusConfigV1
implements ConsensusConfig,
Serializable {
    int magic;
    int roundCandidates;
    long nextCandidateDelayMs;
    long consensusTimeoutMs;
    long fastAttempts;
    long attemptDuration;
    long catchainNaxDeps;
    long maxBlockBytes;
    long maxCollatedBytes;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(214, 8).storeUint(this.roundCandidates, 32).storeUint(this.nextCandidateDelayMs, 32).storeUint(this.consensusTimeoutMs, 32).storeUint(this.fastAttempts, 32).storeUint(this.attemptDuration, 32).storeUint(this.catchainNaxDeps, 32).storeUint(this.maxBlockBytes, 32).storeUint(this.maxCollatedBytes, 32).endCell();
    }

    public static ConsensusConfigV1 deserialize(CellSlice cs) {
        return ConsensusConfigV1.builder().magic(cs.loadUint(8).intValue()).roundCandidates(cs.loadUint(32).intValue()).nextCandidateDelayMs(cs.loadUint(32).longValue()).consensusTimeoutMs(cs.loadUint(32).longValue()).fastAttempts(cs.loadUint(32).longValue()).attemptDuration(cs.loadUint(32).longValue()).catchainNaxDeps(cs.loadUint(32).longValue()).maxBlockBytes(cs.loadUint(32).longValue()).maxCollatedBytes(cs.loadUint(32).longValue()).build();
    }

    ConsensusConfigV1(int magic, int roundCandidates, long nextCandidateDelayMs, long consensusTimeoutMs, long fastAttempts, long attemptDuration, long catchainNaxDeps, long maxBlockBytes, long maxCollatedBytes) {
        this.magic = magic;
        this.roundCandidates = roundCandidates;
        this.nextCandidateDelayMs = nextCandidateDelayMs;
        this.consensusTimeoutMs = consensusTimeoutMs;
        this.fastAttempts = fastAttempts;
        this.attemptDuration = attemptDuration;
        this.catchainNaxDeps = catchainNaxDeps;
        this.maxBlockBytes = maxBlockBytes;
        this.maxCollatedBytes = maxCollatedBytes;
    }

    public static ConsensusConfigV1Builder builder() {
        return new ConsensusConfigV1Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getRoundCandidates() {
        return this.roundCandidates;
    }

    public long getNextCandidateDelayMs() {
        return this.nextCandidateDelayMs;
    }

    public long getConsensusTimeoutMs() {
        return this.consensusTimeoutMs;
    }

    public long getFastAttempts() {
        return this.fastAttempts;
    }

    public long getAttemptDuration() {
        return this.attemptDuration;
    }

    public long getCatchainNaxDeps() {
        return this.catchainNaxDeps;
    }

    public long getMaxBlockBytes() {
        return this.maxBlockBytes;
    }

    public long getMaxCollatedBytes() {
        return this.maxCollatedBytes;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setRoundCandidates(int roundCandidates) {
        this.roundCandidates = roundCandidates;
    }

    public void setNextCandidateDelayMs(long nextCandidateDelayMs) {
        this.nextCandidateDelayMs = nextCandidateDelayMs;
    }

    public void setConsensusTimeoutMs(long consensusTimeoutMs) {
        this.consensusTimeoutMs = consensusTimeoutMs;
    }

    public void setFastAttempts(long fastAttempts) {
        this.fastAttempts = fastAttempts;
    }

    public void setAttemptDuration(long attemptDuration) {
        this.attemptDuration = attemptDuration;
    }

    public void setCatchainNaxDeps(long catchainNaxDeps) {
        this.catchainNaxDeps = catchainNaxDeps;
    }

    public void setMaxBlockBytes(long maxBlockBytes) {
        this.maxBlockBytes = maxBlockBytes;
    }

    public void setMaxCollatedBytes(long maxCollatedBytes) {
        this.maxCollatedBytes = maxCollatedBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsensusConfigV1)) {
            return false;
        }
        ConsensusConfigV1 other = (ConsensusConfigV1)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getRoundCandidates() != other.getRoundCandidates()) {
            return false;
        }
        if (this.getNextCandidateDelayMs() != other.getNextCandidateDelayMs()) {
            return false;
        }
        if (this.getConsensusTimeoutMs() != other.getConsensusTimeoutMs()) {
            return false;
        }
        if (this.getFastAttempts() != other.getFastAttempts()) {
            return false;
        }
        if (this.getAttemptDuration() != other.getAttemptDuration()) {
            return false;
        }
        if (this.getCatchainNaxDeps() != other.getCatchainNaxDeps()) {
            return false;
        }
        if (this.getMaxBlockBytes() != other.getMaxBlockBytes()) {
            return false;
        }
        return this.getMaxCollatedBytes() == other.getMaxCollatedBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsensusConfigV1;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getRoundCandidates();
        long $nextCandidateDelayMs = this.getNextCandidateDelayMs();
        result = result * 59 + (int)($nextCandidateDelayMs >>> 32 ^ $nextCandidateDelayMs);
        long $consensusTimeoutMs = this.getConsensusTimeoutMs();
        result = result * 59 + (int)($consensusTimeoutMs >>> 32 ^ $consensusTimeoutMs);
        long $fastAttempts = this.getFastAttempts();
        result = result * 59 + (int)($fastAttempts >>> 32 ^ $fastAttempts);
        long $attemptDuration = this.getAttemptDuration();
        result = result * 59 + (int)($attemptDuration >>> 32 ^ $attemptDuration);
        long $catchainNaxDeps = this.getCatchainNaxDeps();
        result = result * 59 + (int)($catchainNaxDeps >>> 32 ^ $catchainNaxDeps);
        long $maxBlockBytes = this.getMaxBlockBytes();
        result = result * 59 + (int)($maxBlockBytes >>> 32 ^ $maxBlockBytes);
        long $maxCollatedBytes = this.getMaxCollatedBytes();
        result = result * 59 + (int)($maxCollatedBytes >>> 32 ^ $maxCollatedBytes);
        return result;
    }

    public String toString() {
        return "ConsensusConfigV1(magic=" + this.getMagic() + ", roundCandidates=" + this.getRoundCandidates() + ", nextCandidateDelayMs=" + this.getNextCandidateDelayMs() + ", consensusTimeoutMs=" + this.getConsensusTimeoutMs() + ", fastAttempts=" + this.getFastAttempts() + ", attemptDuration=" + this.getAttemptDuration() + ", catchainNaxDeps=" + this.getCatchainNaxDeps() + ", maxBlockBytes=" + this.getMaxBlockBytes() + ", maxCollatedBytes=" + this.getMaxCollatedBytes() + ")";
    }

    public static class ConsensusConfigV1Builder {
        private int magic;
        private int roundCandidates;
        private long nextCandidateDelayMs;
        private long consensusTimeoutMs;
        private long fastAttempts;
        private long attemptDuration;
        private long catchainNaxDeps;
        private long maxBlockBytes;
        private long maxCollatedBytes;

        ConsensusConfigV1Builder() {
        }

        public ConsensusConfigV1Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ConsensusConfigV1Builder roundCandidates(int roundCandidates) {
            this.roundCandidates = roundCandidates;
            return this;
        }

        public ConsensusConfigV1Builder nextCandidateDelayMs(long nextCandidateDelayMs) {
            this.nextCandidateDelayMs = nextCandidateDelayMs;
            return this;
        }

        public ConsensusConfigV1Builder consensusTimeoutMs(long consensusTimeoutMs) {
            this.consensusTimeoutMs = consensusTimeoutMs;
            return this;
        }

        public ConsensusConfigV1Builder fastAttempts(long fastAttempts) {
            this.fastAttempts = fastAttempts;
            return this;
        }

        public ConsensusConfigV1Builder attemptDuration(long attemptDuration) {
            this.attemptDuration = attemptDuration;
            return this;
        }

        public ConsensusConfigV1Builder catchainNaxDeps(long catchainNaxDeps) {
            this.catchainNaxDeps = catchainNaxDeps;
            return this;
        }

        public ConsensusConfigV1Builder maxBlockBytes(long maxBlockBytes) {
            this.maxBlockBytes = maxBlockBytes;
            return this;
        }

        public ConsensusConfigV1Builder maxCollatedBytes(long maxCollatedBytes) {
            this.maxCollatedBytes = maxCollatedBytes;
            return this;
        }

        public ConsensusConfigV1 build() {
            return new ConsensusConfigV1(this.magic, this.roundCandidates, this.nextCandidateDelayMs, this.consensusTimeoutMs, this.fastAttempts, this.attemptDuration, this.catchainNaxDeps, this.maxBlockBytes, this.maxCollatedBytes);
        }

        public String toString() {
            return "ConsensusConfigV1.ConsensusConfigV1Builder(magic=" + this.magic + ", roundCandidates=" + this.roundCandidates + ", nextCandidateDelayMs=" + this.nextCandidateDelayMs + ", consensusTimeoutMs=" + this.consensusTimeoutMs + ", fastAttempts=" + this.fastAttempts + ", attemptDuration=" + this.attemptDuration + ", catchainNaxDeps=" + this.catchainNaxDeps + ", maxBlockBytes=" + this.maxBlockBytes + ", maxCollatedBytes=" + this.maxCollatedBytes + ")";
        }
    }
}

