/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ConsensusConfig;

public class ConsensusConfigNew
implements ConsensusConfig,
Serializable {
    int magic;
    int flags;
    boolean newCatchainIds;
    int roundCandidates;
    long nextCandidateDelayMs;
    long consensusTimeoutMs;
    long fastAttempts;
    long attemptDuration;
    long catchainNaxDeps;
    long maxBlockBytes;
    long maxCollatedBytes;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(215, 8).storeUint(this.flags, 7).storeBit(Boolean.valueOf(this.newCatchainIds)).storeUint(this.roundCandidates, 32).storeUint(this.nextCandidateDelayMs, 32).storeUint(this.consensusTimeoutMs, 32).storeUint(this.fastAttempts, 32).storeUint(this.attemptDuration, 32).storeUint(this.catchainNaxDeps, 32).storeUint(this.maxBlockBytes, 32).storeUint(this.maxCollatedBytes, 32).endCell();
    }

    public static ConsensusConfigNew deserialize(CellSlice cs) {
        return ConsensusConfigNew.builder().magic(cs.loadUint(8).intValue()).flags(cs.loadUint(7).intValue()).newCatchainIds(cs.loadBit()).roundCandidates(cs.loadUint(32).intValue()).nextCandidateDelayMs(cs.loadUint(32).longValue()).consensusTimeoutMs(cs.loadUint(32).longValue()).fastAttempts(cs.loadUint(32).longValue()).attemptDuration(cs.loadUint(32).longValue()).catchainNaxDeps(cs.loadUint(32).longValue()).maxBlockBytes(cs.loadUint(32).longValue()).maxCollatedBytes(cs.loadUint(32).longValue()).build();
    }

    ConsensusConfigNew(int magic, int flags, boolean newCatchainIds, int roundCandidates, long nextCandidateDelayMs, long consensusTimeoutMs, long fastAttempts, long attemptDuration, long catchainNaxDeps, long maxBlockBytes, long maxCollatedBytes) {
        this.magic = magic;
        this.flags = flags;
        this.newCatchainIds = newCatchainIds;
        this.roundCandidates = roundCandidates;
        this.nextCandidateDelayMs = nextCandidateDelayMs;
        this.consensusTimeoutMs = consensusTimeoutMs;
        this.fastAttempts = fastAttempts;
        this.attemptDuration = attemptDuration;
        this.catchainNaxDeps = catchainNaxDeps;
        this.maxBlockBytes = maxBlockBytes;
        this.maxCollatedBytes = maxCollatedBytes;
    }

    public static ConsensusConfigNewBuilder builder() {
        return new ConsensusConfigNewBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isNewCatchainIds() {
        return this.newCatchainIds;
    }

    public int getRoundCandidates() {
        return this.roundCandidates;
    }

    public long getNextCandidateDelayMs() {
        return this.nextCandidateDelayMs;
    }

    public long getConsensusTimeoutMs() {
        return this.consensusTimeoutMs;
    }

    public long getFastAttempts() {
        return this.fastAttempts;
    }

    public long getAttemptDuration() {
        return this.attemptDuration;
    }

    public long getCatchainNaxDeps() {
        return this.catchainNaxDeps;
    }

    public long getMaxBlockBytes() {
        return this.maxBlockBytes;
    }

    public long getMaxCollatedBytes() {
        return this.maxCollatedBytes;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setNewCatchainIds(boolean newCatchainIds) {
        this.newCatchainIds = newCatchainIds;
    }

    public void setRoundCandidates(int roundCandidates) {
        this.roundCandidates = roundCandidates;
    }

    public void setNextCandidateDelayMs(long nextCandidateDelayMs) {
        this.nextCandidateDelayMs = nextCandidateDelayMs;
    }

    public void setConsensusTimeoutMs(long consensusTimeoutMs) {
        this.consensusTimeoutMs = consensusTimeoutMs;
    }

    public void setFastAttempts(long fastAttempts) {
        this.fastAttempts = fastAttempts;
    }

    public void setAttemptDuration(long attemptDuration) {
        this.attemptDuration = attemptDuration;
    }

    public void setCatchainNaxDeps(long catchainNaxDeps) {
        this.catchainNaxDeps = catchainNaxDeps;
    }

    public void setMaxBlockBytes(long maxBlockBytes) {
        this.maxBlockBytes = maxBlockBytes;
    }

    public void setMaxCollatedBytes(long maxCollatedBytes) {
        this.maxCollatedBytes = maxCollatedBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConsensusConfigNew)) {
            return false;
        }
        ConsensusConfigNew other = (ConsensusConfigNew)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.isNewCatchainIds() != other.isNewCatchainIds()) {
            return false;
        }
        if (this.getRoundCandidates() != other.getRoundCandidates()) {
            return false;
        }
        if (this.getNextCandidateDelayMs() != other.getNextCandidateDelayMs()) {
            return false;
        }
        if (this.getConsensusTimeoutMs() != other.getConsensusTimeoutMs()) {
            return false;
        }
        if (this.getFastAttempts() != other.getFastAttempts()) {
            return false;
        }
        if (this.getAttemptDuration() != other.getAttemptDuration()) {
            return false;
        }
        if (this.getCatchainNaxDeps() != other.getCatchainNaxDeps()) {
            return false;
        }
        if (this.getMaxBlockBytes() != other.getMaxBlockBytes()) {
            return false;
        }
        return this.getMaxCollatedBytes() == other.getMaxCollatedBytes();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConsensusConfigNew;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getFlags();
        result = result * 59 + (this.isNewCatchainIds() ? 79 : 97);
        result = result * 59 + this.getRoundCandidates();
        long $nextCandidateDelayMs = this.getNextCandidateDelayMs();
        result = result * 59 + (int)($nextCandidateDelayMs >>> 32 ^ $nextCandidateDelayMs);
        long $consensusTimeoutMs = this.getConsensusTimeoutMs();
        result = result * 59 + (int)($consensusTimeoutMs >>> 32 ^ $consensusTimeoutMs);
        long $fastAttempts = this.getFastAttempts();
        result = result * 59 + (int)($fastAttempts >>> 32 ^ $fastAttempts);
        long $attemptDuration = this.getAttemptDuration();
        result = result * 59 + (int)($attemptDuration >>> 32 ^ $attemptDuration);
        long $catchainNaxDeps = this.getCatchainNaxDeps();
        result = result * 59 + (int)($catchainNaxDeps >>> 32 ^ $catchainNaxDeps);
        long $maxBlockBytes = this.getMaxBlockBytes();
        result = result * 59 + (int)($maxBlockBytes >>> 32 ^ $maxBlockBytes);
        long $maxCollatedBytes = this.getMaxCollatedBytes();
        result = result * 59 + (int)($maxCollatedBytes >>> 32 ^ $maxCollatedBytes);
        return result;
    }

    public String toString() {
        return "ConsensusConfigNew(magic=" + this.getMagic() + ", flags=" + this.getFlags() + ", newCatchainIds=" + this.isNewCatchainIds() + ", roundCandidates=" + this.getRoundCandidates() + ", nextCandidateDelayMs=" + this.getNextCandidateDelayMs() + ", consensusTimeoutMs=" + this.getConsensusTimeoutMs() + ", fastAttempts=" + this.getFastAttempts() + ", attemptDuration=" + this.getAttemptDuration() + ", catchainNaxDeps=" + this.getCatchainNaxDeps() + ", maxBlockBytes=" + this.getMaxBlockBytes() + ", maxCollatedBytes=" + this.getMaxCollatedBytes() + ")";
    }

    public static class ConsensusConfigNewBuilder {
        private int magic;
        private int flags;
        private boolean newCatchainIds;
        private int roundCandidates;
        private long nextCandidateDelayMs;
        private long consensusTimeoutMs;
        private long fastAttempts;
        private long attemptDuration;
        private long catchainNaxDeps;
        private long maxBlockBytes;
        private long maxCollatedBytes;

        ConsensusConfigNewBuilder() {
        }

        public ConsensusConfigNewBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ConsensusConfigNewBuilder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public ConsensusConfigNewBuilder newCatchainIds(boolean newCatchainIds) {
            this.newCatchainIds = newCatchainIds;
            return this;
        }

        public ConsensusConfigNewBuilder roundCandidates(int roundCandidates) {
            this.roundCandidates = roundCandidates;
            return this;
        }

        public ConsensusConfigNewBuilder nextCandidateDelayMs(long nextCandidateDelayMs) {
            this.nextCandidateDelayMs = nextCandidateDelayMs;
            return this;
        }

        public ConsensusConfigNewBuilder consensusTimeoutMs(long consensusTimeoutMs) {
            this.consensusTimeoutMs = consensusTimeoutMs;
            return this;
        }

        public ConsensusConfigNewBuilder fastAttempts(long fastAttempts) {
            this.fastAttempts = fastAttempts;
            return this;
        }

        public ConsensusConfigNewBuilder attemptDuration(long attemptDuration) {
            this.attemptDuration = attemptDuration;
            return this;
        }

        public ConsensusConfigNewBuilder catchainNaxDeps(long catchainNaxDeps) {
            this.catchainNaxDeps = catchainNaxDeps;
            return this;
        }

        public ConsensusConfigNewBuilder maxBlockBytes(long maxBlockBytes) {
            this.maxBlockBytes = maxBlockBytes;
            return this;
        }

        public ConsensusConfigNewBuilder maxCollatedBytes(long maxCollatedBytes) {
            this.maxCollatedBytes = maxCollatedBytes;
            return this;
        }

        public ConsensusConfigNew build() {
            return new ConsensusConfigNew(this.magic, this.flags, this.newCatchainIds, this.roundCandidates, this.nextCandidateDelayMs, this.consensusTimeoutMs, this.fastAttempts, this.attemptDuration, this.catchainNaxDeps, this.maxBlockBytes, this.maxCollatedBytes);
        }

        public String toString() {
            return "ConsensusConfigNew.ConsensusConfigNewBuilder(magic=" + this.magic + ", flags=" + this.flags + ", newCatchainIds=" + this.newCatchainIds + ", roundCandidates=" + this.roundCandidates + ", nextCandidateDelayMs=" + this.nextCandidateDelayMs + ", consensusTimeoutMs=" + this.consensusTimeoutMs + ", fastAttempts=" + this.fastAttempts + ", attemptDuration=" + this.attemptDuration + ", catchainNaxDeps=" + this.catchainNaxDeps + ", maxBlockBytes=" + this.maxBlockBytes + ", maxCollatedBytes=" + this.maxCollatedBytes + ")";
        }
    }
}

