/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.tlb.PrecompiledSmc;

public class ConfigParams45
implements Serializable {
    int magic;
    TonHashMapE precompiledContractsList;
    long suspendedUntil;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(192, 8).storeDict(this.precompiledContractsList.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((PrecompiledSmc)v).toCell()).endCell())).storeUint(this.suspendedUntil, 32).endCell();
    }

    public static ConfigParams45 deserialize(CellSlice cs) {
        return ConfigParams45.builder().magic(cs.loadUint(8).intValue()).precompiledContractsList(cs.loadDictE(256, k -> k.readUint(256), v -> PrecompiledSmc.deserialize(CellSlice.beginParse((Cell)v)))).build();
    }

    ConfigParams45(int magic, TonHashMapE precompiledContractsList, long suspendedUntil) {
        this.magic = magic;
        this.precompiledContractsList = precompiledContractsList;
        this.suspendedUntil = suspendedUntil;
    }

    public static ConfigParams45Builder builder() {
        return new ConfigParams45Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public TonHashMapE getPrecompiledContractsList() {
        return this.precompiledContractsList;
    }

    public long getSuspendedUntil() {
        return this.suspendedUntil;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setPrecompiledContractsList(TonHashMapE precompiledContractsList) {
        this.precompiledContractsList = precompiledContractsList;
    }

    public void setSuspendedUntil(long suspendedUntil) {
        this.suspendedUntil = suspendedUntil;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams45)) {
            return false;
        }
        ConfigParams45 other = (ConfigParams45)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getSuspendedUntil() != other.getSuspendedUntil()) {
            return false;
        }
        TonHashMapE this$precompiledContractsList = this.getPrecompiledContractsList();
        TonHashMapE other$precompiledContractsList = other.getPrecompiledContractsList();
        return !(this$precompiledContractsList == null ? other$precompiledContractsList != null : !this$precompiledContractsList.equals(other$precompiledContractsList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams45;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        long $suspendedUntil = this.getSuspendedUntil();
        result = result * 59 + (int)($suspendedUntil >>> 32 ^ $suspendedUntil);
        TonHashMapE $precompiledContractsList = this.getPrecompiledContractsList();
        result = result * 59 + ($precompiledContractsList == null ? 43 : $precompiledContractsList.hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams45(magic=" + this.getMagic() + ", precompiledContractsList=" + String.valueOf(this.getPrecompiledContractsList()) + ", suspendedUntil=" + this.getSuspendedUntil() + ")";
    }

    public static class ConfigParams45Builder {
        private int magic;
        private TonHashMapE precompiledContractsList;
        private long suspendedUntil;

        ConfigParams45Builder() {
        }

        public ConfigParams45Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public ConfigParams45Builder precompiledContractsList(TonHashMapE precompiledContractsList) {
            this.precompiledContractsList = precompiledContractsList;
            return this;
        }

        public ConfigParams45Builder suspendedUntil(long suspendedUntil) {
            this.suspendedUntil = suspendedUntil;
            return this;
        }

        public ConfigParams45 build() {
            return new ConfigParams45(this.magic, this.precompiledContractsList, this.suspendedUntil);
        }

        public String toString() {
            return "ConfigParams45.ConfigParams45Builder(magic=" + this.magic + ", precompiledContractsList=" + String.valueOf(this.precompiledContractsList) + ", suspendedUntil=" + this.suspendedUntil + ")";
        }
    }
}

