/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ConfigParams17
implements Serializable {
    BigInteger minStake;
    BigInteger maxStake;
    BigInteger minTotalStake;
    long maxStakeFactor;

    public Cell toCell() {
        return CellBuilder.beginCell().storeCoins(this.minStake).storeCoins(this.maxStake).storeCoins(this.minTotalStake).storeUint(this.maxStakeFactor, 16).endCell();
    }

    public static ConfigParams17 deserialize(CellSlice cs) {
        return ConfigParams17.builder().minStake(cs.loadCoins()).maxStake(cs.loadCoins()).minTotalStake(cs.loadCoins()).maxStakeFactor(cs.loadUint(32).longValue()).build();
    }

    ConfigParams17(BigInteger minStake, BigInteger maxStake, BigInteger minTotalStake, long maxStakeFactor) {
        this.minStake = minStake;
        this.maxStake = maxStake;
        this.minTotalStake = minTotalStake;
        this.maxStakeFactor = maxStakeFactor;
    }

    public static ConfigParams17Builder builder() {
        return new ConfigParams17Builder();
    }

    public BigInteger getMinStake() {
        return this.minStake;
    }

    public BigInteger getMaxStake() {
        return this.maxStake;
    }

    public BigInteger getMinTotalStake() {
        return this.minTotalStake;
    }

    public long getMaxStakeFactor() {
        return this.maxStakeFactor;
    }

    public void setMinStake(BigInteger minStake) {
        this.minStake = minStake;
    }

    public void setMaxStake(BigInteger maxStake) {
        this.maxStake = maxStake;
    }

    public void setMinTotalStake(BigInteger minTotalStake) {
        this.minTotalStake = minTotalStake;
    }

    public void setMaxStakeFactor(long maxStakeFactor) {
        this.maxStakeFactor = maxStakeFactor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams17)) {
            return false;
        }
        ConfigParams17 other = (ConfigParams17)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxStakeFactor() != other.getMaxStakeFactor()) {
            return false;
        }
        BigInteger this$minStake = this.getMinStake();
        BigInteger other$minStake = other.getMinStake();
        if (this$minStake == null ? other$minStake != null : !((Object)this$minStake).equals(other$minStake)) {
            return false;
        }
        BigInteger this$maxStake = this.getMaxStake();
        BigInteger other$maxStake = other.getMaxStake();
        if (this$maxStake == null ? other$maxStake != null : !((Object)this$maxStake).equals(other$maxStake)) {
            return false;
        }
        BigInteger this$minTotalStake = this.getMinTotalStake();
        BigInteger other$minTotalStake = other.getMinTotalStake();
        return !(this$minTotalStake == null ? other$minTotalStake != null : !((Object)this$minTotalStake).equals(other$minTotalStake));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams17;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxStakeFactor = this.getMaxStakeFactor();
        result = result * 59 + (int)($maxStakeFactor >>> 32 ^ $maxStakeFactor);
        BigInteger $minStake = this.getMinStake();
        result = result * 59 + ($minStake == null ? 43 : ((Object)$minStake).hashCode());
        BigInteger $maxStake = this.getMaxStake();
        result = result * 59 + ($maxStake == null ? 43 : ((Object)$maxStake).hashCode());
        BigInteger $minTotalStake = this.getMinTotalStake();
        result = result * 59 + ($minTotalStake == null ? 43 : ((Object)$minTotalStake).hashCode());
        return result;
    }

    public String toString() {
        return "ConfigParams17(minStake=" + String.valueOf(this.getMinStake()) + ", maxStake=" + String.valueOf(this.getMaxStake()) + ", minTotalStake=" + String.valueOf(this.getMinTotalStake()) + ", maxStakeFactor=" + this.getMaxStakeFactor() + ")";
    }

    public static class ConfigParams17Builder {
        private BigInteger minStake;
        private BigInteger maxStake;
        private BigInteger minTotalStake;
        private long maxStakeFactor;

        ConfigParams17Builder() {
        }

        public ConfigParams17Builder minStake(BigInteger minStake) {
            this.minStake = minStake;
            return this;
        }

        public ConfigParams17Builder maxStake(BigInteger maxStake) {
            this.maxStake = maxStake;
            return this;
        }

        public ConfigParams17Builder minTotalStake(BigInteger minTotalStake) {
            this.minTotalStake = minTotalStake;
            return this;
        }

        public ConfigParams17Builder maxStakeFactor(long maxStakeFactor) {
            this.maxStakeFactor = maxStakeFactor;
            return this;
        }

        public ConfigParams17 build() {
            return new ConfigParams17(this.minStake, this.maxStake, this.minTotalStake, this.maxStakeFactor);
        }

        public String toString() {
            return "ConfigParams17.ConfigParams17Builder(minStake=" + String.valueOf(this.minStake) + ", maxStake=" + String.valueOf(this.maxStake) + ", minTotalStake=" + String.valueOf(this.minTotalStake) + ", maxStakeFactor=" + this.maxStakeFactor + ")";
        }
    }
}

