/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ConfigParams16
implements Serializable {
    long maxValidators;
    long maxMainValidators;
    long minValidators;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.maxValidators, 16).storeUint(this.maxMainValidators, 16).storeUint(this.minValidators, 16).endCell();
    }

    public static ConfigParams16 deserialize(CellSlice cs) {
        return ConfigParams16.builder().maxValidators(cs.loadUint(16).longValue()).maxMainValidators(cs.loadUint(16).longValue()).minValidators(cs.loadUint(16).longValue()).build();
    }

    ConfigParams16(long maxValidators, long maxMainValidators, long minValidators) {
        this.maxValidators = maxValidators;
        this.maxMainValidators = maxMainValidators;
        this.minValidators = minValidators;
    }

    public static ConfigParams16Builder builder() {
        return new ConfigParams16Builder();
    }

    public long getMaxValidators() {
        return this.maxValidators;
    }

    public long getMaxMainValidators() {
        return this.maxMainValidators;
    }

    public long getMinValidators() {
        return this.minValidators;
    }

    public void setMaxValidators(long maxValidators) {
        this.maxValidators = maxValidators;
    }

    public void setMaxMainValidators(long maxMainValidators) {
        this.maxMainValidators = maxMainValidators;
    }

    public void setMinValidators(long minValidators) {
        this.minValidators = minValidators;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfigParams16)) {
            return false;
        }
        ConfigParams16 other = (ConfigParams16)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMaxValidators() != other.getMaxValidators()) {
            return false;
        }
        if (this.getMaxMainValidators() != other.getMaxMainValidators()) {
            return false;
        }
        return this.getMinValidators() == other.getMinValidators();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfigParams16;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maxValidators = this.getMaxValidators();
        result = result * 59 + (int)($maxValidators >>> 32 ^ $maxValidators);
        long $maxMainValidators = this.getMaxMainValidators();
        result = result * 59 + (int)($maxMainValidators >>> 32 ^ $maxMainValidators);
        long $minValidators = this.getMinValidators();
        result = result * 59 + (int)($minValidators >>> 32 ^ $minValidators);
        return result;
    }

    public String toString() {
        return "ConfigParams16(maxValidators=" + this.getMaxValidators() + ", maxMainValidators=" + this.getMaxMainValidators() + ", minValidators=" + this.getMinValidators() + ")";
    }

    public static class ConfigParams16Builder {
        private long maxValidators;
        private long maxMainValidators;
        private long minValidators;

        ConfigParams16Builder() {
        }

        public ConfigParams16Builder maxValidators(long maxValidators) {
            this.maxValidators = maxValidators;
            return this;
        }

        public ConfigParams16Builder maxMainValidators(long maxMainValidators) {
            this.maxMainValidators = maxMainValidators;
            return this;
        }

        public ConfigParams16Builder minValidators(long minValidators) {
            this.minValidators = minValidators;
            return this;
        }

        public ConfigParams16 build() {
            return new ConfigParams16(this.maxValidators, this.maxMainValidators, this.minValidators);
        }

        public String toString() {
            return "ConfigParams16.ConfigParams16Builder(maxValidators=" + this.maxValidators + ", maxMainValidators=" + this.maxMainValidators + ", minValidators=" + this.minValidators + ")";
        }
    }
}

