/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ComputePhase;

public class ComputeSkipReason
implements ComputePhase,
Serializable {
    String type;

    @Override
    public Cell toCell() {
        switch (this.type) {
            case "NO_STATE": {
                return CellBuilder.beginCell().storeUint(0, 2).endCell();
            }
            case "BAD_STATE": {
                return CellBuilder.beginCell().storeUint(1, 2).endCell();
            }
            case "NO_GAS": {
                return CellBuilder.beginCell().storeUint(2, 2).endCell();
            }
            case "SUSPENDED": {
                return CellBuilder.beginCell().storeUint(6, 3).endCell();
            }
        }
        throw new Error("unknown compute skip reason");
    }

    public static ComputePhase deserialize(CellSlice cs) {
        int skipReasonFlag = cs.loadUint(2).intValue();
        switch (skipReasonFlag) {
            case 0: {
                return ComputeSkipReason.builder().type("NO_STATE").build();
            }
            case 1: {
                return ComputeSkipReason.builder().type("BAD_STATE").build();
            }
            case 2: {
                return ComputeSkipReason.builder().type("NO_GAS").build();
            }
            case 3: {
                boolean isNotSuspended = cs.loadBit();
                if (isNotSuspended) break;
                return ComputeSkipReason.builder().type("SUSPENDED").build();
            }
        }
        throw new Error("unknown compute skip reason, found 0x" + Integer.toBinaryString(skipReasonFlag));
    }

    ComputeSkipReason(String type) {
        this.type = type;
    }

    public static ComputeSkipReasonBuilder builder() {
        return new ComputeSkipReasonBuilder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputeSkipReason)) {
            return false;
        }
        ComputeSkipReason other = (ComputeSkipReason)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputeSkipReason;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "ComputeSkipReason(type=" + this.getType() + ")";
    }

    public static class ComputeSkipReasonBuilder {
        private String type;

        ComputeSkipReasonBuilder() {
        }

        public ComputeSkipReasonBuilder type(String type) {
            this.type = type;
            return this;
        }

        public ComputeSkipReason build() {
            return new ComputeSkipReason(this.type);
        }

        public String toString() {
            return "ComputeSkipReason.ComputeSkipReasonBuilder(type=" + this.type + ")";
        }
    }
}

