/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class ComputePhaseVMDetails
implements Serializable {
    BigInteger gasUsed;
    BigInteger gasLimit;
    BigInteger gasCredit;
    int mode;
    long exitCode;
    BigInteger exitArg;
    long vMSteps;
    BigInteger vMInitStateHash;
    BigInteger vMFinalStateHash;

    public String getVmInitStateHashHex() {
        return Objects.nonNull(this.vMInitStateHash) ? this.vMInitStateHash.toString(16) : "";
    }

    public String getVmFinalStateHashHex() {
        return Objects.nonNull(this.vMFinalStateHash) ? this.vMFinalStateHash.toString(16) : "";
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeVarUint(this.gasUsed, 3).storeVarUint(this.gasLimit, 3).storeVarUintMaybe(this.gasCredit, 2).storeInt(this.mode, 8).storeInt(this.exitCode, 32).storeIntMaybe(this.exitArg, 32).storeUint(this.vMSteps, 32).storeUint(this.vMInitStateHash, 256).storeUint(this.vMFinalStateHash, 256).endCell();
    }

    public static ComputePhaseVMDetails deserialize(CellSlice cs) {
        return ComputePhaseVMDetails.builder().gasUsed(cs.loadVarUInteger(BigInteger.valueOf(3L))).gasLimit(cs.loadVarUInteger(BigInteger.valueOf(3L))).gasCredit(cs.loadBit() ? cs.loadVarUInteger(BigInteger.valueOf(2L)) : null).mode(cs.loadInt(8).intValue()).exitCode(cs.loadInt(32).longValue()).exitArg(cs.loadBit() ? cs.loadInt(32) : null).vMSteps(cs.loadUint(32).longValue()).vMInitStateHash(cs.loadUint(256)).vMFinalStateHash(cs.loadUint(256)).build();
    }

    ComputePhaseVMDetails(BigInteger gasUsed, BigInteger gasLimit, BigInteger gasCredit, int mode, long exitCode, BigInteger exitArg, long vMSteps, BigInteger vMInitStateHash, BigInteger vMFinalStateHash) {
        this.gasUsed = gasUsed;
        this.gasLimit = gasLimit;
        this.gasCredit = gasCredit;
        this.mode = mode;
        this.exitCode = exitCode;
        this.exitArg = exitArg;
        this.vMSteps = vMSteps;
        this.vMInitStateHash = vMInitStateHash;
        this.vMFinalStateHash = vMFinalStateHash;
    }

    public static ComputePhaseVMDetailsBuilder builder() {
        return new ComputePhaseVMDetailsBuilder();
    }

    public BigInteger getGasUsed() {
        return this.gasUsed;
    }

    public BigInteger getGasLimit() {
        return this.gasLimit;
    }

    public BigInteger getGasCredit() {
        return this.gasCredit;
    }

    public int getMode() {
        return this.mode;
    }

    public long getExitCode() {
        return this.exitCode;
    }

    public BigInteger getExitArg() {
        return this.exitArg;
    }

    public long getVMSteps() {
        return this.vMSteps;
    }

    public BigInteger getVMInitStateHash() {
        return this.vMInitStateHash;
    }

    public BigInteger getVMFinalStateHash() {
        return this.vMFinalStateHash;
    }

    public void setGasUsed(BigInteger gasUsed) {
        this.gasUsed = gasUsed;
    }

    public void setGasLimit(BigInteger gasLimit) {
        this.gasLimit = gasLimit;
    }

    public void setGasCredit(BigInteger gasCredit) {
        this.gasCredit = gasCredit;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setExitCode(long exitCode) {
        this.exitCode = exitCode;
    }

    public void setExitArg(BigInteger exitArg) {
        this.exitArg = exitArg;
    }

    public void setVMSteps(long vMSteps) {
        this.vMSteps = vMSteps;
    }

    public void setVMInitStateHash(BigInteger vMInitStateHash) {
        this.vMInitStateHash = vMInitStateHash;
    }

    public void setVMFinalStateHash(BigInteger vMFinalStateHash) {
        this.vMFinalStateHash = vMFinalStateHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComputePhaseVMDetails)) {
            return false;
        }
        ComputePhaseVMDetails other = (ComputePhaseVMDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMode() != other.getMode()) {
            return false;
        }
        if (this.getExitCode() != other.getExitCode()) {
            return false;
        }
        if (this.getVMSteps() != other.getVMSteps()) {
            return false;
        }
        BigInteger this$gasUsed = this.getGasUsed();
        BigInteger other$gasUsed = other.getGasUsed();
        if (this$gasUsed == null ? other$gasUsed != null : !((Object)this$gasUsed).equals(other$gasUsed)) {
            return false;
        }
        BigInteger this$gasLimit = this.getGasLimit();
        BigInteger other$gasLimit = other.getGasLimit();
        if (this$gasLimit == null ? other$gasLimit != null : !((Object)this$gasLimit).equals(other$gasLimit)) {
            return false;
        }
        BigInteger this$gasCredit = this.getGasCredit();
        BigInteger other$gasCredit = other.getGasCredit();
        if (this$gasCredit == null ? other$gasCredit != null : !((Object)this$gasCredit).equals(other$gasCredit)) {
            return false;
        }
        BigInteger this$exitArg = this.getExitArg();
        BigInteger other$exitArg = other.getExitArg();
        if (this$exitArg == null ? other$exitArg != null : !((Object)this$exitArg).equals(other$exitArg)) {
            return false;
        }
        BigInteger this$vMInitStateHash = this.getVMInitStateHash();
        BigInteger other$vMInitStateHash = other.getVMInitStateHash();
        if (this$vMInitStateHash == null ? other$vMInitStateHash != null : !((Object)this$vMInitStateHash).equals(other$vMInitStateHash)) {
            return false;
        }
        BigInteger this$vMFinalStateHash = this.getVMFinalStateHash();
        BigInteger other$vMFinalStateHash = other.getVMFinalStateHash();
        return !(this$vMFinalStateHash == null ? other$vMFinalStateHash != null : !((Object)this$vMFinalStateHash).equals(other$vMFinalStateHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ComputePhaseVMDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMode();
        long $exitCode = this.getExitCode();
        result = result * 59 + (int)($exitCode >>> 32 ^ $exitCode);
        long $vMSteps = this.getVMSteps();
        result = result * 59 + (int)($vMSteps >>> 32 ^ $vMSteps);
        BigInteger $gasUsed = this.getGasUsed();
        result = result * 59 + ($gasUsed == null ? 43 : ((Object)$gasUsed).hashCode());
        BigInteger $gasLimit = this.getGasLimit();
        result = result * 59 + ($gasLimit == null ? 43 : ((Object)$gasLimit).hashCode());
        BigInteger $gasCredit = this.getGasCredit();
        result = result * 59 + ($gasCredit == null ? 43 : ((Object)$gasCredit).hashCode());
        BigInteger $exitArg = this.getExitArg();
        result = result * 59 + ($exitArg == null ? 43 : ((Object)$exitArg).hashCode());
        BigInteger $vMInitStateHash = this.getVMInitStateHash();
        result = result * 59 + ($vMInitStateHash == null ? 43 : ((Object)$vMInitStateHash).hashCode());
        BigInteger $vMFinalStateHash = this.getVMFinalStateHash();
        result = result * 59 + ($vMFinalStateHash == null ? 43 : ((Object)$vMFinalStateHash).hashCode());
        return result;
    }

    public String toString() {
        return "ComputePhaseVMDetails(gasUsed=" + String.valueOf(this.getGasUsed()) + ", gasLimit=" + String.valueOf(this.getGasLimit()) + ", gasCredit=" + String.valueOf(this.getGasCredit()) + ", mode=" + this.getMode() + ", exitCode=" + this.getExitCode() + ", exitArg=" + String.valueOf(this.getExitArg()) + ", vMSteps=" + this.getVMSteps() + ", vMInitStateHash=" + String.valueOf(this.getVMInitStateHash()) + ", vMFinalStateHash=" + String.valueOf(this.getVMFinalStateHash()) + ", vmInitStateHashHex=" + this.getVmInitStateHashHex() + ", vmFinalStateHashHex=" + this.getVmFinalStateHashHex() + ")";
    }

    public static class ComputePhaseVMDetailsBuilder {
        private BigInteger gasUsed;
        private BigInteger gasLimit;
        private BigInteger gasCredit;
        private int mode;
        private long exitCode;
        private BigInteger exitArg;
        private long vMSteps;
        private BigInteger vMInitStateHash;
        private BigInteger vMFinalStateHash;

        ComputePhaseVMDetailsBuilder() {
        }

        public ComputePhaseVMDetailsBuilder gasUsed(BigInteger gasUsed) {
            this.gasUsed = gasUsed;
            return this;
        }

        public ComputePhaseVMDetailsBuilder gasLimit(BigInteger gasLimit) {
            this.gasLimit = gasLimit;
            return this;
        }

        public ComputePhaseVMDetailsBuilder gasCredit(BigInteger gasCredit) {
            this.gasCredit = gasCredit;
            return this;
        }

        public ComputePhaseVMDetailsBuilder mode(int mode) {
            this.mode = mode;
            return this;
        }

        public ComputePhaseVMDetailsBuilder exitCode(long exitCode) {
            this.exitCode = exitCode;
            return this;
        }

        public ComputePhaseVMDetailsBuilder exitArg(BigInteger exitArg) {
            this.exitArg = exitArg;
            return this;
        }

        public ComputePhaseVMDetailsBuilder vMSteps(long vMSteps) {
            this.vMSteps = vMSteps;
            return this;
        }

        public ComputePhaseVMDetailsBuilder vMInitStateHash(BigInteger vMInitStateHash) {
            this.vMInitStateHash = vMInitStateHash;
            return this;
        }

        public ComputePhaseVMDetailsBuilder vMFinalStateHash(BigInteger vMFinalStateHash) {
            this.vMFinalStateHash = vMFinalStateHash;
            return this;
        }

        public ComputePhaseVMDetails build() {
            return new ComputePhaseVMDetails(this.gasUsed, this.gasLimit, this.gasCredit, this.mode, this.exitCode, this.exitArg, this.vMSteps, this.vMInitStateHash, this.vMFinalStateHash);
        }

        public String toString() {
            return "ComputePhaseVMDetails.ComputePhaseVMDetailsBuilder(gasUsed=" + String.valueOf(this.gasUsed) + ", gasLimit=" + String.valueOf(this.gasLimit) + ", gasCredit=" + String.valueOf(this.gasCredit) + ", mode=" + this.mode + ", exitCode=" + this.exitCode + ", exitArg=" + String.valueOf(this.exitArg) + ", vMSteps=" + this.vMSteps + ", vMInitStateHash=" + String.valueOf(this.vMInitStateHash) + ", vMFinalStateHash=" + String.valueOf(this.vMFinalStateHash) + ")";
        }
    }
}

