/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.CatchainConfig;

public class CatchainConfigC2
implements CatchainConfig,
Serializable {
    int magic;
    int flags;
    boolean shuffleMcValidators;
    long mcCatchainLifetime;
    long shardCatchainLifetime;
    long shardValidatorsLifetime;
    long shardValidatorsNum;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(194, 8).storeUint(this.flags, 7).storeBit(Boolean.valueOf(this.shuffleMcValidators)).storeUint(this.mcCatchainLifetime, 32).storeUint(this.shardCatchainLifetime, 32).storeUint(this.shardValidatorsLifetime, 32).storeUint(this.shardValidatorsNum, 32).endCell();
    }

    public static CatchainConfigC2 deserialize(CellSlice cs) {
        return CatchainConfigC2.builder().magic(cs.loadUint(8).intValue()).flags(cs.loadUint(7).intValue()).shuffleMcValidators(cs.loadBit()).mcCatchainLifetime(cs.loadUint(32).longValue()).shardCatchainLifetime(cs.loadUint(32).longValue()).shardValidatorsLifetime(cs.loadUint(32).longValue()).shardValidatorsNum(cs.loadUint(32).longValue()).build();
    }

    CatchainConfigC2(int magic, int flags, boolean shuffleMcValidators, long mcCatchainLifetime, long shardCatchainLifetime, long shardValidatorsLifetime, long shardValidatorsNum) {
        this.magic = magic;
        this.flags = flags;
        this.shuffleMcValidators = shuffleMcValidators;
        this.mcCatchainLifetime = mcCatchainLifetime;
        this.shardCatchainLifetime = shardCatchainLifetime;
        this.shardValidatorsLifetime = shardValidatorsLifetime;
        this.shardValidatorsNum = shardValidatorsNum;
    }

    public static CatchainConfigC2Builder builder() {
        return new CatchainConfigC2Builder();
    }

    public int getMagic() {
        return this.magic;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isShuffleMcValidators() {
        return this.shuffleMcValidators;
    }

    public long getMcCatchainLifetime() {
        return this.mcCatchainLifetime;
    }

    public long getShardCatchainLifetime() {
        return this.shardCatchainLifetime;
    }

    public long getShardValidatorsLifetime() {
        return this.shardValidatorsLifetime;
    }

    public long getShardValidatorsNum() {
        return this.shardValidatorsNum;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public void setShuffleMcValidators(boolean shuffleMcValidators) {
        this.shuffleMcValidators = shuffleMcValidators;
    }

    public void setMcCatchainLifetime(long mcCatchainLifetime) {
        this.mcCatchainLifetime = mcCatchainLifetime;
    }

    public void setShardCatchainLifetime(long shardCatchainLifetime) {
        this.shardCatchainLifetime = shardCatchainLifetime;
    }

    public void setShardValidatorsLifetime(long shardValidatorsLifetime) {
        this.shardValidatorsLifetime = shardValidatorsLifetime;
    }

    public void setShardValidatorsNum(long shardValidatorsNum) {
        this.shardValidatorsNum = shardValidatorsNum;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CatchainConfigC2)) {
            return false;
        }
        CatchainConfigC2 other = (CatchainConfigC2)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.isShuffleMcValidators() != other.isShuffleMcValidators()) {
            return false;
        }
        if (this.getMcCatchainLifetime() != other.getMcCatchainLifetime()) {
            return false;
        }
        if (this.getShardCatchainLifetime() != other.getShardCatchainLifetime()) {
            return false;
        }
        if (this.getShardValidatorsLifetime() != other.getShardValidatorsLifetime()) {
            return false;
        }
        return this.getShardValidatorsNum() == other.getShardValidatorsNum();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CatchainConfigC2;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        result = result * 59 + this.getFlags();
        result = result * 59 + (this.isShuffleMcValidators() ? 79 : 97);
        long $mcCatchainLifetime = this.getMcCatchainLifetime();
        result = result * 59 + (int)($mcCatchainLifetime >>> 32 ^ $mcCatchainLifetime);
        long $shardCatchainLifetime = this.getShardCatchainLifetime();
        result = result * 59 + (int)($shardCatchainLifetime >>> 32 ^ $shardCatchainLifetime);
        long $shardValidatorsLifetime = this.getShardValidatorsLifetime();
        result = result * 59 + (int)($shardValidatorsLifetime >>> 32 ^ $shardValidatorsLifetime);
        long $shardValidatorsNum = this.getShardValidatorsNum();
        result = result * 59 + (int)($shardValidatorsNum >>> 32 ^ $shardValidatorsNum);
        return result;
    }

    public String toString() {
        return "CatchainConfigC2(magic=" + this.getMagic() + ", flags=" + this.getFlags() + ", shuffleMcValidators=" + this.isShuffleMcValidators() + ", mcCatchainLifetime=" + this.getMcCatchainLifetime() + ", shardCatchainLifetime=" + this.getShardCatchainLifetime() + ", shardValidatorsLifetime=" + this.getShardValidatorsLifetime() + ", shardValidatorsNum=" + this.getShardValidatorsNum() + ")";
    }

    public static class CatchainConfigC2Builder {
        private int magic;
        private int flags;
        private boolean shuffleMcValidators;
        private long mcCatchainLifetime;
        private long shardCatchainLifetime;
        private long shardValidatorsLifetime;
        private long shardValidatorsNum;

        CatchainConfigC2Builder() {
        }

        public CatchainConfigC2Builder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public CatchainConfigC2Builder flags(int flags) {
            this.flags = flags;
            return this;
        }

        public CatchainConfigC2Builder shuffleMcValidators(boolean shuffleMcValidators) {
            this.shuffleMcValidators = shuffleMcValidators;
            return this;
        }

        public CatchainConfigC2Builder mcCatchainLifetime(long mcCatchainLifetime) {
            this.mcCatchainLifetime = mcCatchainLifetime;
            return this;
        }

        public CatchainConfigC2Builder shardCatchainLifetime(long shardCatchainLifetime) {
            this.shardCatchainLifetime = shardCatchainLifetime;
            return this;
        }

        public CatchainConfigC2Builder shardValidatorsLifetime(long shardValidatorsLifetime) {
            this.shardValidatorsLifetime = shardValidatorsLifetime;
            return this;
        }

        public CatchainConfigC2Builder shardValidatorsNum(long shardValidatorsNum) {
            this.shardValidatorsNum = shardValidatorsNum;
            return this;
        }

        public CatchainConfigC2 build() {
            return new CatchainConfigC2(this.magic, this.flags, this.shuffleMcValidators, this.mcCatchainLifetime, this.shardCatchainLifetime, this.shardValidatorsLifetime, this.shardValidatorsNum);
        }

        public String toString() {
            return "CatchainConfigC2.CatchainConfigC2Builder(magic=" + this.magic + ", flags=" + this.flags + ", shuffleMcValidators=" + this.shuffleMcValidators + ", mcCatchainLifetime=" + this.mcCatchainLifetime + ", shardCatchainLifetime=" + this.shardCatchainLifetime + ", shardValidatorsLifetime=" + this.shardValidatorsLifetime + ", shardValidatorsNum=" + this.shardValidatorsNum + ")";
        }
    }
}

