/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BouncePhase;
import org.ton.java.tlb.StorageUsed;

public class BouncePhaseOk
implements BouncePhase,
Serializable {
    int magic;
    StorageUsed msgSize;
    BigInteger msgFees;
    BigInteger fwdFees;

    private String getMagic() {
        return Integer.toHexString(this.magic);
    }

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeBit(Boolean.valueOf(true)).storeSlice(CellSlice.beginParse((Cell)this.msgSize.toCell())).storeCoins(this.msgFees).storeCoins(this.fwdFees).endCell();
    }

    public static BouncePhaseOk deserialize(CellSlice cs) {
        long magic = cs.loadUint(1).intValue();
        assert (magic == 1L) : "BouncePhaseok: magic not equal to 0b1, found 0x" + Long.toHexString(magic);
        return BouncePhaseOk.builder().magic(1).msgSize(StorageUsed.deserialize(cs)).msgFees(cs.loadCoins()).fwdFees(cs.loadCoins()).build();
    }

    BouncePhaseOk(int magic, StorageUsed msgSize, BigInteger msgFees, BigInteger fwdFees) {
        this.magic = magic;
        this.msgSize = msgSize;
        this.msgFees = msgFees;
        this.fwdFees = fwdFees;
    }

    public static BouncePhaseOkBuilder builder() {
        return new BouncePhaseOkBuilder();
    }

    public StorageUsed getMsgSize() {
        return this.msgSize;
    }

    public BigInteger getMsgFees() {
        return this.msgFees;
    }

    public BigInteger getFwdFees() {
        return this.fwdFees;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setMsgSize(StorageUsed msgSize) {
        this.msgSize = msgSize;
    }

    public void setMsgFees(BigInteger msgFees) {
        this.msgFees = msgFees;
    }

    public void setFwdFees(BigInteger fwdFees) {
        this.fwdFees = fwdFees;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BouncePhaseOk)) {
            return false;
        }
        BouncePhaseOk other = (BouncePhaseOk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        StorageUsed this$msgSize = this.getMsgSize();
        StorageUsed other$msgSize = other.getMsgSize();
        if (this$msgSize == null ? other$msgSize != null : !((Object)this$msgSize).equals(other$msgSize)) {
            return false;
        }
        BigInteger this$msgFees = this.getMsgFees();
        BigInteger other$msgFees = other.getMsgFees();
        if (this$msgFees == null ? other$msgFees != null : !((Object)this$msgFees).equals(other$msgFees)) {
            return false;
        }
        BigInteger this$fwdFees = this.getFwdFees();
        BigInteger other$fwdFees = other.getFwdFees();
        return !(this$fwdFees == null ? other$fwdFees != null : !((Object)this$fwdFees).equals(other$fwdFees));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BouncePhaseOk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        StorageUsed $msgSize = this.getMsgSize();
        result = result * 59 + ($msgSize == null ? 43 : ((Object)$msgSize).hashCode());
        BigInteger $msgFees = this.getMsgFees();
        result = result * 59 + ($msgFees == null ? 43 : ((Object)$msgFees).hashCode());
        BigInteger $fwdFees = this.getFwdFees();
        result = result * 59 + ($fwdFees == null ? 43 : ((Object)$fwdFees).hashCode());
        return result;
    }

    public String toString() {
        return "BouncePhaseOk(magic=" + this.getMagic() + ", msgSize=" + String.valueOf(this.getMsgSize()) + ", msgFees=" + String.valueOf(this.getMsgFees()) + ", fwdFees=" + String.valueOf(this.getFwdFees()) + ")";
    }

    public static class BouncePhaseOkBuilder {
        private int magic;
        private StorageUsed msgSize;
        private BigInteger msgFees;
        private BigInteger fwdFees;

        BouncePhaseOkBuilder() {
        }

        public BouncePhaseOkBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public BouncePhaseOkBuilder msgSize(StorageUsed msgSize) {
            this.msgSize = msgSize;
            return this;
        }

        public BouncePhaseOkBuilder msgFees(BigInteger msgFees) {
            this.msgFees = msgFees;
            return this;
        }

        public BouncePhaseOkBuilder fwdFees(BigInteger fwdFees) {
            this.fwdFees = fwdFees;
            return this;
        }

        public BouncePhaseOk build() {
            return new BouncePhaseOk(this.magic, this.msgSize, this.msgFees, this.fwdFees);
        }

        public String toString() {
            return "BouncePhaseOk.BouncePhaseOkBuilder(magic=" + this.magic + ", msgSize=" + String.valueOf(this.msgSize) + ", msgFees=" + String.valueOf(this.msgFees) + ", fwdFees=" + String.valueOf(this.fwdFees) + ")";
        }
    }
}

