/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.utils.Utils;

public class Boc {
    long magic;
    boolean hasIdx;
    boolean hasCrc32c;
    boolean hasCacheBits;
    boolean hasTopHash;
    boolean hasIntHashes;
    int size;
    int offBytes;
    int cells;
    int roots;
    int absent;
    int totalCellsSize;
    List<BigInteger> rootList;
    List<BigInteger> index;
    byte[] cellData;
    long crc32c;

    public Cell toCell() {
        CellBuilder cell = CellBuilder.beginCell((int)((this.cells * this.offBytes + this.offBytes + this.size * 4 + this.totalCellsSize + 10) * 8)).storeInt(-1242653582, 32).storeBit(Boolean.valueOf(this.hasIdx)).storeBit(Boolean.valueOf(this.hasCrc32c)).storeBit(Boolean.valueOf(this.hasCacheBits)).storeBit(Boolean.valueOf(this.hasTopHash)).storeBit(Boolean.valueOf(this.hasIntHashes)).storeUint(this.size, 3).storeUint(this.offBytes, 8).storeUint(this.cells, this.size * 8).storeUint(this.roots, this.size * 8).storeUint(this.absent, this.size * 8).storeUint(this.totalCellsSize, this.offBytes * 8).storeList(this.rootList, this.size * 8);
        if (this.hasIdx) {
            cell.storeList(this.index, this.offBytes * 8);
        }
        cell.storeBytes(this.cellData, this.totalCellsSize * 8);
        if (this.hasCrc32c) {
            byte[] cellAsByteArray = cell.toSignedByteArray();
            byte[] checksum = Utils.getCRC32ChecksumAsBytesReversed((byte[])cellAsByteArray);
            cell.storeBytes(checksum, 32);
        }
        return cell.endCell();
    }

    public static Boc deserialize(CellSlice cs) {
        int magic = cs.loadUint(32).intValue();
        assert (magic == -1242653582) : "Boc: magic not equal to 0xb5ee9c72, found 0x" + Integer.toHexString(magic);
        Boc boc = Boc.builder().magic(magic).build();
        boc.setHasIdx(cs.loadBit());
        boc.setHasCrc32c(cs.loadBit());
        boc.setHasCacheBits(cs.loadBit());
        boc.setHasTopHash(cs.loadBit());
        boc.setHasIntHashes(cs.loadBit());
        boc.setSize(cs.loadUint(3).intValue());
        boc.setOffBytes(cs.loadUint(8).intValue());
        boc.setCells(cs.loadUint(boc.getSize() * 8).intValue());
        boc.setRoots(cs.loadUint(boc.getSize() * 8).intValue());
        boc.setAbsent(cs.loadUint(boc.getSize() * 8).intValue());
        boc.setTotalCellsSize(cs.loadUint(boc.getOffBytes() * 8).intValue());
        boc.setRootList(cs.loadList(boc.getRoots(), boc.getSize() * 8));
        boc.setIndex(boc.isHasIdx() ? cs.loadList(boc.getCells(), boc.getOffBytes() * 8) : null);
        boc.setCellData(cs.loadBytes(boc.getTotalCellsSize() * 8));
        boc.setCrc32c(boc.isHasCrc32c() ? cs.loadUint(32).longValue() : 0L);
        return boc;
    }

    Boc(long magic, boolean hasIdx, boolean hasCrc32c, boolean hasCacheBits, boolean hasTopHash, boolean hasIntHashes, int size, int offBytes, int cells, int roots, int absent, int totalCellsSize, List<BigInteger> rootList, List<BigInteger> index, byte[] cellData, long crc32c) {
        this.magic = magic;
        this.hasIdx = hasIdx;
        this.hasCrc32c = hasCrc32c;
        this.hasCacheBits = hasCacheBits;
        this.hasTopHash = hasTopHash;
        this.hasIntHashes = hasIntHashes;
        this.size = size;
        this.offBytes = offBytes;
        this.cells = cells;
        this.roots = roots;
        this.absent = absent;
        this.totalCellsSize = totalCellsSize;
        this.rootList = rootList;
        this.index = index;
        this.cellData = cellData;
        this.crc32c = crc32c;
    }

    public static BocBuilder builder() {
        return new BocBuilder();
    }

    public long getMagic() {
        return this.magic;
    }

    public boolean isHasIdx() {
        return this.hasIdx;
    }

    public boolean isHasCrc32c() {
        return this.hasCrc32c;
    }

    public boolean isHasCacheBits() {
        return this.hasCacheBits;
    }

    public boolean isHasTopHash() {
        return this.hasTopHash;
    }

    public boolean isHasIntHashes() {
        return this.hasIntHashes;
    }

    public int getSize() {
        return this.size;
    }

    public int getOffBytes() {
        return this.offBytes;
    }

    public int getCells() {
        return this.cells;
    }

    public int getRoots() {
        return this.roots;
    }

    public int getAbsent() {
        return this.absent;
    }

    public int getTotalCellsSize() {
        return this.totalCellsSize;
    }

    public List<BigInteger> getRootList() {
        return this.rootList;
    }

    public List<BigInteger> getIndex() {
        return this.index;
    }

    public byte[] getCellData() {
        return this.cellData;
    }

    public long getCrc32c() {
        return this.crc32c;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setHasIdx(boolean hasIdx) {
        this.hasIdx = hasIdx;
    }

    public void setHasCrc32c(boolean hasCrc32c) {
        this.hasCrc32c = hasCrc32c;
    }

    public void setHasCacheBits(boolean hasCacheBits) {
        this.hasCacheBits = hasCacheBits;
    }

    public void setHasTopHash(boolean hasTopHash) {
        this.hasTopHash = hasTopHash;
    }

    public void setHasIntHashes(boolean hasIntHashes) {
        this.hasIntHashes = hasIntHashes;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setOffBytes(int offBytes) {
        this.offBytes = offBytes;
    }

    public void setCells(int cells) {
        this.cells = cells;
    }

    public void setRoots(int roots) {
        this.roots = roots;
    }

    public void setAbsent(int absent) {
        this.absent = absent;
    }

    public void setTotalCellsSize(int totalCellsSize) {
        this.totalCellsSize = totalCellsSize;
    }

    public void setRootList(List<BigInteger> rootList) {
        this.rootList = rootList;
    }

    public void setIndex(List<BigInteger> index) {
        this.index = index;
    }

    public void setCellData(byte[] cellData) {
        this.cellData = cellData;
    }

    public void setCrc32c(long crc32c) {
        this.crc32c = crc32c;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Boc)) {
            return false;
        }
        Boc other = (Boc)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        if (this.isHasIdx() != other.isHasIdx()) {
            return false;
        }
        if (this.isHasCrc32c() != other.isHasCrc32c()) {
            return false;
        }
        if (this.isHasCacheBits() != other.isHasCacheBits()) {
            return false;
        }
        if (this.isHasTopHash() != other.isHasTopHash()) {
            return false;
        }
        if (this.isHasIntHashes() != other.isHasIntHashes()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getOffBytes() != other.getOffBytes()) {
            return false;
        }
        if (this.getCells() != other.getCells()) {
            return false;
        }
        if (this.getRoots() != other.getRoots()) {
            return false;
        }
        if (this.getAbsent() != other.getAbsent()) {
            return false;
        }
        if (this.getTotalCellsSize() != other.getTotalCellsSize()) {
            return false;
        }
        if (this.getCrc32c() != other.getCrc32c()) {
            return false;
        }
        List<BigInteger> this$rootList = this.getRootList();
        List<BigInteger> other$rootList = other.getRootList();
        if (this$rootList == null ? other$rootList != null : !((Object)this$rootList).equals(other$rootList)) {
            return false;
        }
        List<BigInteger> this$index = this.getIndex();
        List<BigInteger> other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        return Arrays.equals(this.getCellData(), other.getCellData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Boc;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $magic = this.getMagic();
        result = result * 59 + (int)($magic >>> 32 ^ $magic);
        result = result * 59 + (this.isHasIdx() ? 79 : 97);
        result = result * 59 + (this.isHasCrc32c() ? 79 : 97);
        result = result * 59 + (this.isHasCacheBits() ? 79 : 97);
        result = result * 59 + (this.isHasTopHash() ? 79 : 97);
        result = result * 59 + (this.isHasIntHashes() ? 79 : 97);
        result = result * 59 + this.getSize();
        result = result * 59 + this.getOffBytes();
        result = result * 59 + this.getCells();
        result = result * 59 + this.getRoots();
        result = result * 59 + this.getAbsent();
        result = result * 59 + this.getTotalCellsSize();
        long $crc32c = this.getCrc32c();
        result = result * 59 + (int)($crc32c >>> 32 ^ $crc32c);
        List<BigInteger> $rootList = this.getRootList();
        result = result * 59 + ($rootList == null ? 43 : ((Object)$rootList).hashCode());
        List<BigInteger> $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        result = result * 59 + Arrays.hashCode(this.getCellData());
        return result;
    }

    public String toString() {
        return "Boc(magic=" + this.getMagic() + ", hasIdx=" + this.isHasIdx() + ", hasCrc32c=" + this.isHasCrc32c() + ", hasCacheBits=" + this.isHasCacheBits() + ", hasTopHash=" + this.isHasTopHash() + ", hasIntHashes=" + this.isHasIntHashes() + ", size=" + this.getSize() + ", offBytes=" + this.getOffBytes() + ", cells=" + this.getCells() + ", roots=" + this.getRoots() + ", absent=" + this.getAbsent() + ", totalCellsSize=" + this.getTotalCellsSize() + ", rootList=" + String.valueOf(this.getRootList()) + ", index=" + String.valueOf(this.getIndex()) + ", cellData=" + Arrays.toString(this.getCellData()) + ", crc32c=" + this.getCrc32c() + ")";
    }

    public static class BocBuilder {
        private long magic;
        private boolean hasIdx;
        private boolean hasCrc32c;
        private boolean hasCacheBits;
        private boolean hasTopHash;
        private boolean hasIntHashes;
        private int size;
        private int offBytes;
        private int cells;
        private int roots;
        private int absent;
        private int totalCellsSize;
        private List<BigInteger> rootList;
        private List<BigInteger> index;
        private byte[] cellData;
        private long crc32c;

        BocBuilder() {
        }

        public BocBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public BocBuilder hasIdx(boolean hasIdx) {
            this.hasIdx = hasIdx;
            return this;
        }

        public BocBuilder hasCrc32c(boolean hasCrc32c) {
            this.hasCrc32c = hasCrc32c;
            return this;
        }

        public BocBuilder hasCacheBits(boolean hasCacheBits) {
            this.hasCacheBits = hasCacheBits;
            return this;
        }

        public BocBuilder hasTopHash(boolean hasTopHash) {
            this.hasTopHash = hasTopHash;
            return this;
        }

        public BocBuilder hasIntHashes(boolean hasIntHashes) {
            this.hasIntHashes = hasIntHashes;
            return this;
        }

        public BocBuilder size(int size) {
            this.size = size;
            return this;
        }

        public BocBuilder offBytes(int offBytes) {
            this.offBytes = offBytes;
            return this;
        }

        public BocBuilder cells(int cells) {
            this.cells = cells;
            return this;
        }

        public BocBuilder roots(int roots) {
            this.roots = roots;
            return this;
        }

        public BocBuilder absent(int absent) {
            this.absent = absent;
            return this;
        }

        public BocBuilder totalCellsSize(int totalCellsSize) {
            this.totalCellsSize = totalCellsSize;
            return this;
        }

        public BocBuilder rootList(List<BigInteger> rootList) {
            this.rootList = rootList;
            return this;
        }

        public BocBuilder index(List<BigInteger> index) {
            this.index = index;
            return this;
        }

        public BocBuilder cellData(byte[] cellData) {
            this.cellData = cellData;
            return this;
        }

        public BocBuilder crc32c(long crc32c) {
            this.crc32c = crc32c;
            return this;
        }

        public Boc build() {
            return new Boc(this.magic, this.hasIdx, this.hasCrc32c, this.hasCacheBits, this.hasTopHash, this.hasIntHashes, this.size, this.offBytes, this.cells, this.roots, this.absent, this.totalCellsSize, this.rootList, this.index, this.cellData, this.crc32c);
        }

        public String toString() {
            return "Boc.BocBuilder(magic=" + this.magic + ", hasIdx=" + this.hasIdx + ", hasCrc32c=" + this.hasCrc32c + ", hasCacheBits=" + this.hasCacheBits + ", hasTopHash=" + this.hasTopHash + ", hasIntHashes=" + this.hasIntHashes + ", size=" + this.size + ", offBytes=" + this.offBytes + ", cells=" + this.cells + ", roots=" + this.roots + ", absent=" + this.absent + ", totalCellsSize=" + this.totalCellsSize + ", rootList=" + String.valueOf(this.rootList) + ", index=" + String.valueOf(this.index) + ", cellData=" + Arrays.toString(this.cellData) + ", crc32c=" + this.crc32c + ")";
        }
    }
}

