/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BlockIdExtShardIdent;
import org.ton.java.tlb.BlockSignatures;

public class BlockProof
implements Serializable {
    int magic;
    BlockIdExtShardIdent proofFor;
    Cell root;
    BlockSignatures signatures;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(195, 8).storeCell(this.proofFor.toCell()).storeRef(this.root).storeRefMaybe(this.signatures.toCell()).endCell();
    }

    public static BlockProof deserialize(CellSlice cs) {
        long magic = cs.loadUint(8).longValue();
        assert (magic == 195L) : "BlockProof: magic not equal to 0xc3, found 0x" + Long.toHexString(magic);
        return BlockProof.builder().magic(195).proofFor(BlockIdExtShardIdent.deserialize(cs)).root(cs.loadRef()).signatures(cs.loadBit() ? BlockSignatures.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null).build();
    }

    BlockProof(int magic, BlockIdExtShardIdent proofFor, Cell root, BlockSignatures signatures) {
        this.magic = magic;
        this.proofFor = proofFor;
        this.root = root;
        this.signatures = signatures;
    }

    public static BlockProofBuilder builder() {
        return new BlockProofBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BlockIdExtShardIdent getProofFor() {
        return this.proofFor;
    }

    public Cell getRoot() {
        return this.root;
    }

    public BlockSignatures getSignatures() {
        return this.signatures;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setProofFor(BlockIdExtShardIdent proofFor) {
        this.proofFor = proofFor;
    }

    public void setRoot(Cell root) {
        this.root = root;
    }

    public void setSignatures(BlockSignatures signatures) {
        this.signatures = signatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockProof)) {
            return false;
        }
        BlockProof other = (BlockProof)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BlockIdExtShardIdent this$proofFor = this.getProofFor();
        BlockIdExtShardIdent other$proofFor = other.getProofFor();
        if (this$proofFor == null ? other$proofFor != null : !((Object)this$proofFor).equals(other$proofFor)) {
            return false;
        }
        Cell this$root = this.getRoot();
        Cell other$root = other.getRoot();
        if (this$root == null ? other$root != null : !this$root.equals(other$root)) {
            return false;
        }
        BlockSignatures this$signatures = this.getSignatures();
        BlockSignatures other$signatures = other.getSignatures();
        return !(this$signatures == null ? other$signatures != null : !((Object)this$signatures).equals(other$signatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockProof;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        BlockIdExtShardIdent $proofFor = this.getProofFor();
        result = result * 59 + ($proofFor == null ? 43 : ((Object)$proofFor).hashCode());
        Cell $root = this.getRoot();
        result = result * 59 + ($root == null ? 43 : $root.hashCode());
        BlockSignatures $signatures = this.getSignatures();
        result = result * 59 + ($signatures == null ? 43 : ((Object)$signatures).hashCode());
        return result;
    }

    public String toString() {
        return "BlockProof(magic=" + this.getMagic() + ", proofFor=" + String.valueOf(this.getProofFor()) + ", root=" + String.valueOf(this.getRoot()) + ", signatures=" + String.valueOf(this.getSignatures()) + ")";
    }

    public static class BlockProofBuilder {
        private int magic;
        private BlockIdExtShardIdent proofFor;
        private Cell root;
        private BlockSignatures signatures;

        BlockProofBuilder() {
        }

        public BlockProofBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public BlockProofBuilder proofFor(BlockIdExtShardIdent proofFor) {
            this.proofFor = proofFor;
            return this;
        }

        public BlockProofBuilder root(Cell root) {
            this.root = root;
            return this;
        }

        public BlockProofBuilder signatures(BlockSignatures signatures) {
            this.signatures = signatures;
            return this;
        }

        public BlockProof build() {
            return new BlockProof(this.magic, this.proofFor, this.root, this.signatures);
        }

        public String toString() {
            return "BlockProof.BlockProofBuilder(magic=" + this.magic + ", proofFor=" + String.valueOf(this.proofFor) + ", root=" + String.valueOf(this.root) + ", signatures=" + String.valueOf(this.signatures) + ")";
        }
    }
}

