/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ParamLimits;

public class BlockLimits
implements Serializable {
    int magic;
    ParamLimits bytes;
    ParamLimits gas;
    ParamLimits ltDelta;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(93, 8).storeCell(this.bytes.toCell()).storeCell(this.gas.toCell()).storeCell(this.ltDelta.toCell()).endCell();
    }

    public static BlockLimits deserialize(CellSlice cs) {
        return BlockLimits.builder().magic(cs.loadUint(8).intValue()).bytes(ParamLimits.deserialize(cs)).gas(ParamLimits.deserialize(cs)).ltDelta(ParamLimits.deserialize(cs)).build();
    }

    BlockLimits(int magic, ParamLimits bytes, ParamLimits gas, ParamLimits ltDelta) {
        this.magic = magic;
        this.bytes = bytes;
        this.gas = gas;
        this.ltDelta = ltDelta;
    }

    public static BlockLimitsBuilder builder() {
        return new BlockLimitsBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public ParamLimits getBytes() {
        return this.bytes;
    }

    public ParamLimits getGas() {
        return this.gas;
    }

    public ParamLimits getLtDelta() {
        return this.ltDelta;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setBytes(ParamLimits bytes) {
        this.bytes = bytes;
    }

    public void setGas(ParamLimits gas) {
        this.gas = gas;
    }

    public void setLtDelta(ParamLimits ltDelta) {
        this.ltDelta = ltDelta;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockLimits)) {
            return false;
        }
        BlockLimits other = (BlockLimits)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        ParamLimits this$bytes = this.getBytes();
        ParamLimits other$bytes = other.getBytes();
        if (this$bytes == null ? other$bytes != null : !((Object)this$bytes).equals(other$bytes)) {
            return false;
        }
        ParamLimits this$gas = this.getGas();
        ParamLimits other$gas = other.getGas();
        if (this$gas == null ? other$gas != null : !((Object)this$gas).equals(other$gas)) {
            return false;
        }
        ParamLimits this$ltDelta = this.getLtDelta();
        ParamLimits other$ltDelta = other.getLtDelta();
        return !(this$ltDelta == null ? other$ltDelta != null : !((Object)this$ltDelta).equals(other$ltDelta));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockLimits;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        ParamLimits $bytes = this.getBytes();
        result = result * 59 + ($bytes == null ? 43 : ((Object)$bytes).hashCode());
        ParamLimits $gas = this.getGas();
        result = result * 59 + ($gas == null ? 43 : ((Object)$gas).hashCode());
        ParamLimits $ltDelta = this.getLtDelta();
        result = result * 59 + ($ltDelta == null ? 43 : ((Object)$ltDelta).hashCode());
        return result;
    }

    public String toString() {
        return "BlockLimits(magic=" + this.getMagic() + ", bytes=" + String.valueOf(this.getBytes()) + ", gas=" + String.valueOf(this.getGas()) + ", ltDelta=" + String.valueOf(this.getLtDelta()) + ")";
    }

    public static class BlockLimitsBuilder {
        private int magic;
        private ParamLimits bytes;
        private ParamLimits gas;
        private ParamLimits ltDelta;

        BlockLimitsBuilder() {
        }

        public BlockLimitsBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public BlockLimitsBuilder bytes(ParamLimits bytes) {
            this.bytes = bytes;
            return this;
        }

        public BlockLimitsBuilder gas(ParamLimits gas) {
            this.gas = gas;
            return this;
        }

        public BlockLimitsBuilder ltDelta(ParamLimits ltDelta) {
            this.ltDelta = ltDelta;
            return this;
        }

        public BlockLimits build() {
            return new BlockLimits(this.magic, this.bytes, this.gas, this.ltDelta);
        }

        public String toString() {
            return "BlockLimits.BlockLimitsBuilder(magic=" + this.magic + ", bytes=" + String.valueOf(this.bytes) + ", gas=" + String.valueOf(this.gas) + ", ltDelta=" + String.valueOf(this.ltDelta) + ")";
        }
    }
}

