/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.BlkPrevInfo;
import org.ton.java.tlb.ExtBlkRef;
import org.ton.java.tlb.GlobalVersion;
import org.ton.java.tlb.ShardIdent;

public class BlockInfo
implements Serializable {
    long magic;
    long version;
    boolean notMaster;
    boolean afterMerge;
    boolean beforeSplit;
    boolean afterSplit;
    boolean wantSplit;
    boolean wantMerge;
    boolean keyBlock;
    boolean vertSeqnoIncr;
    long flags;
    long seqno;
    long vertSeqno;
    ShardIdent shard;
    long genuTime;
    BigInteger startLt;
    BigInteger endLt;
    long genValidatorListHashShort;
    long genCatchainSeqno;
    long minRefMcSeqno;
    long prevKeyBlockSeqno;
    GlobalVersion globalVersion;
    ExtBlkRef masterRef;
    BlkPrevInfo prevRef;
    BlkPrevInfo prevVertRef;

    private String getMagic() {
        return Long.toHexString(this.magic);
    }

    public Cell toCell() {
        CellBuilder result = CellBuilder.beginCell().storeUint(-1681413753, 32).storeUint(this.version, 32).storeBit(Boolean.valueOf(this.notMaster)).storeBit(Boolean.valueOf(this.afterMerge)).storeBit(Boolean.valueOf(this.beforeSplit)).storeBit(Boolean.valueOf(this.afterSplit)).storeBit(Boolean.valueOf(this.wantSplit)).storeBit(Boolean.valueOf(this.wantMerge)).storeBit(Boolean.valueOf(this.keyBlock)).storeBit(Boolean.valueOf(this.vertSeqnoIncr)).storeUint(this.flags, 8).storeUint(this.seqno, 32).storeUint(this.vertSeqno, 32).storeCell(this.shard.toCell()).storeUint(this.genuTime, 32).storeUint(this.startLt, 64).storeUint(this.endLt, 64).storeUint(this.genValidatorListHashShort, 32).storeUint(this.getGenCatchainSeqno(), 32).storeUint(this.minRefMcSeqno, 32).storeUint(this.prevKeyBlockSeqno, 32);
        if ((this.flags & 1L) == 1L) {
            result.storeCell(this.globalVersion.toCell());
        }
        if (this.notMaster) {
            result.storeRef(this.masterRef.toCell());
        }
        result.storeRef(this.prevRef.toCell(this.afterMerge));
        if (this.vertSeqnoIncr) {
            result.storeRef(this.prevVertRef.toCell(this.afterMerge));
        }
        return result.endCell();
    }

    public static BlockInfo deserialize(CellSlice cs) {
        BlockInfo blockInfo;
        long magic = cs.loadUint(32).longValue();
        assert (magic == 2613553543L) : "BlockInfo: magic not equal to 0x9bc7a987, found 0x" + Long.toHexString(magic);
        blockInfo.setGlobalVersion(((blockInfo = BlockInfo.builder().magic(2613553543L).version(cs.loadUint(32).longValue()).notMaster(cs.loadBit()).afterMerge(cs.loadBit()).beforeSplit(cs.loadBit()).afterSplit(cs.loadBit()).wantSplit(cs.loadBit()).wantMerge(cs.loadBit()).keyBlock(cs.loadBit()).vertSeqnoIncr(cs.loadBit()).flags(cs.loadUint(8).longValue()).seqno(cs.loadUint(32).longValue()).vertSeqno(cs.loadUint(32).longValue()).shard(ShardIdent.deserialize(cs)).genuTime(cs.loadUint(32).longValue()).startLt(cs.loadUint(64)).endLt(cs.loadUint(64)).genValidatorListHashShort(cs.loadUint(32).longValue()).genCatchainSeqno(cs.loadUint(32).longValue()).minRefMcSeqno(cs.loadUint(32).longValue()).prevKeyBlockSeqno(cs.loadUint(32).longValue()).build()).getFlags() & 1L) == 1L ? GlobalVersion.deserialize(cs) : null);
        blockInfo.setMasterRef(blockInfo.isNotMaster() ? ExtBlkRef.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null);
        blockInfo.setPrevRef(BlockInfo.loadBlkPrevInfo(CellSlice.beginParse((Cell)cs.loadRef()), blockInfo.isAfterMerge()));
        blockInfo.setPrevVertRef(blockInfo.isVertSeqnoIncr() ? BlockInfo.loadBlkPrevInfo(CellSlice.beginParse((Cell)cs.loadRef()), blockInfo.isAfterMerge()) : null);
        return blockInfo;
    }

    private static BlkPrevInfo loadBlkPrevInfo(CellSlice cs, boolean afterMerge) {
        BlkPrevInfo blkPrevInfo = BlkPrevInfo.builder().build();
        if (!afterMerge) {
            ExtBlkRef blkRef = ExtBlkRef.deserialize(cs);
            blkPrevInfo.setPrev1(blkRef);
            return blkPrevInfo;
        }
        ExtBlkRef blkRef1 = ExtBlkRef.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
        ExtBlkRef blkRef2 = ExtBlkRef.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
        blkPrevInfo.setPrev1(blkRef1);
        blkPrevInfo.setPrev2(blkRef2);
        return blkPrevInfo;
    }

    BlockInfo(long magic, long version, boolean notMaster, boolean afterMerge, boolean beforeSplit, boolean afterSplit, boolean wantSplit, boolean wantMerge, boolean keyBlock, boolean vertSeqnoIncr, long flags, long seqno, long vertSeqno, ShardIdent shard, long genuTime, BigInteger startLt, BigInteger endLt, long genValidatorListHashShort, long genCatchainSeqno, long minRefMcSeqno, long prevKeyBlockSeqno, GlobalVersion globalVersion, ExtBlkRef masterRef, BlkPrevInfo prevRef, BlkPrevInfo prevVertRef) {
        this.magic = magic;
        this.version = version;
        this.notMaster = notMaster;
        this.afterMerge = afterMerge;
        this.beforeSplit = beforeSplit;
        this.afterSplit = afterSplit;
        this.wantSplit = wantSplit;
        this.wantMerge = wantMerge;
        this.keyBlock = keyBlock;
        this.vertSeqnoIncr = vertSeqnoIncr;
        this.flags = flags;
        this.seqno = seqno;
        this.vertSeqno = vertSeqno;
        this.shard = shard;
        this.genuTime = genuTime;
        this.startLt = startLt;
        this.endLt = endLt;
        this.genValidatorListHashShort = genValidatorListHashShort;
        this.genCatchainSeqno = genCatchainSeqno;
        this.minRefMcSeqno = minRefMcSeqno;
        this.prevKeyBlockSeqno = prevKeyBlockSeqno;
        this.globalVersion = globalVersion;
        this.masterRef = masterRef;
        this.prevRef = prevRef;
        this.prevVertRef = prevVertRef;
    }

    public static BlockInfoBuilder builder() {
        return new BlockInfoBuilder();
    }

    public long getVersion() {
        return this.version;
    }

    public boolean isNotMaster() {
        return this.notMaster;
    }

    public boolean isAfterMerge() {
        return this.afterMerge;
    }

    public boolean isBeforeSplit() {
        return this.beforeSplit;
    }

    public boolean isAfterSplit() {
        return this.afterSplit;
    }

    public boolean isWantSplit() {
        return this.wantSplit;
    }

    public boolean isWantMerge() {
        return this.wantMerge;
    }

    public boolean isKeyBlock() {
        return this.keyBlock;
    }

    public boolean isVertSeqnoIncr() {
        return this.vertSeqnoIncr;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getSeqno() {
        return this.seqno;
    }

    public long getVertSeqno() {
        return this.vertSeqno;
    }

    public ShardIdent getShard() {
        return this.shard;
    }

    public long getGenuTime() {
        return this.genuTime;
    }

    public BigInteger getStartLt() {
        return this.startLt;
    }

    public BigInteger getEndLt() {
        return this.endLt;
    }

    public long getGenValidatorListHashShort() {
        return this.genValidatorListHashShort;
    }

    public long getGenCatchainSeqno() {
        return this.genCatchainSeqno;
    }

    public long getMinRefMcSeqno() {
        return this.minRefMcSeqno;
    }

    public long getPrevKeyBlockSeqno() {
        return this.prevKeyBlockSeqno;
    }

    public GlobalVersion getGlobalVersion() {
        return this.globalVersion;
    }

    public ExtBlkRef getMasterRef() {
        return this.masterRef;
    }

    public BlkPrevInfo getPrevRef() {
        return this.prevRef;
    }

    public BlkPrevInfo getPrevVertRef() {
        return this.prevVertRef;
    }

    public void setMagic(long magic) {
        this.magic = magic;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public void setNotMaster(boolean notMaster) {
        this.notMaster = notMaster;
    }

    public void setAfterMerge(boolean afterMerge) {
        this.afterMerge = afterMerge;
    }

    public void setBeforeSplit(boolean beforeSplit) {
        this.beforeSplit = beforeSplit;
    }

    public void setAfterSplit(boolean afterSplit) {
        this.afterSplit = afterSplit;
    }

    public void setWantSplit(boolean wantSplit) {
        this.wantSplit = wantSplit;
    }

    public void setWantMerge(boolean wantMerge) {
        this.wantMerge = wantMerge;
    }

    public void setKeyBlock(boolean keyBlock) {
        this.keyBlock = keyBlock;
    }

    public void setVertSeqnoIncr(boolean vertSeqnoIncr) {
        this.vertSeqnoIncr = vertSeqnoIncr;
    }

    public void setFlags(long flags) {
        this.flags = flags;
    }

    public void setSeqno(long seqno) {
        this.seqno = seqno;
    }

    public void setVertSeqno(long vertSeqno) {
        this.vertSeqno = vertSeqno;
    }

    public void setShard(ShardIdent shard) {
        this.shard = shard;
    }

    public void setGenuTime(long genuTime) {
        this.genuTime = genuTime;
    }

    public void setStartLt(BigInteger startLt) {
        this.startLt = startLt;
    }

    public void setEndLt(BigInteger endLt) {
        this.endLt = endLt;
    }

    public void setGenValidatorListHashShort(long genValidatorListHashShort) {
        this.genValidatorListHashShort = genValidatorListHashShort;
    }

    public void setGenCatchainSeqno(long genCatchainSeqno) {
        this.genCatchainSeqno = genCatchainSeqno;
    }

    public void setMinRefMcSeqno(long minRefMcSeqno) {
        this.minRefMcSeqno = minRefMcSeqno;
    }

    public void setPrevKeyBlockSeqno(long prevKeyBlockSeqno) {
        this.prevKeyBlockSeqno = prevKeyBlockSeqno;
    }

    public void setGlobalVersion(GlobalVersion globalVersion) {
        this.globalVersion = globalVersion;
    }

    public void setMasterRef(ExtBlkRef masterRef) {
        this.masterRef = masterRef;
    }

    public void setPrevRef(BlkPrevInfo prevRef) {
        this.prevRef = prevRef;
    }

    public void setPrevVertRef(BlkPrevInfo prevVertRef) {
        this.prevVertRef = prevVertRef;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockInfo)) {
            return false;
        }
        BlockInfo other = (BlockInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$magic = this.getMagic();
        String other$magic = other.getMagic();
        if (this$magic == null ? other$magic != null : !this$magic.equals(other$magic)) {
            return false;
        }
        if (this.getVersion() != other.getVersion()) {
            return false;
        }
        if (this.isNotMaster() != other.isNotMaster()) {
            return false;
        }
        if (this.isAfterMerge() != other.isAfterMerge()) {
            return false;
        }
        if (this.isBeforeSplit() != other.isBeforeSplit()) {
            return false;
        }
        if (this.isAfterSplit() != other.isAfterSplit()) {
            return false;
        }
        if (this.isWantSplit() != other.isWantSplit()) {
            return false;
        }
        if (this.isWantMerge() != other.isWantMerge()) {
            return false;
        }
        if (this.isKeyBlock() != other.isKeyBlock()) {
            return false;
        }
        if (this.isVertSeqnoIncr() != other.isVertSeqnoIncr()) {
            return false;
        }
        if (this.getFlags() != other.getFlags()) {
            return false;
        }
        if (this.getSeqno() != other.getSeqno()) {
            return false;
        }
        if (this.getVertSeqno() != other.getVertSeqno()) {
            return false;
        }
        if (this.getGenuTime() != other.getGenuTime()) {
            return false;
        }
        if (this.getGenValidatorListHashShort() != other.getGenValidatorListHashShort()) {
            return false;
        }
        if (this.getGenCatchainSeqno() != other.getGenCatchainSeqno()) {
            return false;
        }
        if (this.getMinRefMcSeqno() != other.getMinRefMcSeqno()) {
            return false;
        }
        if (this.getPrevKeyBlockSeqno() != other.getPrevKeyBlockSeqno()) {
            return false;
        }
        ShardIdent this$shard = this.getShard();
        ShardIdent other$shard = other.getShard();
        if (this$shard == null ? other$shard != null : !((Object)this$shard).equals(other$shard)) {
            return false;
        }
        BigInteger this$startLt = this.getStartLt();
        BigInteger other$startLt = other.getStartLt();
        if (this$startLt == null ? other$startLt != null : !((Object)this$startLt).equals(other$startLt)) {
            return false;
        }
        BigInteger this$endLt = this.getEndLt();
        BigInteger other$endLt = other.getEndLt();
        if (this$endLt == null ? other$endLt != null : !((Object)this$endLt).equals(other$endLt)) {
            return false;
        }
        GlobalVersion this$globalVersion = this.getGlobalVersion();
        GlobalVersion other$globalVersion = other.getGlobalVersion();
        if (this$globalVersion == null ? other$globalVersion != null : !((Object)this$globalVersion).equals(other$globalVersion)) {
            return false;
        }
        ExtBlkRef this$masterRef = this.getMasterRef();
        ExtBlkRef other$masterRef = other.getMasterRef();
        if (this$masterRef == null ? other$masterRef != null : !((Object)this$masterRef).equals(other$masterRef)) {
            return false;
        }
        BlkPrevInfo this$prevRef = this.getPrevRef();
        BlkPrevInfo other$prevRef = other.getPrevRef();
        if (this$prevRef == null ? other$prevRef != null : !((Object)this$prevRef).equals(other$prevRef)) {
            return false;
        }
        BlkPrevInfo this$prevVertRef = this.getPrevVertRef();
        BlkPrevInfo other$prevVertRef = other.getPrevVertRef();
        return !(this$prevVertRef == null ? other$prevVertRef != null : !((Object)this$prevVertRef).equals(other$prevVertRef));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $magic = this.getMagic();
        result = result * 59 + ($magic == null ? 43 : $magic.hashCode());
        long $version = this.getVersion();
        result = result * 59 + (int)($version >>> 32 ^ $version);
        result = result * 59 + (this.isNotMaster() ? 79 : 97);
        result = result * 59 + (this.isAfterMerge() ? 79 : 97);
        result = result * 59 + (this.isBeforeSplit() ? 79 : 97);
        result = result * 59 + (this.isAfterSplit() ? 79 : 97);
        result = result * 59 + (this.isWantSplit() ? 79 : 97);
        result = result * 59 + (this.isWantMerge() ? 79 : 97);
        result = result * 59 + (this.isKeyBlock() ? 79 : 97);
        result = result * 59 + (this.isVertSeqnoIncr() ? 79 : 97);
        long $flags = this.getFlags();
        result = result * 59 + (int)($flags >>> 32 ^ $flags);
        long $seqno = this.getSeqno();
        result = result * 59 + (int)($seqno >>> 32 ^ $seqno);
        long $vertSeqno = this.getVertSeqno();
        result = result * 59 + (int)($vertSeqno >>> 32 ^ $vertSeqno);
        long $genuTime = this.getGenuTime();
        result = result * 59 + (int)($genuTime >>> 32 ^ $genuTime);
        long $genValidatorListHashShort = this.getGenValidatorListHashShort();
        result = result * 59 + (int)($genValidatorListHashShort >>> 32 ^ $genValidatorListHashShort);
        long $genCatchainSeqno = this.getGenCatchainSeqno();
        result = result * 59 + (int)($genCatchainSeqno >>> 32 ^ $genCatchainSeqno);
        long $minRefMcSeqno = this.getMinRefMcSeqno();
        result = result * 59 + (int)($minRefMcSeqno >>> 32 ^ $minRefMcSeqno);
        long $prevKeyBlockSeqno = this.getPrevKeyBlockSeqno();
        result = result * 59 + (int)($prevKeyBlockSeqno >>> 32 ^ $prevKeyBlockSeqno);
        ShardIdent $shard = this.getShard();
        result = result * 59 + ($shard == null ? 43 : ((Object)$shard).hashCode());
        BigInteger $startLt = this.getStartLt();
        result = result * 59 + ($startLt == null ? 43 : ((Object)$startLt).hashCode());
        BigInteger $endLt = this.getEndLt();
        result = result * 59 + ($endLt == null ? 43 : ((Object)$endLt).hashCode());
        GlobalVersion $globalVersion = this.getGlobalVersion();
        result = result * 59 + ($globalVersion == null ? 43 : ((Object)$globalVersion).hashCode());
        ExtBlkRef $masterRef = this.getMasterRef();
        result = result * 59 + ($masterRef == null ? 43 : ((Object)$masterRef).hashCode());
        BlkPrevInfo $prevRef = this.getPrevRef();
        result = result * 59 + ($prevRef == null ? 43 : ((Object)$prevRef).hashCode());
        BlkPrevInfo $prevVertRef = this.getPrevVertRef();
        result = result * 59 + ($prevVertRef == null ? 43 : ((Object)$prevVertRef).hashCode());
        return result;
    }

    public String toString() {
        return "BlockInfo(magic=" + this.getMagic() + ", version=" + this.getVersion() + ", notMaster=" + this.isNotMaster() + ", afterMerge=" + this.isAfterMerge() + ", beforeSplit=" + this.isBeforeSplit() + ", afterSplit=" + this.isAfterSplit() + ", wantSplit=" + this.isWantSplit() + ", wantMerge=" + this.isWantMerge() + ", keyBlock=" + this.isKeyBlock() + ", vertSeqnoIncr=" + this.isVertSeqnoIncr() + ", flags=" + this.getFlags() + ", seqno=" + this.getSeqno() + ", vertSeqno=" + this.getVertSeqno() + ", shard=" + String.valueOf(this.getShard()) + ", genuTime=" + this.getGenuTime() + ", startLt=" + String.valueOf(this.getStartLt()) + ", endLt=" + String.valueOf(this.getEndLt()) + ", genValidatorListHashShort=" + this.getGenValidatorListHashShort() + ", genCatchainSeqno=" + this.getGenCatchainSeqno() + ", minRefMcSeqno=" + this.getMinRefMcSeqno() + ", prevKeyBlockSeqno=" + this.getPrevKeyBlockSeqno() + ", globalVersion=" + String.valueOf(this.getGlobalVersion()) + ", masterRef=" + String.valueOf(this.getMasterRef()) + ", prevRef=" + String.valueOf(this.getPrevRef()) + ", prevVertRef=" + String.valueOf(this.getPrevVertRef()) + ")";
    }

    public static class BlockInfoBuilder {
        private long magic;
        private long version;
        private boolean notMaster;
        private boolean afterMerge;
        private boolean beforeSplit;
        private boolean afterSplit;
        private boolean wantSplit;
        private boolean wantMerge;
        private boolean keyBlock;
        private boolean vertSeqnoIncr;
        private long flags;
        private long seqno;
        private long vertSeqno;
        private ShardIdent shard;
        private long genuTime;
        private BigInteger startLt;
        private BigInteger endLt;
        private long genValidatorListHashShort;
        private long genCatchainSeqno;
        private long minRefMcSeqno;
        private long prevKeyBlockSeqno;
        private GlobalVersion globalVersion;
        private ExtBlkRef masterRef;
        private BlkPrevInfo prevRef;
        private BlkPrevInfo prevVertRef;

        BlockInfoBuilder() {
        }

        public BlockInfoBuilder magic(long magic) {
            this.magic = magic;
            return this;
        }

        public BlockInfoBuilder version(long version) {
            this.version = version;
            return this;
        }

        public BlockInfoBuilder notMaster(boolean notMaster) {
            this.notMaster = notMaster;
            return this;
        }

        public BlockInfoBuilder afterMerge(boolean afterMerge) {
            this.afterMerge = afterMerge;
            return this;
        }

        public BlockInfoBuilder beforeSplit(boolean beforeSplit) {
            this.beforeSplit = beforeSplit;
            return this;
        }

        public BlockInfoBuilder afterSplit(boolean afterSplit) {
            this.afterSplit = afterSplit;
            return this;
        }

        public BlockInfoBuilder wantSplit(boolean wantSplit) {
            this.wantSplit = wantSplit;
            return this;
        }

        public BlockInfoBuilder wantMerge(boolean wantMerge) {
            this.wantMerge = wantMerge;
            return this;
        }

        public BlockInfoBuilder keyBlock(boolean keyBlock) {
            this.keyBlock = keyBlock;
            return this;
        }

        public BlockInfoBuilder vertSeqnoIncr(boolean vertSeqnoIncr) {
            this.vertSeqnoIncr = vertSeqnoIncr;
            return this;
        }

        public BlockInfoBuilder flags(long flags) {
            this.flags = flags;
            return this;
        }

        public BlockInfoBuilder seqno(long seqno) {
            this.seqno = seqno;
            return this;
        }

        public BlockInfoBuilder vertSeqno(long vertSeqno) {
            this.vertSeqno = vertSeqno;
            return this;
        }

        public BlockInfoBuilder shard(ShardIdent shard) {
            this.shard = shard;
            return this;
        }

        public BlockInfoBuilder genuTime(long genuTime) {
            this.genuTime = genuTime;
            return this;
        }

        public BlockInfoBuilder startLt(BigInteger startLt) {
            this.startLt = startLt;
            return this;
        }

        public BlockInfoBuilder endLt(BigInteger endLt) {
            this.endLt = endLt;
            return this;
        }

        public BlockInfoBuilder genValidatorListHashShort(long genValidatorListHashShort) {
            this.genValidatorListHashShort = genValidatorListHashShort;
            return this;
        }

        public BlockInfoBuilder genCatchainSeqno(long genCatchainSeqno) {
            this.genCatchainSeqno = genCatchainSeqno;
            return this;
        }

        public BlockInfoBuilder minRefMcSeqno(long minRefMcSeqno) {
            this.minRefMcSeqno = minRefMcSeqno;
            return this;
        }

        public BlockInfoBuilder prevKeyBlockSeqno(long prevKeyBlockSeqno) {
            this.prevKeyBlockSeqno = prevKeyBlockSeqno;
            return this;
        }

        public BlockInfoBuilder globalVersion(GlobalVersion globalVersion) {
            this.globalVersion = globalVersion;
            return this;
        }

        public BlockInfoBuilder masterRef(ExtBlkRef masterRef) {
            this.masterRef = masterRef;
            return this;
        }

        public BlockInfoBuilder prevRef(BlkPrevInfo prevRef) {
            this.prevRef = prevRef;
            return this;
        }

        public BlockInfoBuilder prevVertRef(BlkPrevInfo prevVertRef) {
            this.prevVertRef = prevVertRef;
            return this;
        }

        public BlockInfo build() {
            return new BlockInfo(this.magic, this.version, this.notMaster, this.afterMerge, this.beforeSplit, this.afterSplit, this.wantSplit, this.wantMerge, this.keyBlock, this.vertSeqnoIncr, this.flags, this.seqno, this.vertSeqno, this.shard, this.genuTime, this.startLt, this.endLt, this.genValidatorListHashShort, this.genCatchainSeqno, this.minRefMcSeqno, this.prevKeyBlockSeqno, this.globalVersion, this.masterRef, this.prevRef, this.prevVertRef);
        }

        public String toString() {
            return "BlockInfo.BlockInfoBuilder(magic=" + this.magic + ", version=" + this.version + ", notMaster=" + this.notMaster + ", afterMerge=" + this.afterMerge + ", beforeSplit=" + this.beforeSplit + ", afterSplit=" + this.afterSplit + ", wantSplit=" + this.wantSplit + ", wantMerge=" + this.wantMerge + ", keyBlock=" + this.keyBlock + ", vertSeqnoIncr=" + this.vertSeqnoIncr + ", flags=" + this.flags + ", seqno=" + this.seqno + ", vertSeqno=" + this.vertSeqno + ", shard=" + String.valueOf(this.shard) + ", genuTime=" + this.genuTime + ", startLt=" + String.valueOf(this.startLt) + ", endLt=" + String.valueOf(this.endLt) + ", genValidatorListHashShort=" + this.genValidatorListHashShort + ", genCatchainSeqno=" + this.genCatchainSeqno + ", minRefMcSeqno=" + this.minRefMcSeqno + ", prevKeyBlockSeqno=" + this.prevKeyBlockSeqno + ", globalVersion=" + String.valueOf(this.globalVersion) + ", masterRef=" + String.valueOf(this.masterRef) + ", prevRef=" + String.valueOf(this.prevRef) + ", prevVertRef=" + String.valueOf(this.prevVertRef) + ")";
        }
    }
}

