/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.lang3.tuple.Pair;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMapAugE;
import org.ton.java.tlb.AccountBlock;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.InMsgDescr;
import org.ton.java.tlb.McBlockExtra;
import org.ton.java.tlb.OutMsgDescr;

public class BlockExtra
implements Serializable {
    InMsgDescr inMsgDesc;
    OutMsgDescr outMsgDesc;
    TonHashMapAugE shardAccountBlocks;
    BigInteger randSeed;
    BigInteger createdBy;
    McBlockExtra mcBlockExtra;

    private String getRandSeed() {
        return this.randSeed.toString(16);
    }

    private String getCreatedBy() {
        return this.createdBy.toString(16);
    }

    public String toJson() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.JSON_STYLE);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeRef(this.inMsgDesc.toCell()).storeRef(this.outMsgDesc.toCell()).storeRef(this.shardAccountBlocks.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, 256).endCell().getBits(), v -> CellBuilder.beginCell().storeCell(((AccountBlock)v).toCell()), e -> CellBuilder.beginCell().storeCell(((CurrencyCollection)e).toCell()), (fk, fv) -> CellBuilder.beginCell().storeUint((Long)fk + (Long)fv, 32))).storeUint(this.randSeed, 256).storeUint(this.createdBy, 256).storeRefMaybe(this.mcBlockExtra.toCell()).endCell();
    }

    public static BlockExtra deserialize(CellSlice cs) {
        if (cs.isExotic()) {
            return null;
        }
        long magic = cs.loadUint(32).longValue();
        assert (magic == 1244919549L) : "Block: magic not equal to 0x4a33f6fdL, found 0x" + Long.toHexString(magic);
        InMsgDescr inMsgDescr = InMsgDescr.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
        OutMsgDescr outMsgDescr = OutMsgDescr.deserialize(CellSlice.beginParse((Cell)cs.loadRef()));
        BlockExtra blockExtra = BlockExtra.builder().inMsgDesc(inMsgDescr).outMsgDesc(outMsgDescr).shardAccountBlocks(CellSlice.beginParse((Cell)cs.loadRef()).loadDictAugE(256, k -> k.readUint(256), v -> v, e -> e)).randSeed(cs.loadUint(256)).createdBy(cs.loadUint(256)).build();
        blockExtra.setMcBlockExtra(cs.loadBit() ? McBlockExtra.deserialize(CellSlice.beginParse((Cell)cs.loadRef())) : null);
        return blockExtra;
    }

    public List<AccountBlock> getShardAccountBlocksAsList() {
        ArrayList<AccountBlock> accountBlocks = new ArrayList<AccountBlock>();
        for (Map.Entry entry : this.shardAccountBlocks.elements.entrySet()) {
            accountBlocks.add((AccountBlock)((Pair)entry.getValue()).getLeft());
        }
        return accountBlocks;
    }

    BlockExtra(InMsgDescr inMsgDesc, OutMsgDescr outMsgDesc, TonHashMapAugE shardAccountBlocks, BigInteger randSeed, BigInteger createdBy, McBlockExtra mcBlockExtra) {
        this.inMsgDesc = inMsgDesc;
        this.outMsgDesc = outMsgDesc;
        this.shardAccountBlocks = shardAccountBlocks;
        this.randSeed = randSeed;
        this.createdBy = createdBy;
        this.mcBlockExtra = mcBlockExtra;
    }

    public static BlockExtraBuilder builder() {
        return new BlockExtraBuilder();
    }

    public InMsgDescr getInMsgDesc() {
        return this.inMsgDesc;
    }

    public OutMsgDescr getOutMsgDesc() {
        return this.outMsgDesc;
    }

    public TonHashMapAugE getShardAccountBlocks() {
        return this.shardAccountBlocks;
    }

    public McBlockExtra getMcBlockExtra() {
        return this.mcBlockExtra;
    }

    public void setInMsgDesc(InMsgDescr inMsgDesc) {
        this.inMsgDesc = inMsgDesc;
    }

    public void setOutMsgDesc(OutMsgDescr outMsgDesc) {
        this.outMsgDesc = outMsgDesc;
    }

    public void setShardAccountBlocks(TonHashMapAugE shardAccountBlocks) {
        this.shardAccountBlocks = shardAccountBlocks;
    }

    public void setRandSeed(BigInteger randSeed) {
        this.randSeed = randSeed;
    }

    public void setCreatedBy(BigInteger createdBy) {
        this.createdBy = createdBy;
    }

    public void setMcBlockExtra(McBlockExtra mcBlockExtra) {
        this.mcBlockExtra = mcBlockExtra;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BlockExtra)) {
            return false;
        }
        BlockExtra other = (BlockExtra)o;
        if (!other.canEqual(this)) {
            return false;
        }
        InMsgDescr this$inMsgDesc = this.getInMsgDesc();
        InMsgDescr other$inMsgDesc = other.getInMsgDesc();
        if (this$inMsgDesc == null ? other$inMsgDesc != null : !((Object)this$inMsgDesc).equals(other$inMsgDesc)) {
            return false;
        }
        OutMsgDescr this$outMsgDesc = this.getOutMsgDesc();
        OutMsgDescr other$outMsgDesc = other.getOutMsgDesc();
        if (this$outMsgDesc == null ? other$outMsgDesc != null : !((Object)this$outMsgDesc).equals(other$outMsgDesc)) {
            return false;
        }
        TonHashMapAugE this$shardAccountBlocks = this.getShardAccountBlocks();
        TonHashMapAugE other$shardAccountBlocks = other.getShardAccountBlocks();
        if (this$shardAccountBlocks == null ? other$shardAccountBlocks != null : !this$shardAccountBlocks.equals(other$shardAccountBlocks)) {
            return false;
        }
        String this$randSeed = this.getRandSeed();
        String other$randSeed = other.getRandSeed();
        if (this$randSeed == null ? other$randSeed != null : !this$randSeed.equals(other$randSeed)) {
            return false;
        }
        String this$createdBy = this.getCreatedBy();
        String other$createdBy = other.getCreatedBy();
        if (this$createdBy == null ? other$createdBy != null : !this$createdBy.equals(other$createdBy)) {
            return false;
        }
        McBlockExtra this$mcBlockExtra = this.getMcBlockExtra();
        McBlockExtra other$mcBlockExtra = other.getMcBlockExtra();
        return !(this$mcBlockExtra == null ? other$mcBlockExtra != null : !((Object)this$mcBlockExtra).equals(other$mcBlockExtra));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BlockExtra;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        InMsgDescr $inMsgDesc = this.getInMsgDesc();
        result = result * 59 + ($inMsgDesc == null ? 43 : ((Object)$inMsgDesc).hashCode());
        OutMsgDescr $outMsgDesc = this.getOutMsgDesc();
        result = result * 59 + ($outMsgDesc == null ? 43 : ((Object)$outMsgDesc).hashCode());
        TonHashMapAugE $shardAccountBlocks = this.getShardAccountBlocks();
        result = result * 59 + ($shardAccountBlocks == null ? 43 : $shardAccountBlocks.hashCode());
        String $randSeed = this.getRandSeed();
        result = result * 59 + ($randSeed == null ? 43 : $randSeed.hashCode());
        String $createdBy = this.getCreatedBy();
        result = result * 59 + ($createdBy == null ? 43 : $createdBy.hashCode());
        McBlockExtra $mcBlockExtra = this.getMcBlockExtra();
        result = result * 59 + ($mcBlockExtra == null ? 43 : ((Object)$mcBlockExtra).hashCode());
        return result;
    }

    public String toString() {
        return "BlockExtra(inMsgDesc=" + String.valueOf(this.getInMsgDesc()) + ", outMsgDesc=" + String.valueOf(this.getOutMsgDesc()) + ", shardAccountBlocks=" + String.valueOf(this.getShardAccountBlocks()) + ", randSeed=" + this.getRandSeed() + ", createdBy=" + this.getCreatedBy() + ", mcBlockExtra=" + String.valueOf(this.getMcBlockExtra()) + ")";
    }

    public static class BlockExtraBuilder {
        private InMsgDescr inMsgDesc;
        private OutMsgDescr outMsgDesc;
        private TonHashMapAugE shardAccountBlocks;
        private BigInteger randSeed;
        private BigInteger createdBy;
        private McBlockExtra mcBlockExtra;

        BlockExtraBuilder() {
        }

        public BlockExtraBuilder inMsgDesc(InMsgDescr inMsgDesc) {
            this.inMsgDesc = inMsgDesc;
            return this;
        }

        public BlockExtraBuilder outMsgDesc(OutMsgDescr outMsgDesc) {
            this.outMsgDesc = outMsgDesc;
            return this;
        }

        public BlockExtraBuilder shardAccountBlocks(TonHashMapAugE shardAccountBlocks) {
            this.shardAccountBlocks = shardAccountBlocks;
            return this;
        }

        public BlockExtraBuilder randSeed(BigInteger randSeed) {
            this.randSeed = randSeed;
            return this;
        }

        public BlockExtraBuilder createdBy(BigInteger createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public BlockExtraBuilder mcBlockExtra(McBlockExtra mcBlockExtra) {
            this.mcBlockExtra = mcBlockExtra;
            return this;
        }

        public BlockExtra build() {
            return new BlockExtra(this.inMsgDesc, this.outMsgDesc, this.shardAccountBlocks, this.randSeed, this.createdBy, this.mcBlockExtra);
        }

        public String toString() {
            return "BlockExtra.BlockExtraBuilder(inMsgDesc=" + String.valueOf(this.inMsgDesc) + ", outMsgDesc=" + String.valueOf(this.outMsgDesc) + ", shardAccountBlocks=" + String.valueOf(this.shardAccountBlocks) + ", randSeed=" + String.valueOf(this.randSeed) + ", createdBy=" + String.valueOf(this.createdBy) + ", mcBlockExtra=" + String.valueOf(this.mcBlockExtra) + ")";
        }
    }
}

