/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class Anycast
implements Serializable {
    int depth;
    byte rewritePfx;

    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(this.depth, 5).storeUint((short)this.rewritePfx, this.depth).endCell();
    }

    public static Anycast deserialize(CellSlice cs) {
        int depth = cs.loadUint(5).intValue();
        return Anycast.builder().depth(depth).rewritePfx(cs.loadUint(depth).byteValueExact()).build();
    }

    Anycast(int depth, byte rewritePfx) {
        this.depth = depth;
        this.rewritePfx = rewritePfx;
    }

    public static AnycastBuilder builder() {
        return new AnycastBuilder();
    }

    public int getDepth() {
        return this.depth;
    }

    public byte getRewritePfx() {
        return this.rewritePfx;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public void setRewritePfx(byte rewritePfx) {
        this.rewritePfx = rewritePfx;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anycast)) {
            return false;
        }
        Anycast other = (Anycast)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDepth() != other.getDepth()) {
            return false;
        }
        return this.getRewritePfx() == other.getRewritePfx();
    }

    protected boolean canEqual(Object other) {
        return other instanceof Anycast;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getDepth();
        result = result * 59 + this.getRewritePfx();
        return result;
    }

    public String toString() {
        return "Anycast(depth=" + this.getDepth() + ", rewritePfx=" + this.getRewritePfx() + ")";
    }

    public static class AnycastBuilder {
        private int depth;
        private byte rewritePfx;

        AnycastBuilder() {
        }

        public AnycastBuilder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public AnycastBuilder rewritePfx(byte rewritePfx) {
            this.rewritePfx = rewritePfx;
            return this;
        }

        public Anycast build() {
            return new Anycast(this.depth, this.rewritePfx);
        }

        public String toString() {
            return "Anycast.AnycastBuilder(depth=" + this.depth + ", rewritePfx=" + this.rewritePfx + ")";
        }
    }
}

