/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccStatusChange;
import org.ton.java.tlb.StorageUsed;

public class ActionPhase
implements Serializable {
    boolean success;
    boolean valid;
    boolean noFunds;
    AccStatusChange statusChange;
    BigInteger totalFwdFees;
    BigInteger totalActionFees;
    long resultCode;
    BigInteger resultArg;
    long totalActions;
    long specActions;
    long skippedActions;
    long messagesCreated;
    BigInteger actionListHash;
    StorageUsed totalMsgSize;

    private String getActionListHash() {
        return this.actionListHash.toString(16);
    }

    public Cell toCell() {
        return CellBuilder.beginCell().storeBit(Boolean.valueOf(this.success)).storeBit(Boolean.valueOf(this.valid)).storeBit(Boolean.valueOf(this.noFunds)).storeCell(this.statusChange.toCell()).storeCoinsMaybe(this.totalFwdFees).storeCoinsMaybe(this.totalActionFees).storeInt(this.resultCode, 32).storeIntMaybe(this.resultArg, 32).storeUint(this.totalActions, 16).storeUint(this.specActions, 16).storeUint(this.skippedActions, 16).storeUint(this.messagesCreated, 16).storeUintMaybe(this.actionListHash, 256).storeSlice(CellSlice.beginParse((Cell)this.totalMsgSize.toCell())).endCell();
    }

    public static ActionPhase deserialize(CellSlice cs) {
        return ActionPhase.builder().success(cs.loadBit()).valid(cs.loadBit()).noFunds(cs.loadBit()).statusChange(AccStatusChange.deserialize(cs)).totalFwdFees(cs.loadBit() ? cs.loadCoins() : null).totalActionFees(cs.loadBit() ? cs.loadCoins() : null).resultCode(cs.loadInt(32).longValue()).resultArg(cs.loadBit() ? cs.loadInt(32) : null).totalActions(cs.loadUint(16).longValue()).specActions(cs.loadUint(16).longValue()).skippedActions(cs.loadUint(16).longValue()).messagesCreated(cs.loadUint(16).longValue()).actionListHash(cs.loadUint(256)).totalMsgSize(StorageUsed.deserialize(cs)).build();
    }

    ActionPhase(boolean success, boolean valid, boolean noFunds, AccStatusChange statusChange, BigInteger totalFwdFees, BigInteger totalActionFees, long resultCode, BigInteger resultArg, long totalActions, long specActions, long skippedActions, long messagesCreated, BigInteger actionListHash, StorageUsed totalMsgSize) {
        this.success = success;
        this.valid = valid;
        this.noFunds = noFunds;
        this.statusChange = statusChange;
        this.totalFwdFees = totalFwdFees;
        this.totalActionFees = totalActionFees;
        this.resultCode = resultCode;
        this.resultArg = resultArg;
        this.totalActions = totalActions;
        this.specActions = specActions;
        this.skippedActions = skippedActions;
        this.messagesCreated = messagesCreated;
        this.actionListHash = actionListHash;
        this.totalMsgSize = totalMsgSize;
    }

    public static ActionPhaseBuilder builder() {
        return new ActionPhaseBuilder();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public boolean isValid() {
        return this.valid;
    }

    public boolean isNoFunds() {
        return this.noFunds;
    }

    public AccStatusChange getStatusChange() {
        return this.statusChange;
    }

    public BigInteger getTotalFwdFees() {
        return this.totalFwdFees;
    }

    public BigInteger getTotalActionFees() {
        return this.totalActionFees;
    }

    public long getResultCode() {
        return this.resultCode;
    }

    public BigInteger getResultArg() {
        return this.resultArg;
    }

    public long getTotalActions() {
        return this.totalActions;
    }

    public long getSpecActions() {
        return this.specActions;
    }

    public long getSkippedActions() {
        return this.skippedActions;
    }

    public long getMessagesCreated() {
        return this.messagesCreated;
    }

    public StorageUsed getTotalMsgSize() {
        return this.totalMsgSize;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void setNoFunds(boolean noFunds) {
        this.noFunds = noFunds;
    }

    public void setStatusChange(AccStatusChange statusChange) {
        this.statusChange = statusChange;
    }

    public void setTotalFwdFees(BigInteger totalFwdFees) {
        this.totalFwdFees = totalFwdFees;
    }

    public void setTotalActionFees(BigInteger totalActionFees) {
        this.totalActionFees = totalActionFees;
    }

    public void setResultCode(long resultCode) {
        this.resultCode = resultCode;
    }

    public void setResultArg(BigInteger resultArg) {
        this.resultArg = resultArg;
    }

    public void setTotalActions(long totalActions) {
        this.totalActions = totalActions;
    }

    public void setSpecActions(long specActions) {
        this.specActions = specActions;
    }

    public void setSkippedActions(long skippedActions) {
        this.skippedActions = skippedActions;
    }

    public void setMessagesCreated(long messagesCreated) {
        this.messagesCreated = messagesCreated;
    }

    public void setActionListHash(BigInteger actionListHash) {
        this.actionListHash = actionListHash;
    }

    public void setTotalMsgSize(StorageUsed totalMsgSize) {
        this.totalMsgSize = totalMsgSize;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionPhase)) {
            return false;
        }
        ActionPhase other = (ActionPhase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        if (this.isNoFunds() != other.isNoFunds()) {
            return false;
        }
        if (this.getResultCode() != other.getResultCode()) {
            return false;
        }
        if (this.getTotalActions() != other.getTotalActions()) {
            return false;
        }
        if (this.getSpecActions() != other.getSpecActions()) {
            return false;
        }
        if (this.getSkippedActions() != other.getSkippedActions()) {
            return false;
        }
        if (this.getMessagesCreated() != other.getMessagesCreated()) {
            return false;
        }
        AccStatusChange this$statusChange = this.getStatusChange();
        AccStatusChange other$statusChange = other.getStatusChange();
        if (this$statusChange == null ? other$statusChange != null : !((Object)this$statusChange).equals(other$statusChange)) {
            return false;
        }
        BigInteger this$totalFwdFees = this.getTotalFwdFees();
        BigInteger other$totalFwdFees = other.getTotalFwdFees();
        if (this$totalFwdFees == null ? other$totalFwdFees != null : !((Object)this$totalFwdFees).equals(other$totalFwdFees)) {
            return false;
        }
        BigInteger this$totalActionFees = this.getTotalActionFees();
        BigInteger other$totalActionFees = other.getTotalActionFees();
        if (this$totalActionFees == null ? other$totalActionFees != null : !((Object)this$totalActionFees).equals(other$totalActionFees)) {
            return false;
        }
        BigInteger this$resultArg = this.getResultArg();
        BigInteger other$resultArg = other.getResultArg();
        if (this$resultArg == null ? other$resultArg != null : !((Object)this$resultArg).equals(other$resultArg)) {
            return false;
        }
        String this$actionListHash = this.getActionListHash();
        String other$actionListHash = other.getActionListHash();
        if (this$actionListHash == null ? other$actionListHash != null : !this$actionListHash.equals(other$actionListHash)) {
            return false;
        }
        StorageUsed this$totalMsgSize = this.getTotalMsgSize();
        StorageUsed other$totalMsgSize = other.getTotalMsgSize();
        return !(this$totalMsgSize == null ? other$totalMsgSize != null : !((Object)this$totalMsgSize).equals(other$totalMsgSize));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionPhase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        result = result * 59 + (this.isValid() ? 79 : 97);
        result = result * 59 + (this.isNoFunds() ? 79 : 97);
        long $resultCode = this.getResultCode();
        result = result * 59 + (int)($resultCode >>> 32 ^ $resultCode);
        long $totalActions = this.getTotalActions();
        result = result * 59 + (int)($totalActions >>> 32 ^ $totalActions);
        long $specActions = this.getSpecActions();
        result = result * 59 + (int)($specActions >>> 32 ^ $specActions);
        long $skippedActions = this.getSkippedActions();
        result = result * 59 + (int)($skippedActions >>> 32 ^ $skippedActions);
        long $messagesCreated = this.getMessagesCreated();
        result = result * 59 + (int)($messagesCreated >>> 32 ^ $messagesCreated);
        AccStatusChange $statusChange = this.getStatusChange();
        result = result * 59 + ($statusChange == null ? 43 : ((Object)$statusChange).hashCode());
        BigInteger $totalFwdFees = this.getTotalFwdFees();
        result = result * 59 + ($totalFwdFees == null ? 43 : ((Object)$totalFwdFees).hashCode());
        BigInteger $totalActionFees = this.getTotalActionFees();
        result = result * 59 + ($totalActionFees == null ? 43 : ((Object)$totalActionFees).hashCode());
        BigInteger $resultArg = this.getResultArg();
        result = result * 59 + ($resultArg == null ? 43 : ((Object)$resultArg).hashCode());
        String $actionListHash = this.getActionListHash();
        result = result * 59 + ($actionListHash == null ? 43 : $actionListHash.hashCode());
        StorageUsed $totalMsgSize = this.getTotalMsgSize();
        result = result * 59 + ($totalMsgSize == null ? 43 : ((Object)$totalMsgSize).hashCode());
        return result;
    }

    public String toString() {
        return "ActionPhase(success=" + this.isSuccess() + ", valid=" + this.isValid() + ", noFunds=" + this.isNoFunds() + ", statusChange=" + String.valueOf(this.getStatusChange()) + ", totalFwdFees=" + String.valueOf(this.getTotalFwdFees()) + ", totalActionFees=" + String.valueOf(this.getTotalActionFees()) + ", resultCode=" + this.getResultCode() + ", resultArg=" + String.valueOf(this.getResultArg()) + ", totalActions=" + this.getTotalActions() + ", specActions=" + this.getSpecActions() + ", skippedActions=" + this.getSkippedActions() + ", messagesCreated=" + this.getMessagesCreated() + ", actionListHash=" + this.getActionListHash() + ", totalMsgSize=" + String.valueOf(this.getTotalMsgSize()) + ")";
    }

    public static class ActionPhaseBuilder {
        private boolean success;
        private boolean valid;
        private boolean noFunds;
        private AccStatusChange statusChange;
        private BigInteger totalFwdFees;
        private BigInteger totalActionFees;
        private long resultCode;
        private BigInteger resultArg;
        private long totalActions;
        private long specActions;
        private long skippedActions;
        private long messagesCreated;
        private BigInteger actionListHash;
        private StorageUsed totalMsgSize;

        ActionPhaseBuilder() {
        }

        public ActionPhaseBuilder success(boolean success) {
            this.success = success;
            return this;
        }

        public ActionPhaseBuilder valid(boolean valid) {
            this.valid = valid;
            return this;
        }

        public ActionPhaseBuilder noFunds(boolean noFunds) {
            this.noFunds = noFunds;
            return this;
        }

        public ActionPhaseBuilder statusChange(AccStatusChange statusChange) {
            this.statusChange = statusChange;
            return this;
        }

        public ActionPhaseBuilder totalFwdFees(BigInteger totalFwdFees) {
            this.totalFwdFees = totalFwdFees;
            return this;
        }

        public ActionPhaseBuilder totalActionFees(BigInteger totalActionFees) {
            this.totalActionFees = totalActionFees;
            return this;
        }

        public ActionPhaseBuilder resultCode(long resultCode) {
            this.resultCode = resultCode;
            return this;
        }

        public ActionPhaseBuilder resultArg(BigInteger resultArg) {
            this.resultArg = resultArg;
            return this;
        }

        public ActionPhaseBuilder totalActions(long totalActions) {
            this.totalActions = totalActions;
            return this;
        }

        public ActionPhaseBuilder specActions(long specActions) {
            this.specActions = specActions;
            return this;
        }

        public ActionPhaseBuilder skippedActions(long skippedActions) {
            this.skippedActions = skippedActions;
            return this;
        }

        public ActionPhaseBuilder messagesCreated(long messagesCreated) {
            this.messagesCreated = messagesCreated;
            return this;
        }

        public ActionPhaseBuilder actionListHash(BigInteger actionListHash) {
            this.actionListHash = actionListHash;
            return this;
        }

        public ActionPhaseBuilder totalMsgSize(StorageUsed totalMsgSize) {
            this.totalMsgSize = totalMsgSize;
            return this;
        }

        public ActionPhase build() {
            return new ActionPhase(this.success, this.valid, this.noFunds, this.statusChange, this.totalFwdFees, this.totalActionFees, this.resultCode, this.resultArg, this.totalActions, this.specActions, this.skippedActions, this.messagesCreated, this.actionListHash, this.totalMsgSize);
        }

        public String toString() {
            return "ActionPhase.ActionPhaseBuilder(success=" + this.success + ", valid=" + this.valid + ", noFunds=" + this.noFunds + ", statusChange=" + String.valueOf(this.statusChange) + ", totalFwdFees=" + String.valueOf(this.totalFwdFees) + ", totalActionFees=" + String.valueOf(this.totalActionFees) + ", resultCode=" + this.resultCode + ", resultArg=" + String.valueOf(this.resultArg) + ", totalActions=" + this.totalActions + ", specActions=" + this.specActions + ", skippedActions=" + this.skippedActions + ", messagesCreated=" + this.messagesCreated + ", actionListHash=" + String.valueOf(this.actionListHash) + ", totalMsgSize=" + String.valueOf(this.totalMsgSize) + ")";
        }
    }
}

