/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ExtendedAction;

public class ActionList
implements Serializable {
    List<ExtendedAction> actions;

    public Cell toCell() {
        Cell list = null;
        for (ExtendedAction action : this.actions) {
            Cell cell = action.toCell();
            list = CellBuilder.beginCell().storeCell(cell).storeRefMaybe(list).endCell();
        }
        return list;
    }

    public static ActionList deserialize(CellSlice cs) {
        ArrayList<ExtendedAction> actions = new ArrayList<ExtendedAction>();
        actions.add(ExtendedAction.deserialize(CellSlice.beginParse((Object)cs)));
        while (cs.getRefsCount() != 0) {
            Cell t = cs.loadMaybeRefX();
            if (!Objects.nonNull(t)) continue;
            ExtendedAction action = ExtendedAction.deserialize(CellSlice.beginParse((Cell)t));
            actions.add(action);
            cs = CellSlice.beginParse((Cell)t);
        }
        return ActionList.builder().actions(actions).build();
    }

    ActionList(List<ExtendedAction> actions) {
        this.actions = actions;
    }

    public static ActionListBuilder builder() {
        return new ActionListBuilder();
    }

    public List<ExtendedAction> getActions() {
        return this.actions;
    }

    public void setActions(List<ExtendedAction> actions) {
        this.actions = actions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActionList)) {
            return false;
        }
        ActionList other = (ActionList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ExtendedAction> this$actions = this.getActions();
        List<ExtendedAction> other$actions = other.getActions();
        return !(this$actions == null ? other$actions != null : !((Object)this$actions).equals(other$actions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActionList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ExtendedAction> $actions = this.getActions();
        result = result * 59 + ($actions == null ? 43 : ((Object)$actions).hashCode());
        return result;
    }

    public String toString() {
        return "ActionList(actions=" + String.valueOf(this.getActions()) + ")";
    }

    public static class ActionListBuilder {
        private List<ExtendedAction> actions;

        ActionListBuilder() {
        }

        public ActionListBuilder actions(List<ExtendedAction> actions) {
            this.actions = actions;
            return this;
        }

        public ActionList build() {
            return new ActionList(this.actions);
        }

        public String toString() {
            return "ActionList.ActionListBuilder(actions=" + String.valueOf(this.actions) + ")";
        }
    }
}

