/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import java.math.BigInteger;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccountState;

public class AccountStateFrozen
implements AccountState,
Serializable {
    int magic;
    BigInteger stateHash;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 2).storeUint(this.stateHash, 256).endCell();
    }

    public static AccountStateFrozen deserialize(CellSlice cs) {
        return AccountStateFrozen.builder().magic(cs.loadUint(2).intValue()).stateHash(cs.getRestBits() >= 256 ? cs.loadUint(256) : null).build();
    }

    AccountStateFrozen(int magic, BigInteger stateHash) {
        this.magic = magic;
        this.stateHash = stateHash;
    }

    public static AccountStateFrozenBuilder builder() {
        return new AccountStateFrozenBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public BigInteger getStateHash() {
        return this.stateHash;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setStateHash(BigInteger stateHash) {
        this.stateHash = stateHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountStateFrozen)) {
            return false;
        }
        AccountStateFrozen other = (AccountStateFrozen)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        BigInteger this$stateHash = this.getStateHash();
        BigInteger other$stateHash = other.getStateHash();
        return !(this$stateHash == null ? other$stateHash != null : !((Object)this$stateHash).equals(other$stateHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountStateFrozen;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        BigInteger $stateHash = this.getStateHash();
        result = result * 59 + ($stateHash == null ? 43 : ((Object)$stateHash).hashCode());
        return result;
    }

    public String toString() {
        return "AccountStateFrozen(magic=" + this.getMagic() + ", stateHash=" + String.valueOf(this.getStateHash()) + ")";
    }

    public static class AccountStateFrozenBuilder {
        private int magic;
        private BigInteger stateHash;

        AccountStateFrozenBuilder() {
        }

        public AccountStateFrozenBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public AccountStateFrozenBuilder stateHash(BigInteger stateHash) {
            this.stateHash = stateHash;
            return this;
        }

        public AccountStateFrozen build() {
            return new AccountStateFrozen(this.magic, this.stateHash);
        }

        public String toString() {
            return "AccountStateFrozen.AccountStateFrozenBuilder(magic=" + this.magic + ", stateHash=" + String.valueOf(this.stateHash) + ")";
        }
    }
}

