/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccountState;
import org.ton.java.tlb.StateInit;

public class AccountStateActive
implements AccountState {
    int magic;
    StateInit stateInit;

    @Override
    public Cell toCell() {
        return CellBuilder.beginCell().storeUint(1, 1).storeCell(this.stateInit.toCell()).endCell();
    }

    public static AccountStateActive deserialize(CellSlice cs) {
        return AccountStateActive.builder().magic(cs.loadUint(1).intValue()).stateInit(StateInit.deserialize(cs)).build();
    }

    AccountStateActive(int magic, StateInit stateInit) {
        this.magic = magic;
        this.stateInit = stateInit;
    }

    public static AccountStateActiveBuilder builder() {
        return new AccountStateActiveBuilder();
    }

    public int getMagic() {
        return this.magic;
    }

    public StateInit getStateInit() {
        return this.stateInit;
    }

    public void setMagic(int magic) {
        this.magic = magic;
    }

    public void setStateInit(StateInit stateInit) {
        this.stateInit = stateInit;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountStateActive)) {
            return false;
        }
        AccountStateActive other = (AccountStateActive)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getMagic() != other.getMagic()) {
            return false;
        }
        StateInit this$stateInit = this.getStateInit();
        StateInit other$stateInit = other.getStateInit();
        return !(this$stateInit == null ? other$stateInit != null : !((Object)this$stateInit).equals(other$stateInit));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccountStateActive;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMagic();
        StateInit $stateInit = this.getStateInit();
        result = result * 59 + ($stateInit == null ? 43 : ((Object)$stateInit).hashCode());
        return result;
    }

    public String toString() {
        return "AccountStateActive(magic=" + this.getMagic() + ", stateInit=" + String.valueOf(this.getStateInit()) + ")";
    }

    public static class AccountStateActiveBuilder {
        private int magic;
        private StateInit stateInit;

        AccountStateActiveBuilder() {
        }

        public AccountStateActiveBuilder magic(int magic) {
            this.magic = magic;
            return this;
        }

        public AccountStateActiveBuilder stateInit(StateInit stateInit) {
            this.stateInit = stateInit;
            return this;
        }

        public AccountStateActive build() {
            return new AccountStateActive(this.magic, this.stateInit);
        }

        public String toString() {
            return "AccountStateActive.AccountStateActiveBuilder(magic=" + this.magic + ", stateInit=" + String.valueOf(this.stateInit) + ")";
        }
    }
}

