/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.AccountStorage;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.StorageInfo;

public class Account
implements Serializable {
    boolean isNone;
    MsgAddressInt address;
    StorageInfo storageInfo;
    AccountStorage accountStorage;

    public Cell toCell() {
        if (this.isNone) {
            return CellBuilder.beginCell().storeBit(Boolean.valueOf(false)).endCell();
        }
        return CellBuilder.beginCell().storeBit(Boolean.valueOf(true)).storeCell(this.address.toCell()).storeCell(this.storageInfo.toCell()).storeCell(this.accountStorage.toCell()).endCell();
    }

    public static Account deserialize(CellSlice cs) {
        boolean isAccount = cs.loadBit();
        if (!isAccount) {
            return Account.builder().isNone(true).build();
        }
        return Account.builder().isNone(false).address(MsgAddressInt.deserialize(cs)).storageInfo(StorageInfo.deserialize(cs)).accountStorage(AccountStorage.deserialize(cs)).build();
    }

    Account(boolean isNone, MsgAddressInt address, StorageInfo storageInfo, AccountStorage accountStorage) {
        this.isNone = isNone;
        this.address = address;
        this.storageInfo = storageInfo;
        this.accountStorage = accountStorage;
    }

    public static AccountBuilder builder() {
        return new AccountBuilder();
    }

    public boolean isNone() {
        return this.isNone;
    }

    public MsgAddressInt getAddress() {
        return this.address;
    }

    public StorageInfo getStorageInfo() {
        return this.storageInfo;
    }

    public AccountStorage getAccountStorage() {
        return this.accountStorage;
    }

    public void setNone(boolean isNone) {
        this.isNone = isNone;
    }

    public void setAddress(MsgAddressInt address) {
        this.address = address;
    }

    public void setStorageInfo(StorageInfo storageInfo) {
        this.storageInfo = storageInfo;
    }

    public void setAccountStorage(AccountStorage accountStorage) {
        this.accountStorage = accountStorage;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Account)) {
            return false;
        }
        Account other = (Account)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isNone() != other.isNone()) {
            return false;
        }
        MsgAddressInt this$address = this.getAddress();
        MsgAddressInt other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        StorageInfo this$storageInfo = this.getStorageInfo();
        StorageInfo other$storageInfo = other.getStorageInfo();
        if (this$storageInfo == null ? other$storageInfo != null : !((Object)this$storageInfo).equals(other$storageInfo)) {
            return false;
        }
        AccountStorage this$accountStorage = this.getAccountStorage();
        AccountStorage other$accountStorage = other.getAccountStorage();
        return !(this$accountStorage == null ? other$accountStorage != null : !((Object)this$accountStorage).equals(other$accountStorage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Account;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isNone() ? 79 : 97);
        MsgAddressInt $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        StorageInfo $storageInfo = this.getStorageInfo();
        result = result * 59 + ($storageInfo == null ? 43 : ((Object)$storageInfo).hashCode());
        AccountStorage $accountStorage = this.getAccountStorage();
        result = result * 59 + ($accountStorage == null ? 43 : ((Object)$accountStorage).hashCode());
        return result;
    }

    public String toString() {
        return "Account(isNone=" + this.isNone() + ", address=" + String.valueOf(this.getAddress()) + ", storageInfo=" + String.valueOf(this.getStorageInfo()) + ", accountStorage=" + String.valueOf(this.getAccountStorage()) + ")";
    }

    public static class AccountBuilder {
        private boolean isNone;
        private MsgAddressInt address;
        private StorageInfo storageInfo;
        private AccountStorage accountStorage;

        AccountBuilder() {
        }

        public AccountBuilder isNone(boolean isNone) {
            this.isNone = isNone;
            return this;
        }

        public AccountBuilder address(MsgAddressInt address) {
            this.address = address;
            return this;
        }

        public AccountBuilder storageInfo(StorageInfo storageInfo) {
            this.storageInfo = storageInfo;
            return this;
        }

        public AccountBuilder accountStorage(AccountStorage accountStorage) {
            this.accountStorage = accountStorage;
            return this;
        }

        public Account build() {
            return new Account(this.isNone, this.address, this.storageInfo, this.accountStorage);
        }

        public String toString() {
            return "Account.AccountBuilder(isNone=" + this.isNone + ", address=" + String.valueOf(this.address) + ", storageInfo=" + String.valueOf(this.storageInfo) + ", accountStorage=" + String.valueOf(this.accountStorage) + ")";
        }
    }
}

