/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.tlb;

import java.io.Serializable;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;

public class AccStatusChange
implements Serializable {
    String type;

    public Cell toCell() {
        switch (this.type) {
            case "UNCHANGED": {
                return CellBuilder.beginCell().storeUint(0, 1).endCell();
            }
            case "FROZEN": {
                return CellBuilder.beginCell().storeUint(1, 2).endCell();
            }
            case "DELETED": {
                return CellBuilder.beginCell().storeUint(2, 2).endCell();
            }
        }
        throw new Error("unknown account status change");
    }

    public static AccStatusChange deserialize(CellSlice cs) {
        boolean isChanged = cs.loadBit();
        if (isChanged) {
            boolean isDeleted = cs.loadBit();
            if (isDeleted) {
                return AccStatusChange.builder().type("DELETED").build();
            }
            return AccStatusChange.builder().type("FROZEN").build();
        }
        return AccStatusChange.builder().type("UNCHANGED").build();
    }

    AccStatusChange(String type) {
        this.type = type;
    }

    public static AccStatusChangeBuilder builder() {
        return new AccStatusChangeBuilder();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccStatusChange)) {
            return false;
        }
        AccStatusChange other = (AccStatusChange)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AccStatusChange;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "AccStatusChange(type=" + this.getType() + ")";
    }

    public static class AccStatusChangeBuilder {
        private String type;

        AccStatusChangeBuilder() {
        }

        public AccStatusChangeBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AccStatusChange build() {
            return new AccStatusChange(this.type);
        }

        public String toString() {
            return "AccStatusChange.AccStatusChangeBuilder(type=" + this.type + ")";
        }
    }
}

