/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet.v4;

import java.math.BigInteger;
import org.ton.java.address.Address;

public class SubscriptionInfo {
    Address walletAddress;
    Address beneficiary;
    BigInteger subscriptionFee;
    long period;
    long startTime;
    long timeOut;
    long lastPaymentTime;
    long lastRequestTime;
    boolean isPaid;
    boolean isPaymentReady;
    long failedAttempts;
    long subscriptionId;

    SubscriptionInfo(Address walletAddress, Address beneficiary, BigInteger subscriptionFee, long period, long startTime, long timeOut, long lastPaymentTime, long lastRequestTime, boolean isPaid, boolean isPaymentReady, long failedAttempts, long subscriptionId) {
        this.walletAddress = walletAddress;
        this.beneficiary = beneficiary;
        this.subscriptionFee = subscriptionFee;
        this.period = period;
        this.startTime = startTime;
        this.timeOut = timeOut;
        this.lastPaymentTime = lastPaymentTime;
        this.lastRequestTime = lastRequestTime;
        this.isPaid = isPaid;
        this.isPaymentReady = isPaymentReady;
        this.failedAttempts = failedAttempts;
        this.subscriptionId = subscriptionId;
    }

    public static SubscriptionInfoBuilder builder() {
        return new SubscriptionInfoBuilder();
    }

    public Address getWalletAddress() {
        return this.walletAddress;
    }

    public Address getBeneficiary() {
        return this.beneficiary;
    }

    public BigInteger getSubscriptionFee() {
        return this.subscriptionFee;
    }

    public long getPeriod() {
        return this.period;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public long getLastPaymentTime() {
        return this.lastPaymentTime;
    }

    public long getLastRequestTime() {
        return this.lastRequestTime;
    }

    public boolean isPaid() {
        return this.isPaid;
    }

    public boolean isPaymentReady() {
        return this.isPaymentReady;
    }

    public long getFailedAttempts() {
        return this.failedAttempts;
    }

    public long getSubscriptionId() {
        return this.subscriptionId;
    }

    public void setWalletAddress(Address walletAddress) {
        this.walletAddress = walletAddress;
    }

    public void setBeneficiary(Address beneficiary) {
        this.beneficiary = beneficiary;
    }

    public void setSubscriptionFee(BigInteger subscriptionFee) {
        this.subscriptionFee = subscriptionFee;
    }

    public void setPeriod(long period) {
        this.period = period;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setTimeOut(long timeOut) {
        this.timeOut = timeOut;
    }

    public void setLastPaymentTime(long lastPaymentTime) {
        this.lastPaymentTime = lastPaymentTime;
    }

    public void setLastRequestTime(long lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
    }

    public void setPaid(boolean isPaid) {
        this.isPaid = isPaid;
    }

    public void setPaymentReady(boolean isPaymentReady) {
        this.isPaymentReady = isPaymentReady;
    }

    public void setFailedAttempts(long failedAttempts) {
        this.failedAttempts = failedAttempts;
    }

    public void setSubscriptionId(long subscriptionId) {
        this.subscriptionId = subscriptionId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SubscriptionInfo)) {
            return false;
        }
        SubscriptionInfo other = (SubscriptionInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPeriod() != other.getPeriod()) {
            return false;
        }
        if (this.getStartTime() != other.getStartTime()) {
            return false;
        }
        if (this.getTimeOut() != other.getTimeOut()) {
            return false;
        }
        if (this.getLastPaymentTime() != other.getLastPaymentTime()) {
            return false;
        }
        if (this.getLastRequestTime() != other.getLastRequestTime()) {
            return false;
        }
        if (this.isPaid() != other.isPaid()) {
            return false;
        }
        if (this.isPaymentReady() != other.isPaymentReady()) {
            return false;
        }
        if (this.getFailedAttempts() != other.getFailedAttempts()) {
            return false;
        }
        if (this.getSubscriptionId() != other.getSubscriptionId()) {
            return false;
        }
        Address this$walletAddress = this.getWalletAddress();
        Address other$walletAddress = other.getWalletAddress();
        if (this$walletAddress == null ? other$walletAddress != null : !this$walletAddress.equals(other$walletAddress)) {
            return false;
        }
        Address this$beneficiary = this.getBeneficiary();
        Address other$beneficiary = other.getBeneficiary();
        if (this$beneficiary == null ? other$beneficiary != null : !this$beneficiary.equals(other$beneficiary)) {
            return false;
        }
        BigInteger this$subscriptionFee = this.getSubscriptionFee();
        BigInteger other$subscriptionFee = other.getSubscriptionFee();
        return !(this$subscriptionFee == null ? other$subscriptionFee != null : !((Object)this$subscriptionFee).equals(other$subscriptionFee));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SubscriptionInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $period = this.getPeriod();
        result = result * 59 + (int)($period >>> 32 ^ $period);
        long $startTime = this.getStartTime();
        result = result * 59 + (int)($startTime >>> 32 ^ $startTime);
        long $timeOut = this.getTimeOut();
        result = result * 59 + (int)($timeOut >>> 32 ^ $timeOut);
        long $lastPaymentTime = this.getLastPaymentTime();
        result = result * 59 + (int)($lastPaymentTime >>> 32 ^ $lastPaymentTime);
        long $lastRequestTime = this.getLastRequestTime();
        result = result * 59 + (int)($lastRequestTime >>> 32 ^ $lastRequestTime);
        result = result * 59 + (this.isPaid() ? 79 : 97);
        result = result * 59 + (this.isPaymentReady() ? 79 : 97);
        long $failedAttempts = this.getFailedAttempts();
        result = result * 59 + (int)($failedAttempts >>> 32 ^ $failedAttempts);
        long $subscriptionId = this.getSubscriptionId();
        result = result * 59 + (int)($subscriptionId >>> 32 ^ $subscriptionId);
        Address $walletAddress = this.getWalletAddress();
        result = result * 59 + ($walletAddress == null ? 43 : $walletAddress.hashCode());
        Address $beneficiary = this.getBeneficiary();
        result = result * 59 + ($beneficiary == null ? 43 : $beneficiary.hashCode());
        BigInteger $subscriptionFee = this.getSubscriptionFee();
        result = result * 59 + ($subscriptionFee == null ? 43 : ((Object)$subscriptionFee).hashCode());
        return result;
    }

    public String toString() {
        return "SubscriptionInfo(walletAddress=" + String.valueOf(this.getWalletAddress()) + ", beneficiary=" + String.valueOf(this.getBeneficiary()) + ", subscriptionFee=" + String.valueOf(this.getSubscriptionFee()) + ", period=" + this.getPeriod() + ", startTime=" + this.getStartTime() + ", timeOut=" + this.getTimeOut() + ", lastPaymentTime=" + this.getLastPaymentTime() + ", lastRequestTime=" + this.getLastRequestTime() + ", isPaid=" + this.isPaid() + ", isPaymentReady=" + this.isPaymentReady() + ", failedAttempts=" + this.getFailedAttempts() + ", subscriptionId=" + this.getSubscriptionId() + ")";
    }

    public static class SubscriptionInfoBuilder {
        private Address walletAddress;
        private Address beneficiary;
        private BigInteger subscriptionFee;
        private long period;
        private long startTime;
        private long timeOut;
        private long lastPaymentTime;
        private long lastRequestTime;
        private boolean isPaid;
        private boolean isPaymentReady;
        private long failedAttempts;
        private long subscriptionId;

        SubscriptionInfoBuilder() {
        }

        public SubscriptionInfoBuilder walletAddress(Address walletAddress) {
            this.walletAddress = walletAddress;
            return this;
        }

        public SubscriptionInfoBuilder beneficiary(Address beneficiary) {
            this.beneficiary = beneficiary;
            return this;
        }

        public SubscriptionInfoBuilder subscriptionFee(BigInteger subscriptionFee) {
            this.subscriptionFee = subscriptionFee;
            return this;
        }

        public SubscriptionInfoBuilder period(long period) {
            this.period = period;
            return this;
        }

        public SubscriptionInfoBuilder startTime(long startTime) {
            this.startTime = startTime;
            return this;
        }

        public SubscriptionInfoBuilder timeOut(long timeOut) {
            this.timeOut = timeOut;
            return this;
        }

        public SubscriptionInfoBuilder lastPaymentTime(long lastPaymentTime) {
            this.lastPaymentTime = lastPaymentTime;
            return this;
        }

        public SubscriptionInfoBuilder lastRequestTime(long lastRequestTime) {
            this.lastRequestTime = lastRequestTime;
            return this;
        }

        public SubscriptionInfoBuilder isPaid(boolean isPaid) {
            this.isPaid = isPaid;
            return this;
        }

        public SubscriptionInfoBuilder isPaymentReady(boolean isPaymentReady) {
            this.isPaymentReady = isPaymentReady;
            return this;
        }

        public SubscriptionInfoBuilder failedAttempts(long failedAttempts) {
            this.failedAttempts = failedAttempts;
            return this;
        }

        public SubscriptionInfoBuilder subscriptionId(long subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public SubscriptionInfo build() {
            return new SubscriptionInfo(this.walletAddress, this.beneficiary, this.subscriptionFee, this.period, this.startTime, this.timeOut, this.lastPaymentTime, this.lastRequestTime, this.isPaid, this.isPaymentReady, this.failedAttempts, this.subscriptionId);
        }

        public String toString() {
            return "SubscriptionInfo.SubscriptionInfoBuilder(walletAddress=" + String.valueOf(this.walletAddress) + ", beneficiary=" + String.valueOf(this.beneficiary) + ", subscriptionFee=" + String.valueOf(this.subscriptionFee) + ", period=" + this.period + ", startTime=" + this.startTime + ", timeOut=" + this.timeOut + ", lastPaymentTime=" + this.lastPaymentTime + ", lastRequestTime=" + this.lastRequestTime + ", isPaid=" + this.isPaid + ", isPaymentReady=" + this.isPaymentReady + ", failedAttempts=" + this.failedAttempts + ", subscriptionId=" + this.subscriptionId + ")";
        }
    }
}

