/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.wallet;

import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.smartcontract.types.WalletConfig;
import org.ton.java.smartcontract.wallet.v1.WalletV1R1;
import org.ton.java.tlb.BouncePhase;
import org.ton.java.tlb.BouncePhaseOk;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tlb.StateInit;
import org.ton.java.tlb.Transaction;
import org.ton.java.tlb.TransactionDescriptionOrdinary;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.RawTransaction;
import org.ton.java.tonlib.types.RawTransactions;
import org.ton.java.utils.Utils;

public interface Contract {
    public Tonlib getTonlib();

    public void setTonlib(Tonlib var1);

    public long getWorkchain();

    public String getName();

    default public Address getAddress() {
        return StateInit.builder().code(this.createCodeCell()).data(this.createDataCell()).build().getAddress(this.getWorkchain());
    }

    default public Address getAddress(byte workchain) {
        return this.getStateInit().getAddress((long)workchain);
    }

    default public MsgAddressIntStd getAddressIntStd() {
        Address ownAddress = this.getStateInit().getAddress(this.getWorkchain());
        return MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build();
    }

    default public MsgAddressIntStd getAddressIntStd(int workchain) {
        Address ownAddress = this.getStateInit().getAddress();
        return MsgAddressIntStd.builder().workchainId((byte)workchain).address(ownAddress.toBigInteger()).build();
    }

    public Cell createCodeCell();

    public Cell createDataCell();

    default public Cell createLibraryCell() {
        return null;
    }

    default public StateInit getStateInit() {
        return StateInit.builder().code(this.createCodeCell()).data(this.createDataCell()).lib(this.createLibraryCell()).build();
    }

    default public long getSeqno() {
        if (this instanceof WalletV1R1) {
            throw new Error("Wallet V1R1 does not have seqno method");
        }
        return this.getTonlib().getSeqno(this.getAddress());
    }

    default public boolean isDeployed() {
        return StringUtils.isNotEmpty((CharSequence)this.getTonlib().getRawAccountState(this.getAddress()).getCode());
    }

    default public void waitForDeployment() {
        this.waitForDeployment(60);
    }

    default public void waitForDeployment(int timeoutSeconds) {
        System.out.println("waiting for deployment (up to " + timeoutSeconds + "s)");
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Can't deploy contract within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (!this.isDeployed());
    }

    default public void waitForBalanceChange() {
        this.waitForBalanceChange(60);
    }

    default public void waitForBalanceChange(int timeoutSeconds) {
        System.out.println("waiting for balance change (up to " + timeoutSeconds + "s) - " + (this.getTonlib().isTestnet() ? this.getAddress().toBounceableTestnet() : this.getAddress().toBounceable()) + " (" + this.getAddress().toRaw() + ")");
        BigInteger initialBalance = this.getBalance();
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance was not changed within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while (initialBalance.equals(this.getBalance()));
    }

    default public void waitForBalanceChangeWithTolerance(int timeoutSeconds, BigInteger tolerateNanoCoins) {
        BigInteger currentBalance;
        long diff;
        BigInteger initialBalance = this.getBalance();
        int i = 0;
        do {
            if (++i * 2 >= timeoutSeconds) {
                throw new Error("Balance was not changed within specified timeout.");
            }
            Utils.sleep((long)2L);
        } while ((diff = Math.max((currentBalance = this.getBalance()).longValue(), initialBalance.longValue()) - Math.min(currentBalance.longValue(), initialBalance.longValue())) < tolerateNanoCoins.longValue());
    }

    default public BigInteger getBalance() {
        return new BigInteger(this.getTonlib().getRawAccountState(this.getAddress()).getBalance());
    }

    default public List<RawTransaction> getTransactions(int historyLimit) {
        return this.getTonlib().getAllRawTransactions(this.getAddress().toBounceable(), BigInteger.ZERO, null, historyLimit).getTransactions();
    }

    default public List<RawTransaction> getTransactions() {
        return this.getTonlib().getAllRawTransactions(this.getAddress().toBounceable(), BigInteger.ZERO, null, 20).getTransactions();
    }

    default public Message prepareDeployMsg() {
        throw new Error("not implemented");
    }

    default public Message prepareExternalMsg(WalletConfig config) {
        throw new Error("not implemented");
    }

    default public BigInteger getGasFees() {
        switch (this.getName()) {
            case "V1R1": {
                return BigInteger.valueOf(40000L);
            }
            case "V1R2": {
                return BigInteger.valueOf(40000L);
            }
            case "V1R3": {
                return BigInteger.valueOf(40000L);
            }
            case "V2R1": {
                return BigInteger.valueOf(40000L);
            }
            case "V2R2": {
                return BigInteger.valueOf(40000L);
            }
            case "V3R1": {
                return BigInteger.valueOf(40000L);
            }
            case "V3R2": {
                return BigInteger.valueOf(40000L);
            }
            case "V4R2": {
                return BigInteger.valueOf(310000L);
            }
        }
        throw new Error("Unknown wallet version");
    }

    default public TonHashMapE convertExtraCurrenciesToHashMap(List<ExtraCurrency> extraCurrencies) {
        if (Objects.isNull(extraCurrencies)) {
            return null;
        }
        TonHashMapE x = new TonHashMapE(32);
        for (ExtraCurrency ec : extraCurrencies) {
            x.elements.put(ec.getId(), ec.getAmount());
        }
        return x;
    }

    default public RawTransaction waitForExtraCurrency(long extraCurrencyId) {
        return this.waitForExtraCurrency(extraCurrencyId, null, null, 10);
    }

    default public RawTransaction waitForExtraCurrency(long extraCurrencyId, BigInteger fromTxLt, String fromTxHash) {
        return this.waitForExtraCurrency(extraCurrencyId, fromTxLt, fromTxHash, 10);
    }

    default public RawTransaction waitForExtraCurrency(long extraCurrencyId, BigInteger fromTxLt, String fromTxHash, int attempts) {
        for (int i = 0; i < attempts; ++i) {
            RawTransactions txs = this.getTonlib().getRawTransactions(this.getAddress().toRaw(), fromTxLt, fromTxHash);
            for (RawTransaction tx : txs.getTransactions()) {
                for (ExtraCurrency ec : tx.getIn_msg().getExtra_currencies()) {
                    if (ec.getId() != extraCurrencyId) continue;
                    Transaction tlbTransaction = tx.getTransactionAsTlb();
                    if (tlbTransaction.getDescription() instanceof TransactionDescriptionOrdinary) {
                        BouncePhase bouncePhase = tlbTransaction.getOrdinaryTransaction().getBouncePhase();
                        if (Objects.isNull(bouncePhase)) {
                            return tx;
                        }
                        if (bouncePhase instanceof BouncePhaseOk) {
                            throw new Error("extra-currency transaction has bounced");
                        }
                        return tx;
                    }
                    return tx;
                }
            }
            Utils.sleep((long)5L);
        }
        throw new Error("time out waiting for extra-currency with id " + extraCurrencyId);
    }
}

