/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.tlb.ActionList;
import org.ton.java.tlb.OutList;

public class WalletV5InnerRequest {
    OutList outActions;
    boolean hasOtherActions;
    ActionList otherActions;

    public Cell toCell() {
        if (this.hasOtherActions) {
            return CellBuilder.beginCell().storeRefMaybe(this.outActions.toCell()).storeBit(Boolean.valueOf(this.hasOtherActions)).storeCell(this.otherActions.toCell()).endCell();
        }
        return CellBuilder.beginCell().storeRefMaybe(this.outActions.toCell()).storeBit(Boolean.valueOf(this.hasOtherActions)).endCell();
    }

    public static WalletV5InnerRequest deserialize(CellSlice cs) {
        if (Objects.nonNull(cs.preloadMaybeRefX())) {
            return WalletV5InnerRequest.builder().outActions(OutList.deserialize((CellSlice)CellSlice.beginParse((Cell)cs.loadMaybeRefX()))).hasOtherActions(cs.loadBit()).otherActions(ActionList.deserialize((CellSlice)CellSlice.beginParse((Object)cs))).build();
        }
        cs.loadBit();
        return WalletV5InnerRequest.builder().outActions(OutList.builder().build()).hasOtherActions(cs.loadBit()).otherActions(ActionList.deserialize((CellSlice)CellSlice.beginParse((Object)cs))).build();
    }

    WalletV5InnerRequest(OutList outActions, boolean hasOtherActions, ActionList otherActions) {
        this.outActions = outActions;
        this.hasOtherActions = hasOtherActions;
        this.otherActions = otherActions;
    }

    public static WalletV5InnerRequestBuilder builder() {
        return new WalletV5InnerRequestBuilder();
    }

    public OutList getOutActions() {
        return this.outActions;
    }

    public boolean isHasOtherActions() {
        return this.hasOtherActions;
    }

    public ActionList getOtherActions() {
        return this.otherActions;
    }

    public void setOutActions(OutList outActions) {
        this.outActions = outActions;
    }

    public void setHasOtherActions(boolean hasOtherActions) {
        this.hasOtherActions = hasOtherActions;
    }

    public void setOtherActions(ActionList otherActions) {
        this.otherActions = otherActions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletV5InnerRequest)) {
            return false;
        }
        WalletV5InnerRequest other = (WalletV5InnerRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasOtherActions() != other.isHasOtherActions()) {
            return false;
        }
        OutList this$outActions = this.getOutActions();
        OutList other$outActions = other.getOutActions();
        if (this$outActions == null ? other$outActions != null : !this$outActions.equals(other$outActions)) {
            return false;
        }
        ActionList this$otherActions = this.getOtherActions();
        ActionList other$otherActions = other.getOtherActions();
        return !(this$otherActions == null ? other$otherActions != null : !this$otherActions.equals(other$otherActions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletV5InnerRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasOtherActions() ? 79 : 97);
        OutList $outActions = this.getOutActions();
        result = result * 59 + ($outActions == null ? 43 : $outActions.hashCode());
        ActionList $otherActions = this.getOtherActions();
        result = result * 59 + ($otherActions == null ? 43 : $otherActions.hashCode());
        return result;
    }

    public String toString() {
        return "WalletV5InnerRequest(outActions=" + String.valueOf(this.getOutActions()) + ", hasOtherActions=" + this.isHasOtherActions() + ", otherActions=" + String.valueOf(this.getOtherActions()) + ")";
    }

    public static class WalletV5InnerRequestBuilder {
        private OutList outActions;
        private boolean hasOtherActions;
        private ActionList otherActions;

        WalletV5InnerRequestBuilder() {
        }

        public WalletV5InnerRequestBuilder outActions(OutList outActions) {
            this.outActions = outActions;
            return this;
        }

        public WalletV5InnerRequestBuilder hasOtherActions(boolean hasOtherActions) {
            this.hasOtherActions = hasOtherActions;
            return this;
        }

        public WalletV5InnerRequestBuilder otherActions(ActionList otherActions) {
            this.otherActions = otherActions;
            return this;
        }

        public WalletV5InnerRequest build() {
            return new WalletV5InnerRequest(this.outActions, this.hasOtherActions, this.otherActions);
        }

        public String toString() {
            return "WalletV5InnerRequest.WalletV5InnerRequestBuilder(outActions=" + String.valueOf(this.outActions) + ", hasOtherActions=" + this.hasOtherActions + ", otherActions=" + String.valueOf(this.otherActions) + ")";
        }
    }
}

