/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import java.util.List;
import org.ton.java.cell.Cell;

public class Order {
    long walletId;
    BigInteger queryId;
    List<Cell> internalMsgs;

    Order(long walletId, BigInteger queryId, List<Cell> internalMsgs) {
        this.walletId = walletId;
        this.queryId = queryId;
        this.internalMsgs = internalMsgs;
    }

    public static OrderBuilder builder() {
        return new OrderBuilder();
    }

    public long getWalletId() {
        return this.walletId;
    }

    public BigInteger getQueryId() {
        return this.queryId;
    }

    public List<Cell> getInternalMsgs() {
        return this.internalMsgs;
    }

    public String toString() {
        return "Order(walletId=" + this.getWalletId() + ", queryId=" + String.valueOf(this.getQueryId()) + ", internalMsgs=" + String.valueOf(this.getInternalMsgs()) + ")";
    }

    public static class OrderBuilder {
        private long walletId;
        private BigInteger queryId;
        private List<Cell> internalMsgs;

        OrderBuilder() {
        }

        public OrderBuilder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public OrderBuilder queryId(BigInteger queryId) {
            this.queryId = queryId;
            return this;
        }

        public OrderBuilder internalMsgs(List<Cell> internalMsgs) {
            this.internalMsgs = internalMsgs;
            return this;
        }

        public Order build() {
            return new Order(this.walletId, this.queryId, this.internalMsgs);
        }

        public String toString() {
            return "Order.OrderBuilder(walletId=" + this.walletId + ", queryId=" + String.valueOf(this.queryId) + ", internalMsgs=" + String.valueOf(this.internalMsgs) + ")";
        }
    }
}

