/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import org.ton.java.address.Address;
import org.ton.java.cell.Cell;

public class CollectionData {
    long itemsCount;
    long nextItemIndex;
    Address ownerAddress;
    Cell collectionContentCell;
    String collectionContentUri;

    CollectionData(long itemsCount, long nextItemIndex, Address ownerAddress, Cell collectionContentCell, String collectionContentUri) {
        this.itemsCount = itemsCount;
        this.nextItemIndex = nextItemIndex;
        this.ownerAddress = ownerAddress;
        this.collectionContentCell = collectionContentCell;
        this.collectionContentUri = collectionContentUri;
    }

    public static CollectionDataBuilder builder() {
        return new CollectionDataBuilder();
    }

    public long getItemsCount() {
        return this.itemsCount;
    }

    public long getNextItemIndex() {
        return this.nextItemIndex;
    }

    public Address getOwnerAddress() {
        return this.ownerAddress;
    }

    public Cell getCollectionContentCell() {
        return this.collectionContentCell;
    }

    public String getCollectionContentUri() {
        return this.collectionContentUri;
    }

    public void setItemsCount(long itemsCount) {
        this.itemsCount = itemsCount;
    }

    public void setNextItemIndex(long nextItemIndex) {
        this.nextItemIndex = nextItemIndex;
    }

    public void setOwnerAddress(Address ownerAddress) {
        this.ownerAddress = ownerAddress;
    }

    public void setCollectionContentCell(Cell collectionContentCell) {
        this.collectionContentCell = collectionContentCell;
    }

    public void setCollectionContentUri(String collectionContentUri) {
        this.collectionContentUri = collectionContentUri;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionData)) {
            return false;
        }
        CollectionData other = (CollectionData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getItemsCount() != other.getItemsCount()) {
            return false;
        }
        if (this.getNextItemIndex() != other.getNextItemIndex()) {
            return false;
        }
        Address this$ownerAddress = this.getOwnerAddress();
        Address other$ownerAddress = other.getOwnerAddress();
        if (this$ownerAddress == null ? other$ownerAddress != null : !this$ownerAddress.equals(other$ownerAddress)) {
            return false;
        }
        Cell this$collectionContentCell = this.getCollectionContentCell();
        Cell other$collectionContentCell = other.getCollectionContentCell();
        if (this$collectionContentCell == null ? other$collectionContentCell != null : !this$collectionContentCell.equals(other$collectionContentCell)) {
            return false;
        }
        String this$collectionContentUri = this.getCollectionContentUri();
        String other$collectionContentUri = other.getCollectionContentUri();
        return !(this$collectionContentUri == null ? other$collectionContentUri != null : !this$collectionContentUri.equals(other$collectionContentUri));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $itemsCount = this.getItemsCount();
        result = result * 59 + (int)($itemsCount >>> 32 ^ $itemsCount);
        long $nextItemIndex = this.getNextItemIndex();
        result = result * 59 + (int)($nextItemIndex >>> 32 ^ $nextItemIndex);
        Address $ownerAddress = this.getOwnerAddress();
        result = result * 59 + ($ownerAddress == null ? 43 : $ownerAddress.hashCode());
        Cell $collectionContentCell = this.getCollectionContentCell();
        result = result * 59 + ($collectionContentCell == null ? 43 : $collectionContentCell.hashCode());
        String $collectionContentUri = this.getCollectionContentUri();
        result = result * 59 + ($collectionContentUri == null ? 43 : $collectionContentUri.hashCode());
        return result;
    }

    public String toString() {
        return "CollectionData(itemsCount=" + this.getItemsCount() + ", nextItemIndex=" + this.getNextItemIndex() + ", ownerAddress=" + String.valueOf(this.getOwnerAddress()) + ", collectionContentCell=" + String.valueOf(this.getCollectionContentCell()) + ", collectionContentUri=" + this.getCollectionContentUri() + ")";
    }

    public static class CollectionDataBuilder {
        private long itemsCount;
        private long nextItemIndex;
        private Address ownerAddress;
        private Cell collectionContentCell;
        private String collectionContentUri;

        CollectionDataBuilder() {
        }

        public CollectionDataBuilder itemsCount(long itemsCount) {
            this.itemsCount = itemsCount;
            return this;
        }

        public CollectionDataBuilder nextItemIndex(long nextItemIndex) {
            this.nextItemIndex = nextItemIndex;
            return this;
        }

        public CollectionDataBuilder ownerAddress(Address ownerAddress) {
            this.ownerAddress = ownerAddress;
            return this;
        }

        public CollectionDataBuilder collectionContentCell(Cell collectionContentCell) {
            this.collectionContentCell = collectionContentCell;
            return this;
        }

        public CollectionDataBuilder collectionContentUri(String collectionContentUri) {
            this.collectionContentUri = collectionContentUri;
            return this;
        }

        public CollectionData build() {
            return new CollectionData(this.itemsCount, this.nextItemIndex, this.ownerAddress, this.collectionContentCell, this.collectionContentUri);
        }

        public String toString() {
            return "CollectionData.CollectionDataBuilder(itemsCount=" + this.itemsCount + ", nextItemIndex=" + this.nextItemIndex + ", ownerAddress=" + String.valueOf(this.ownerAddress) + ", collectionContentCell=" + String.valueOf(this.collectionContentCell) + ", collectionContentUri=" + this.collectionContentUri + ")";
        }
    }
}

