/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.types;

import java.math.BigInteger;
import org.ton.java.address.Address;

public class AuctionInfo {
    Address maxBidAddress;
    BigInteger maxBidAmount;
    long auctionEndTime;

    AuctionInfo(Address maxBidAddress, BigInteger maxBidAmount, long auctionEndTime) {
        this.maxBidAddress = maxBidAddress;
        this.maxBidAmount = maxBidAmount;
        this.auctionEndTime = auctionEndTime;
    }

    public static AuctionInfoBuilder builder() {
        return new AuctionInfoBuilder();
    }

    public Address getMaxBidAddress() {
        return this.maxBidAddress;
    }

    public BigInteger getMaxBidAmount() {
        return this.maxBidAmount;
    }

    public long getAuctionEndTime() {
        return this.auctionEndTime;
    }

    public String toString() {
        return "AuctionInfo(maxBidAddress=" + String.valueOf(this.getMaxBidAddress()) + ", maxBidAmount=" + String.valueOf(this.getMaxBidAmount()) + ", auctionEndTime=" + this.getAuctionEndTime() + ")";
    }

    public static class AuctionInfoBuilder {
        private Address maxBidAddress;
        private BigInteger maxBidAmount;
        private long auctionEndTime;

        AuctionInfoBuilder() {
        }

        public AuctionInfoBuilder maxBidAddress(Address maxBidAddress) {
            this.maxBidAddress = maxBidAddress;
            return this;
        }

        public AuctionInfoBuilder maxBidAmount(BigInteger maxBidAmount) {
            this.maxBidAmount = maxBidAmount;
            return this;
        }

        public AuctionInfoBuilder auctionEndTime(long auctionEndTime) {
            this.auctionEndTime = auctionEndTime;
            return this;
        }

        public AuctionInfo build() {
            return new AuctionInfo(this.maxBidAddress, this.maxBidAmount, this.auctionEndTime);
        }

        public String toString() {
            return "AuctionInfo.AuctionInfoBuilder(maxBidAddress=" + String.valueOf(this.maxBidAddress) + ", maxBidAmount=" + String.valueOf(this.maxBidAmount) + ", auctionEndTime=" + this.auctionEndTime + ")";
        }
    }
}

