/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.nft;

import java.math.BigInteger;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.ItemData;
import org.ton.java.smartcontract.types.Royalty;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;

public class NftItem
implements Contract {
    BigInteger index;
    Address collectionAddress;
    private Tonlib tonlib;
    private long wc;

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    public static NftItemBuilder builder() {
        return new CustomNftItemBuilder();
    }

    @Override
    public String getName() {
        return "nftItem";
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().storeUint(this.index, 64).storeAddress(this.collectionAddress).endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.nftItem.getValue()).endCell();
    }

    public ItemData getData(Tonlib tonlib) {
        RunResult result = tonlib.runMethod(this.getAddress(), "get_nft_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_nft_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber isInitializedNumber = (TvmStackEntryNumber)result.getStack().get(0);
        boolean isInitialized = isInitializedNumber.getNumber().longValue() == -1L;
        BigInteger index = ((TvmStackEntryNumber)result.getStack().get(1)).getNumber();
        TvmStackEntrySlice collectionAddressSlice = (TvmStackEntrySlice)result.getStack().get(2);
        Address collectionAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(collectionAddressSlice.getSlice().getBytes()).endCell());
        TvmStackEntrySlice ownerAddressSlice = (TvmStackEntrySlice)result.getStack().get(3);
        Address ownerAddress = isInitialized ? NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(ownerAddressSlice.getSlice().getBytes()).endCell()) : null;
        TvmStackEntrySlice contentCell = (TvmStackEntrySlice)result.getStack().get(4);
        Cell cell = CellBuilder.beginCell().fromBoc(contentCell.getSlice().getBytes()).endCell();
        String contentUri = null;
        try {
            if (isInitialized && Objects.nonNull(collectionAddress)) {
                contentUri = NftUtils.parseOffChainUriCell(cell);
            }
        }
        catch (Error error) {
            // empty catch block
        }
        return ItemData.builder().isInitialized(isInitialized).index(index).collectionAddress(collectionAddress).ownerAddress(ownerAddress).contentCell(cell).contentUri(contentUri).build();
    }

    public static Cell createTransferBody(BigInteger queryId, Address newOwnerAddress, BigInteger forwardAmount, byte[] forwardPayload, Address responseAddress) {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(1607220500, 32);
        cell.storeUint(queryId, 64);
        cell.storeAddress(newOwnerAddress);
        cell.storeAddress(responseAddress);
        cell.storeBit(Boolean.valueOf(false));
        cell.storeCoins(forwardAmount);
        cell.storeBit(Boolean.valueOf(false));
        if (Objects.nonNull(forwardPayload)) {
            cell.storeBytes(forwardPayload);
        }
        return cell.endCell();
    }

    public static Cell createGetStaticDataBody(BigInteger queryId) {
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(801842850, 32);
        body.storeUint(queryId, 64);
        return body.endCell();
    }

    public Royalty getRoyaltyParams(Tonlib tonlib) {
        Address myAddress = this.getAddress();
        return NftUtils.getRoyaltyParams(tonlib, myAddress);
    }

    NftItem(BigInteger index, Address collectionAddress, Tonlib tonlib, long wc) {
        this.index = index;
        this.collectionAddress = collectionAddress;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public BigInteger getIndex() {
        return this.index;
    }

    public Address getCollectionAddress() {
        return this.collectionAddress;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomNftItemBuilder
    extends NftItemBuilder {
        private CustomNftItemBuilder() {
        }

        @Override
        public NftItem build() {
            return super.build();
        }
    }

    public static class NftItemBuilder {
        private BigInteger index;
        private Address collectionAddress;
        private Tonlib tonlib;
        private long wc;

        NftItemBuilder() {
        }

        public NftItemBuilder index(BigInteger index) {
            this.index = index;
            return this;
        }

        public NftItemBuilder collectionAddress(Address collectionAddress) {
            this.collectionAddress = collectionAddress;
            return this;
        }

        public NftItemBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public NftItemBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public NftItem build() {
            return new NftItem(this.index, this.collectionAddress, this.tonlib, this.wc);
        }

        public String toString() {
            return "NftItem.NftItemBuilder(index=" + String.valueOf(this.index) + ", collectionAddress=" + String.valueOf(this.collectionAddress) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

