/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.token.nft;

import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.token.nft.NftItem;
import org.ton.java.smartcontract.token.nft.NftUtils;
import org.ton.java.smartcontract.types.CollectionData;
import org.ton.java.smartcontract.types.ItemData;
import org.ton.java.smartcontract.types.NftCollectionConfig;
import org.ton.java.smartcontract.types.Royalty;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressExt;
import org.ton.java.tlb.MsgAddressExtNone;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.tonlib.types.TvmStackEntrySlice;
import org.ton.java.utils.Utils;

public class NftCollection
implements Contract {
    long royaltyBase;
    double royaltyFactor;
    Address adminAddress;
    String collectionContentUri;
    String collectionContentBaseUri;
    String nftItemCodeHex;
    Double royalty;
    Address royaltyAddress;
    private Tonlib tonlib;
    private long wc;

    public static NftCollectionBuilder builder() {
        return new CustomNftCollectionBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "nftCollection";
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.nftCollection.getValue()).endCell();
    }

    private static Cell createContentCell(String collectionContentUri, String collectionContentBaseUri) {
        Cell collectionContentCell = NftUtils.createOffChainUriCell(collectionContentUri);
        CellBuilder commonContentCell = CellBuilder.beginCell();
        commonContentCell.storeBytes(collectionContentBaseUri.getBytes(StandardCharsets.UTF_8));
        CellBuilder contentCell = CellBuilder.beginCell();
        contentCell.storeRef(collectionContentCell);
        contentCell.storeRef(commonContentCell.endCell());
        return contentCell.endCell();
    }

    private static Cell createRoyaltyCell(Address royaltyAddress, double royaltyFactor, long royaltyBase) {
        CellBuilder royaltyCell = CellBuilder.beginCell();
        royaltyCell.storeUint((long)(royaltyFactor * 100.0), 16);
        royaltyCell.storeUint(royaltyBase, 16);
        royaltyCell.storeAddress(royaltyAddress);
        return royaltyCell.endCell();
    }

    @Override
    public Cell createDataCell() {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeAddress(this.adminAddress);
        cell.storeUint(0, 64);
        cell.storeRef(NftCollection.createContentCell(this.collectionContentUri, this.collectionContentBaseUri));
        cell.storeRef(CellBuilder.beginCell().fromBoc(this.nftItemCodeHex).endCell());
        cell.storeRef(NftCollection.createRoyaltyCell(this.royaltyAddress, this.royalty, this.royaltyBase));
        return cell.endCell();
    }

    public static Cell createMintBody(long queryId, long itemIndex, BigInteger amount, Address nftItemOwnerAddress, String nftItemContentUri) {
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(1, 32);
        body.storeUint(queryId, 64);
        body.storeUint(itemIndex, 64);
        body.storeCoins(amount);
        CellBuilder nftItemContent = CellBuilder.beginCell();
        nftItemContent.storeAddress(nftItemOwnerAddress);
        CellBuilder uriContent = CellBuilder.beginCell();
        uriContent.storeBytes(NftUtils.serializeUri(nftItemContentUri));
        nftItemContent.storeRef(uriContent.endCell());
        body.storeRef(nftItemContent.endCell());
        return body.endCell();
    }

    public static Cell createGetRoyaltyParamsBody(long queryId) {
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(1765620048, 32);
        body.storeUint(BigInteger.valueOf(queryId), 64);
        return body.endCell();
    }

    public static Cell createChangeOwnerBody(long queryId, Address newOwnerAddress) {
        if (Objects.isNull(newOwnerAddress)) {
            throw new Error("Specify newOwnerAddress");
        }
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(3, 32);
        body.storeUint(BigInteger.valueOf(queryId), 64);
        body.storeAddress(newOwnerAddress);
        return body.endCell();
    }

    public static Cell createEditContentBody(long queryId, String collectionContentUri, String nftItemContentBaseUri, double royalty, Address royaltyAddress) {
        if (royalty > 1.0) {
            throw new Error("royalty > 1");
        }
        int royaltyBase = 1000;
        double royaltyFactor = Math.floor(royalty * (double)royaltyBase);
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(4, 32);
        body.storeUint(BigInteger.valueOf(queryId), 64);
        body.storeRef(NftCollection.createContentCell(collectionContentUri, nftItemContentBaseUri));
        body.storeRef(NftCollection.createRoyaltyCell(royaltyAddress, royaltyFactor, royaltyBase));
        return body.endCell();
    }

    public CollectionData getCollectionData(Tonlib tonlib) {
        Address myAddress = this.getAddress();
        RunResult result = tonlib.runMethod(myAddress, "get_collection_data");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_collection_data, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber itemsCountNumber = (TvmStackEntryNumber)result.getStack().get(0);
        long nextItemIndex = itemsCountNumber.getNumber().longValue();
        TvmStackEntryCell collectionContent = (TvmStackEntryCell)result.getStack().get(1);
        Cell collectionContentCell = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)collectionContent.getCell().getBytes())).endCell();
        String collectionContentUri = null;
        try {
            collectionContentUri = NftUtils.parseOffChainUriCell(collectionContentCell);
        }
        catch (Error error) {
            // empty catch block
        }
        TvmStackEntrySlice ownerAddressCell = (TvmStackEntrySlice)result.getStack().get(2);
        Address ownerAddress = NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)ownerAddressCell.getSlice().getBytes())).endCell());
        return CollectionData.builder().nextItemIndex(nextItemIndex).ownerAddress(ownerAddress).collectionContentCell(collectionContentCell).collectionContentUri(collectionContentUri).build();
    }

    public ItemData getNftItemContent(Tonlib tonlib, NftItem nftItem) {
        ItemData nftData = nftItem.getData(tonlib);
        if (nftData.isInitialized()) {
            ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
            stack.offer((CallSite)((Object)("[num, " + String.valueOf(nftData.getIndex()) + "]")));
            stack.offer((CallSite)((Object)("[slice, " + nftData.getContentCell().toHex(true) + "]")));
            RunResult result = tonlib.runMethod(this.getAddress(), "get_nft_content", stack);
            if (result.getExit_code() != 0L) {
                throw new Error("method get_nft_content, returned an exit code " + result.getExit_code());
            }
            TvmStackEntryCell contentCell = (TvmStackEntryCell)result.getStack().get(2);
            Cell content = CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)contentCell.getCell().getBytes())).endCell();
            try {
                nftData.setContentUri(NftUtils.parseOffChainUriCell(content));
            }
            catch (Error error) {
                // empty catch block
            }
        }
        return nftData;
    }

    public Address getNftItemAddressByIndex(Tonlib tonlib, BigInteger index) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + index.toString(10) + "]")));
        RunResult result = tonlib.runMethod(myAddress, "get_nft_address_by_index", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_nft_address_by_index, returned an exit code " + result.getExit_code());
        }
        TvmStackEntrySlice addrCell = (TvmStackEntrySlice)result.getStack().get(0);
        return NftUtils.parseAddress(CellBuilder.beginCell().fromBoc(Utils.base64ToBytes((String)addrCell.getSlice().getBytes())).endCell());
    }

    public Royalty getRoyaltyParams(Tonlib tonlib) {
        Address myAddress = this.getAddress();
        return NftUtils.getRoyaltyParams(tonlib, myAddress);
    }

    public ExtMessageInfo deploy(Tonlib tonlib, NftCollectionConfig config) {
        long seqno = this.getSeqno();
        config.setSeqno(seqno);
        Address ownAddress = this.getAddress();
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().srcAddr((MsgAddressExt)MsgAddressExtNone.builder().build()).dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(ownAddress.wc).address(ownAddress.toBigInteger()).build()).build()).init(this.getStateInit()).build();
        return tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    NftCollection(long royaltyBase, double royaltyFactor, Address adminAddress, String collectionContentUri, String collectionContentBaseUri, String nftItemCodeHex, Double royalty, Address royaltyAddress, Tonlib tonlib, long wc) {
        this.royaltyBase = royaltyBase;
        this.royaltyFactor = royaltyFactor;
        this.adminAddress = adminAddress;
        this.collectionContentUri = collectionContentUri;
        this.collectionContentBaseUri = collectionContentBaseUri;
        this.nftItemCodeHex = nftItemCodeHex;
        this.royalty = royalty;
        this.royaltyAddress = royaltyAddress;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public long getRoyaltyBase() {
        return this.royaltyBase;
    }

    public double getRoyaltyFactor() {
        return this.royaltyFactor;
    }

    public Address getAdminAddress() {
        return this.adminAddress;
    }

    public String getCollectionContentUri() {
        return this.collectionContentUri;
    }

    public String getCollectionContentBaseUri() {
        return this.collectionContentBaseUri;
    }

    public String getNftItemCodeHex() {
        return this.nftItemCodeHex;
    }

    public Double getRoyalty() {
        return this.royalty;
    }

    public Address getRoyaltyAddress() {
        return this.royaltyAddress;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomNftCollectionBuilder
    extends NftCollectionBuilder {
        private CustomNftCollectionBuilder() {
        }

        @Override
        public NftCollection build() {
            this.royaltyBase = 1000L;
            return super.build();
        }
    }

    public static class NftCollectionBuilder {
        private long royaltyBase;
        private double royaltyFactor;
        private Address adminAddress;
        private String collectionContentUri;
        private String collectionContentBaseUri;
        private String nftItemCodeHex;
        private Double royalty;
        private Address royaltyAddress;
        private Tonlib tonlib;
        private long wc;

        NftCollectionBuilder() {
        }

        public NftCollectionBuilder royaltyBase(long royaltyBase) {
            this.royaltyBase = royaltyBase;
            return this;
        }

        public NftCollectionBuilder royaltyFactor(double royaltyFactor) {
            this.royaltyFactor = royaltyFactor;
            return this;
        }

        public NftCollectionBuilder adminAddress(Address adminAddress) {
            this.adminAddress = adminAddress;
            return this;
        }

        public NftCollectionBuilder collectionContentUri(String collectionContentUri) {
            this.collectionContentUri = collectionContentUri;
            return this;
        }

        public NftCollectionBuilder collectionContentBaseUri(String collectionContentBaseUri) {
            this.collectionContentBaseUri = collectionContentBaseUri;
            return this;
        }

        public NftCollectionBuilder nftItemCodeHex(String nftItemCodeHex) {
            this.nftItemCodeHex = nftItemCodeHex;
            return this;
        }

        public NftCollectionBuilder royalty(Double royalty) {
            this.royalty = royalty;
            return this;
        }

        public NftCollectionBuilder royaltyAddress(Address royaltyAddress) {
            this.royaltyAddress = royaltyAddress;
            return this;
        }

        public NftCollectionBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public NftCollectionBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public NftCollection build() {
            return new NftCollection(this.royaltyBase, this.royaltyFactor, this.adminAddress, this.collectionContentUri, this.collectionContentBaseUri, this.nftItemCodeHex, this.royalty, this.royaltyAddress, this.tonlib, this.wc);
        }

        public String toString() {
            return "NftCollection.NftCollectionBuilder(royaltyBase=" + this.royaltyBase + ", royaltyFactor=" + this.royaltyFactor + ", adminAddress=" + String.valueOf(this.adminAddress) + ", collectionContentUri=" + this.collectionContentUri + ", collectionContentBaseUri=" + this.collectionContentBaseUri + ", nftItemCodeHex=" + this.nftItemCodeHex + ", royalty=" + this.royalty + ", royaltyAddress=" + String.valueOf(this.royaltyAddress) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

