/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.multisig;

import com.iwebpp.crypto.TweetNaclFast;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.TonHashMap;
import org.ton.java.cell.TonHashMapE;
import org.ton.java.smartcontract.types.MultiSigConfig;
import org.ton.java.smartcontract.types.MultisigSignature;
import org.ton.java.smartcontract.types.OwnerInfo;
import org.ton.java.smartcontract.types.PendingQuery;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.CommonMsgInfoRelaxed;
import org.ton.java.tlb.CurrencyCollection;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.InternalMessageInfoRelaxed;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MessageRelaxed;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tlb.MsgAddressIntStd;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.ExtraCurrency;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryCell;
import org.ton.java.tonlib.types.TvmStackEntryList;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

@Deprecated
public class MultiSigWallet
implements Contract {
    private static final Logger log = LoggerFactory.getLogger(MultiSigWallet.class);
    TweetNaclFast.Signature.KeyPair keyPair;
    long walletId;
    MultiSigConfig config;
    private Tonlib tonlib;
    private long wc;

    public static MultiSigWalletBuilder builder() {
        return new CustomMultiSigWalletBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "multisig";
    }

    @Override
    public Cell createDataCell() {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(this.walletId, 32);
        cell.storeUint(this.config.getN(), 8);
        cell.storeUint(this.config.getK(), 8);
        cell.storeUint(0, 64);
        if (Objects.isNull(this.config.getOwners()) || this.config.getOwners().isEmpty()) {
            cell.storeBit(Boolean.valueOf(false));
        } else {
            cell.storeDict(this.createOwnersInfoDict(this.config.getOwners()));
        }
        if (Objects.isNull(this.config.getPendingQueries()) || this.config.getPendingQueries().isEmpty()) {
            cell.storeBit(Boolean.valueOf(false));
        } else {
            cell.storeDict(MultiSigWallet.createPendingQueries(this.config.getPendingQueries(), this.config.getN()));
        }
        return cell.endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.multisig.getValue()).endCell();
    }

    private Cell createSigningMessageInternal(int pubkeyIndex, Cell order) {
        return CellBuilder.beginCell().storeUint(pubkeyIndex, 8).storeCell(order).endCell();
    }

    public List<BigInteger> getPublicKeys() {
        ArrayList<BigInteger> publicKeys = new ArrayList<BigInteger>();
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_public_keys");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_public_keys, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryCell cellResult = (TvmStackEntryCell)result.getStack().get(0);
        Cell cell = CellBuilder.beginCell().fromBocBase64(cellResult.getCell().getBytes()).endCell();
        CellSlice cs = CellSlice.beginParse((Cell)cell);
        TonHashMap loadedDict = cs.loadDict(8, k -> k.readUint(8), v -> v);
        for (Map.Entry entry : loadedDict.elements.entrySet()) {
            CellSlice cSlice = CellSlice.beginParse((Cell)((Cell)entry.getValue()));
            BigInteger pubKey = cSlice.loadUint(256);
            publicKeys.add(pubKey);
        }
        return publicKeys;
    }

    public List<String> getPublicKeysHex() {
        List<BigInteger> l = this.getPublicKeys();
        ArrayList<String> result = new ArrayList<String>();
        for (BigInteger i : l) {
            result.add(i.toString(16));
        }
        return result;
    }

    public Cell getInitState(long walletId, int n, int k, Cell ownersInfo) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + walletId + "]")));
        stack.offer((CallSite)((Object)("[num, " + n + "]")));
        stack.offer((CallSite)((Object)("[num, " + k + "]")));
        stack.offer((CallSite)((Object)("[cell, " + ownersInfo.toHex(false) + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "create_init_state", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method createInitState, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryCell domainCell = (TvmStackEntryCell)result.getStack().get(0);
        return CellBuilder.beginCell().fromBocBase64(domainCell.getCell().getBytes()).endCell();
    }

    public ExtMessageInfo sendOrder(TweetNaclFast.Signature.KeyPair keyPair, int pubkeyIndex, Cell order) {
        Cell signingMessageBody = this.createSigningMessageInternal(pubkeyIndex, order);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])keyPair.getPublicKey(), (byte[])keyPair.getSecretKey(), (byte[])signingMessageBody.hash())).storeCell(signingMessageBody).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public ExtMessageInfo sendOrder(byte[] secretKey, int pubkeyIndex, Cell order) {
        Cell signingMessageBody = this.createSigningMessageInternal(pubkeyIndex, order);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])secretKey, (byte[])signingMessageBody.hash())).storeCell(signingMessageBody).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public Cell createOwnersInfoDict(List<OwnerInfo> ownersInfo) {
        int dictKeySize = 8;
        TonHashMapE dictDestinations = new TonHashMapE(dictKeySize);
        long i = 0L;
        for (OwnerInfo ownerInfo : ownersInfo) {
            CellBuilder ownerInfoCell = CellBuilder.beginCell();
            ownerInfoCell.storeBytes(ownerInfo.getPublicKey());
            ownerInfoCell.storeUint(ownerInfo.getFlood(), 8);
            dictDestinations.elements.put(i++, ownerInfoCell.endCell());
        }
        Cell cellDict = dictDestinations.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), dictKeySize).endCell().getBits(), v -> (Cell)v);
        return cellDict;
    }

    public static Cell createPendingQueries(List<PendingQuery> pendingQueries, int n) {
        int dictKeySize = 64;
        TonHashMapE dictDestinations = new TonHashMapE(dictKeySize);
        long i = 0L;
        for (PendingQuery query : pendingQueries) {
            CellBuilder queryCell = CellBuilder.beginCell();
            queryCell.storeBit(Boolean.valueOf(true));
            queryCell.storeUint(query.getCreatorI(), 8);
            queryCell.storeUint(query.getCnt(), 8);
            queryCell.storeUint(query.getCntBits(), n);
            queryCell.storeCell(query.getMsg());
            dictDestinations.elements.put(query.getQueryId(), queryCell.endCell());
        }
        Cell cellDict = dictDestinations.serialize(k -> CellBuilder.beginCell().storeUint((BigInteger)k, dictKeySize).endCell().getBits(), v -> (Cell)v);
        return cellDict;
    }

    public static Cell createSignaturesDict(List<byte[]> signatures) {
        int dictKeySize = 8;
        TonHashMapE dictSignatures = new TonHashMapE(dictKeySize);
        long i = 0L;
        for (byte[] signature : signatures) {
            CellBuilder sigCell = CellBuilder.beginCell();
            sigCell.storeBytes(signature);
            sigCell.storeUint(i, 8);
            dictSignatures.elements.put(i, sigCell.endCell());
            ++i;
        }
        Cell cellDict = dictSignatures.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), dictKeySize).endCell().getBits(), v -> (Cell)v);
        return cellDict;
    }

    public static Cell serializeSignatures(int i, List<MultisigSignature> signatures) {
        CellBuilder c = CellBuilder.beginCell();
        c.storeBytes(signatures.get(i).getSignature());
        c.storeUint(signatures.get(i).getPubKeyPosition(), 8);
        if (i == signatures.size() - 1) {
            c.storeBit(Boolean.valueOf(false));
        } else {
            c.storeBit(Boolean.valueOf(true));
            c.storeRef(MultiSigWallet.serializeSignatures(++i, signatures));
        }
        return c.endCell();
    }

    public static Cell createQuery(TweetNaclFast.Signature.KeyPair keyPair, List<MultisigSignature> signatures, Cell order) {
        CellBuilder rootCell = CellBuilder.beginCell();
        rootCell.storeUint(0, 8);
        if (Objects.isNull(signatures) || signatures.isEmpty()) {
            rootCell.storeBit(Boolean.valueOf(false));
        } else {
            rootCell.storeBit(Boolean.valueOf(true));
            rootCell.storeRef(MultiSigWallet.serializeSignatures(0, signatures));
        }
        CellSlice cs = CellSlice.beginParse((Cell)order);
        cs.skipBit();
        CellBuilder o = CellBuilder.beginCell();
        o.storeCell(cs.sliceToCell());
        rootCell.storeCell(o.endCell());
        byte[] rootSignature = MultiSigWallet.signCell(keyPair, rootCell.endCell());
        CellBuilder query = CellBuilder.beginCell();
        query.storeBytes(rootSignature);
        query.storeCell(rootCell.endCell());
        return query.endCell();
    }

    public ExtMessageInfo deploy() {
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    public static Cell createOneInternalMsg(Address destination, BigInteger amount, int mode) {
        MessageRelaxed internalMessage = MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).build()).build()).build();
        CellBuilder p = CellBuilder.beginCell();
        p.storeUint(mode, 8);
        p.storeRef(internalMessage.toCell());
        return p.endCell();
    }

    public static Cell createOneInternalMsg(Address destination, BigInteger amount, List<ExtraCurrency> extraCurrencies, int mode) {
        MessageRelaxed internalMessage = MessageRelaxed.builder().info((CommonMsgInfoRelaxed)InternalMessageInfoRelaxed.builder().dstAddr((MsgAddressInt)MsgAddressIntStd.builder().workchainId(destination.wc).address(destination.toBigInteger()).build()).value(CurrencyCollection.builder().coins(amount).extraCurrencies(MultiSigWallet.convertExtraCurrenciesToMap(extraCurrencies)).build()).build()).build();
        CellBuilder p = CellBuilder.beginCell();
        p.storeUint(mode, 8);
        p.storeRef(internalMessage.toCell());
        return p.endCell();
    }

    public static Cell createOrder(Long walletId, BigInteger queryId, Cell ... internalMsgs) {
        if (internalMsgs.length > 3) {
            throw new Error("Order cannot contain more than 3 internal messages");
        }
        CellBuilder order = CellBuilder.beginCell();
        order.storeBit(Boolean.valueOf(false));
        order.storeUint(walletId.longValue(), 32);
        order.storeUint(queryId, 64);
        for (Cell msg : internalMsgs) {
            order.storeCell(msg);
        }
        return order.endCell();
    }

    public static Cell createOrder1(Long walletId, BigInteger queryId, Cell ... internalMsgs) {
        if (internalMsgs.length > 3) {
            throw new Error("Order cannot contain more than 3 internal messages");
        }
        CellBuilder order = CellBuilder.beginCell();
        order.storeUint(walletId.longValue(), 32);
        order.storeUint(queryId, 64);
        for (Cell msg : internalMsgs) {
            order.storeCell(msg);
        }
        return order.endCell();
    }

    public static Cell addSignatures(Cell order, List<MultisigSignature> signatures) {
        CellBuilder signedOrder = CellBuilder.beginCell();
        signedOrder.storeBit(Boolean.valueOf(true));
        signedOrder.storeRef(MultiSigWallet.serializeSignatures(0, signatures));
        CellSlice cs = CellSlice.beginParse((Cell)order);
        cs.skipBit();
        CellBuilder o = CellBuilder.beginCell();
        o.storeCell(cs.sliceToCell());
        signedOrder.storeCell(o.endCell());
        return signedOrder.endCell();
    }

    private static void checkIfSignatureExists(Cell order, byte[] signature) {
        CellSlice cs = CellSlice.beginParse((Cell)order);
        if (cs.loadBit()) {
            Cell ref = cs.loadRef();
            while (Objects.nonNull(ref)) {
                byte[] sig = CellSlice.beginParse((Cell)ref).loadBytes(512);
                log.info("sig " + Utils.bytesToHex((byte[])signature));
                if (sig == signature) {
                    throw new Error("Your signature is already presented");
                }
                if (ref.getUsedRefs() != 0) {
                    ref = (Cell)ref.getRefs().get(0);
                    continue;
                }
                ref = null;
            }
        }
    }

    public static Cell addSignature1(Cell order, int pubkeyIndex, TweetNaclFast.Signature.KeyPair keyPair) {
        CellSlice cs = CellSlice.beginParse((Cell)order);
        cs.skipBit();
        CellBuilder o = CellBuilder.beginCell();
        o.storeCell(cs.sliceToCell());
        byte[] signature = MultiSigWallet.signCell(keyPair, o.endCell());
        log.info("sig " + Utils.bytesToHex((byte[])signature));
        cs = CellSlice.beginParse((Cell)order);
        if (!cs.loadBit()) {
            cs.skipBit();
            CellBuilder signedOrder = CellBuilder.beginCell();
            signedOrder.storeBit(Boolean.valueOf(true));
            CellBuilder c = CellBuilder.beginCell();
            c.storeBytes(signature);
            c.storeUint(pubkeyIndex, 8);
            c.storeBit(Boolean.valueOf(false));
            signedOrder.storeRef(c.endCell());
            signedOrder.storeCell(o.endCell());
            return signedOrder.endCell();
        }
        Cell otherSignatures = cs.loadRef();
        CellBuilder signedOrder = CellBuilder.beginCell();
        signedOrder.storeBit(Boolean.valueOf(true));
        CellBuilder c = CellBuilder.beginCell();
        c.storeBytes(signature);
        c.storeUint(pubkeyIndex, 8);
        c.storeBit(Boolean.valueOf(true));
        c.storeRef(otherSignatures);
        signedOrder.storeRef(c.endCell());
        signedOrder.storeCell(o.endCell());
        return signedOrder.endCell();
    }

    public static byte[] signCell(TweetNaclFast.Signature.KeyPair keyPair, Cell cell) {
        return new TweetNaclFast.Signature(keyPair.getPublicKey(), keyPair.getSecretKey()).detached(cell.hash());
    }

    public static byte[] signOrder(TweetNaclFast.Signature.KeyPair keyPair, Cell order) {
        CellSlice cs = CellSlice.beginParse((Cell)order);
        cs.skipBit();
        CellBuilder o = CellBuilder.beginCell();
        o.storeCell(cs.sliceToCell());
        return MultiSigWallet.signCell(keyPair, o.endCell());
    }

    public Pair<Long, Long> getNandK() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_n_k");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_n_k, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber nNumber = (TvmStackEntryNumber)result.getStack().get(0);
        TvmStackEntryNumber kNumber = (TvmStackEntryNumber)result.getStack().get(1);
        return Pair.of((Object)nNumber.getNumber().longValue(), (Object)kNumber.getNumber().longValue());
    }

    public Map<BigInteger, Cell> getMessagesUnsigned() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_messages_unsigned");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_messages_unsigned, returned an exit code " + result.getExit_code());
        }
        if (result.getStack().get(0) instanceof TvmStackEntryList) {
            return new HashMap<BigInteger, Cell>();
        }
        TvmStackEntryCell entryCell = (TvmStackEntryCell)result.getStack().get(0);
        Cell cellDict = CellBuilder.beginCell().fromBocBase64(entryCell.getCell().getBytes()).endCell();
        CellSlice cs = CellSlice.beginParse((Cell)cellDict);
        TonHashMap loadedDict = cs.loadDict(64, k -> k.readUint(64), v -> v);
        HashMap<BigInteger, Cell> resultMap = new HashMap<BigInteger, Cell>();
        for (Map.Entry entry : loadedDict.elements.entrySet()) {
            resultMap.put((BigInteger)entry.getKey(), (Cell)entry.getValue());
        }
        return resultMap;
    }

    public Map<BigInteger, Cell> getMessagesSignedByIndex(long index) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + index + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "get_messages_signed_by_id", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_messages_signed_by_id, returned an exit code " + result.getExit_code());
        }
        if (result.getStack().get(0) instanceof TvmStackEntryList) {
            return new HashMap<BigInteger, Cell>();
        }
        TvmStackEntryCell entryCell = (TvmStackEntryCell)result.getStack().get(0);
        Cell cellDict = CellBuilder.beginCell().fromBocBase64(entryCell.getCell().getBytes()).endCell();
        CellSlice cs = CellSlice.beginParse((Cell)cellDict);
        TonHashMap loadedDict = cs.loadDict(64, k -> k.readUint(64), v -> v);
        HashMap<BigInteger, Cell> resultMap = new HashMap<BigInteger, Cell>();
        for (Map.Entry entry : loadedDict.elements.entrySet()) {
            resultMap.put((BigInteger)entry.getKey(), (Cell)entry.getValue());
        }
        return resultMap;
    }

    public Map<BigInteger, Cell> getMessagesUnsignedByIndex(long index) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + index + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "get_messages_unsigned_by_id", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_messages_unsigned_by_id, returned an exit code " + result.getExit_code());
        }
        if (result.getStack().get(0) instanceof TvmStackEntryList) {
            return new HashMap<BigInteger, Cell>();
        }
        TvmStackEntryCell entryCell = (TvmStackEntryCell)result.getStack().get(0);
        Cell cellDict = CellBuilder.beginCell().fromBocBase64(entryCell.getCell().getBytes()).endCell();
        CellSlice cs = CellSlice.beginParse((Cell)cellDict);
        TonHashMap loadedDict = cs.loadDict(64, k -> k.readUint(64), v -> v);
        HashMap<BigInteger, Cell> resultMap = new HashMap<BigInteger, Cell>();
        for (Map.Entry entry : loadedDict.elements.entrySet()) {
            resultMap.put((BigInteger)entry.getKey(), (Cell)entry.getValue());
        }
        return resultMap;
    }

    public Pair<Long, Long> getQueryState(BigInteger queryId) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + queryId.toString(10) + "]")));
        RunResult result = this.tonlib.runMethod(myAddress, "get_query_state", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method get_query_state, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber r = (TvmStackEntryNumber)result.getStack().get(0);
        TvmStackEntryNumber n = (TvmStackEntryNumber)result.getStack().get(1);
        return Pair.of((Object)r.getNumber().longValue(), (Object)n.getNumber().longValue());
    }

    public Pair<Long, Long> checkQuerySignatures(Tonlib tonlib, Cell query) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[cell, " + query.toHex(false) + "]")));
        RunResult result = tonlib.runMethod(myAddress, "check_query_signatures", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method check_query_signatures, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber cnt = (TvmStackEntryNumber)result.getStack().get(0);
        TvmStackEntryNumber mask = (TvmStackEntryNumber)result.getStack().get(1);
        return Pair.of((Object)cnt.getNumber().longValue(), (Object)mask.getNumber().longValue());
    }

    public Cell mergePendingQueries(Tonlib tonlib, Cell a, Cell b) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[cell, " + a.toHex(false) + "]")));
        stack.offer((CallSite)((Object)("[cell, " + b.toHex(false) + "]")));
        RunResult result = tonlib.runMethod(myAddress, "merge_inner_queries", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method merge_inner_queries, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryCell entryCell = (TvmStackEntryCell)result.getStack().get(0);
        return CellBuilder.beginCell().fromBocBase64(entryCell.getCell().getBytes()).endCell();
    }

    public long processed(Tonlib tonlib, BigInteger queryId) {
        Address myAddress = this.getAddress();
        ArrayDeque<CallSite> stack = new ArrayDeque<CallSite>();
        stack.offer((CallSite)((Object)("[num, " + queryId.toString(10) + "]")));
        RunResult result = tonlib.runMethod(myAddress, "processed?", stack);
        if (result.getExit_code() != 0L) {
            throw new Error("method processed, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber cnt = (TvmStackEntryNumber)result.getStack().get(0);
        return cnt.getNumber().longValue();
    }

    private static TonHashMapE convertExtraCurrenciesToMap(List<ExtraCurrency> extraCurrencies) {
        if (Objects.isNull(extraCurrencies)) {
            return null;
        }
        TonHashMapE x = new TonHashMapE(32);
        for (ExtraCurrency ec : extraCurrencies) {
            x.elements.put(ec.getId(), ec.getAmount());
        }
        return x;
    }

    MultiSigWallet(TweetNaclFast.Signature.KeyPair keyPair, long walletId, MultiSigConfig config, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.walletId = walletId;
        this.config = config;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getWalletId() {
        return this.walletId;
    }

    public MultiSigConfig getConfig() {
        return this.config;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomMultiSigWalletBuilder
    extends MultiSigWalletBuilder {
        private CustomMultiSigWalletBuilder() {
        }

        @Override
        public MultiSigWallet build() {
            if (Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class MultiSigWalletBuilder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long walletId;
        private MultiSigConfig config;
        private Tonlib tonlib;
        private long wc;

        MultiSigWalletBuilder() {
        }

        public MultiSigWalletBuilder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public MultiSigWalletBuilder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public MultiSigWalletBuilder config(MultiSigConfig config) {
            this.config = config;
            return this;
        }

        public MultiSigWalletBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public MultiSigWalletBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public MultiSigWallet build() {
            return new MultiSigWallet(this.keyPair, this.walletId, this.config, this.tonlib, this.wc);
        }

        public String toString() {
            return "MultiSigWallet.MultiSigWalletBuilder(keyPair=" + String.valueOf(this.keyPair) + ", walletId=" + this.walletId + ", config=" + String.valueOf(this.config) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

