/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract.highload;

import com.iwebpp.crypto.TweetNaclFast;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.address.Address;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.TonHashMap;
import org.ton.java.smartcontract.types.Destination;
import org.ton.java.smartcontract.types.HighloadConfig;
import org.ton.java.smartcontract.types.WalletCodes;
import org.ton.java.smartcontract.utils.MsgUtils;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.tonlib.types.RunResult;
import org.ton.java.tonlib.types.TvmStackEntryNumber;
import org.ton.java.utils.Utils;

@Deprecated
public class HighloadWallet
implements Contract {
    TweetNaclFast.Signature.KeyPair keyPair;
    long walletId;
    byte[] publicKey;
    BigInteger queryId;
    private Tonlib tonlib;
    private long wc;

    public static HighloadWalletBuilder builder() {
        return new CustomHighloadWalletBuilder();
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public String getName() {
        return "highload-v2";
    }

    @Override
    public Cell createDataCell() {
        CellBuilder cell = CellBuilder.beginCell();
        cell.storeUint(this.walletId, 32);
        cell.storeUint(BigInteger.ZERO, 64);
        cell.storeBytes(Objects.isNull(this.keyPair) ? this.publicKey : this.keyPair.getPublicKey());
        cell.storeBit(Boolean.valueOf(false));
        return cell.endCell();
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(WalletCodes.highload.getValue()).endCell();
    }

    public Cell createDeployMessage() {
        return CellBuilder.beginCell().storeUint(this.walletId, 32).storeUint(this.queryId, 64).storeBit(Boolean.valueOf(false)).endCell();
    }

    public Cell createTransferBody(HighloadConfig config) {
        CellBuilder body = CellBuilder.beginCell();
        body.storeUint(config.getWalletId(), 32);
        body.storeUint(config.getQueryId(), 64);
        if (Objects.nonNull(config.getDestinations())) {
            body.storeBit(Boolean.valueOf(true));
            body.storeRef(this.createDict(config));
        } else {
            body.storeBit(Boolean.valueOf(false));
        }
        return body.endCell();
    }

    @Override
    public Message prepareDeployMsg() {
        Cell body = this.createDeployMessage();
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
    }

    public String getPublicKey() {
        Address myAddress = this.getAddress();
        RunResult result = this.tonlib.runMethod(myAddress, "get_public_key");
        if (result.getExit_code() != 0L) {
            throw new Error("method get_public_key, returned an exit code " + result.getExit_code());
        }
        TvmStackEntryNumber publicKeyNumber = (TvmStackEntryNumber)result.getStack().get(0);
        return publicKeyNumber.getNumber().toString(16);
    }

    public ExtMessageInfo send(HighloadConfig highloadConfig) {
        Cell body = this.createTransferBody(highloadConfig);
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    private Cell createDict(HighloadConfig config) {
        int dictKeySize = 16;
        TonHashMap dictDestinations = new TonHashMap(dictKeySize);
        long i = 0L;
        for (Destination destination : config.getDestinations()) {
            Cell order = destination.isBounce() ? (Objects.isNull(destination.getBody()) && Objects.nonNull(destination.getComment()) ? MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, CellBuilder.beginCell().storeUint(0, 32).storeString(destination.getComment()).endCell(), true).toCell() : (Objects.nonNull(destination.getBody()) ? MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, destination.getBody(), true).toCell() : MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, null, true).toCell())) : (Objects.isNull(destination.getBody()) && Objects.nonNull(destination.getComment()) ? MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, CellBuilder.beginCell().storeUint(0, 32).storeString(destination.getComment()).endCell(), false).toCell() : (Objects.nonNull(destination.getBody()) ? MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, destination.getBody(), false).toCell() : MsgUtils.createInternalMessage(this.getAddress(), Address.of((String)destination.getAddress()), destination.getAmount(), destination.getExtraCurrencies(), null, null, false).toCell()));
            CellBuilder p = CellBuilder.beginCell().storeUint(destination.getMode() == 0 ? 3 : destination.getMode() & 0xFF, 8).storeRef(order);
            dictDestinations.elements.put(i++, p.endCell());
        }
        Cell cellDict = dictDestinations.serialize(k -> CellBuilder.beginCell().storeUint(((Long)k).longValue(), dictKeySize).endCell().getBits(), v -> (Cell)v);
        return cellDict;
    }

    public ExtMessageInfo deploy() {
        Cell body = this.createDeployMessage();
        Message externalMessage = Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])body.hash())).storeCell(body).endCell()).build();
        return this.tonlib.sendRawMessage(externalMessage.toCell().toBase64());
    }

    HighloadWallet(TweetNaclFast.Signature.KeyPair keyPair, long walletId, byte[] publicKey, BigInteger queryId, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.walletId = walletId;
        this.publicKey = publicKey;
        this.queryId = queryId;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public long getWalletId() {
        return this.walletId;
    }

    public BigInteger getQueryId() {
        return this.queryId;
    }

    public long getWc() {
        return this.wc;
    }

    private static class CustomHighloadWalletBuilder
    extends HighloadWalletBuilder {
        private CustomHighloadWalletBuilder() {
        }

        @Override
        public HighloadWallet build() {
            if (Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class HighloadWalletBuilder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private long walletId;
        private byte[] publicKey;
        private BigInteger queryId;
        private Tonlib tonlib;
        private long wc;

        HighloadWalletBuilder() {
        }

        public HighloadWalletBuilder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public HighloadWalletBuilder walletId(long walletId) {
            this.walletId = walletId;
            return this;
        }

        public HighloadWalletBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public HighloadWalletBuilder queryId(BigInteger queryId) {
            this.queryId = queryId;
            return this;
        }

        public HighloadWalletBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public HighloadWalletBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public HighloadWallet build() {
            return new HighloadWallet(this.keyPair, this.walletId, this.publicKey, this.queryId, this.tonlib, this.wc);
        }

        public String toString() {
            return "HighloadWallet.HighloadWalletBuilder(keyPair=" + String.valueOf(this.keyPair) + ", walletId=" + this.walletId + ", publicKey=" + Arrays.toString(this.publicKey) + ", queryId=" + String.valueOf(this.queryId) + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

