/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.smartcontract;

import com.iwebpp.crypto.TweetNaclFast;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.smartcontract.wallet.Contract;
import org.ton.java.tlb.CommonMsgInfo;
import org.ton.java.tlb.ExternalMessageInInfo;
import org.ton.java.tlb.Message;
import org.ton.java.tlb.MsgAddressInt;
import org.ton.java.tonlib.Tonlib;
import org.ton.java.tonlib.types.ExtMessageInfo;
import org.ton.java.utils.Utils;

public class GenericSmartContract
implements Contract {
    TweetNaclFast.Signature.KeyPair keyPair;
    byte[] publicKey;
    String code;
    String data;
    private Tonlib tonlib;
    private long wc;

    @Override
    public long getWorkchain() {
        return this.wc;
    }

    @Override
    public Tonlib getTonlib() {
        return this.tonlib;
    }

    @Override
    public void setTonlib(Tonlib pTonlib) {
        this.tonlib = pTonlib;
    }

    @Override
    public String getName() {
        return "GenericSmartContract";
    }

    @Override
    public Cell createCodeCell() {
        return CellBuilder.beginCell().fromBoc(this.code).endCell();
    }

    @Override
    public Cell createDataCell() {
        return CellBuilder.beginCell().fromBoc(this.data).endCell();
    }

    public static GenericSmartContractBuilder builder() {
        return new CustomGenericSmartContractBuilder();
    }

    public ExtMessageInfo deploy(Cell deployMessageBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(deployMessageBody).toCell().toBase64());
    }

    public ExtMessageInfo deployWithoutSignature(Cell deployMessageBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsgWithoutSignature(deployMessageBody).toCell().toBase64());
    }

    public ExtMessageInfo deploy() {
        return this.tonlib.sendRawMessage(this.prepareDeployMsgWithoutBody().toCell().toBase64());
    }

    public ExtMessageInfo deploy(Cell deployMessageBody, byte[] signedBody) {
        return this.tonlib.sendRawMessage(this.prepareDeployMsg(deployMessageBody, signedBody).toCell().toBase64());
    }

    public Message prepareDeployMsgWithoutBody() {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).build();
    }

    public Message prepareDeployMsg(Cell deployMessageBody, byte[] signedBodyHash) {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(signedBodyHash).storeCell(deployMessageBody).endCell()).build();
    }

    public Message prepareDeployMsg(Cell deployMessageBody) {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(CellBuilder.beginCell().storeBytes(Utils.signData((byte[])this.keyPair.getPublicKey(), (byte[])this.keyPair.getSecretKey(), (byte[])deployMessageBody.hash())).storeCell(deployMessageBody).endCell()).build();
    }

    public Message prepareDeployMsgWithoutSignature(Cell deployMessageBody) {
        return Message.builder().info((CommonMsgInfo)ExternalMessageInInfo.builder().dstAddr((MsgAddressInt)this.getAddressIntStd()).build()).init(this.getStateInit()).body(deployMessageBody).build();
    }

    GenericSmartContract(TweetNaclFast.Signature.KeyPair keyPair, byte[] publicKey, String code, String data, Tonlib tonlib, long wc) {
        this.keyPair = keyPair;
        this.publicKey = publicKey;
        this.code = code;
        this.data = data;
        this.tonlib = tonlib;
        this.wc = wc;
    }

    public TweetNaclFast.Signature.KeyPair getKeyPair() {
        return this.keyPair;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public String getCode() {
        return this.code;
    }

    public String getData() {
        return this.data;
    }

    public long getWc() {
        return this.wc;
    }

    public void setKeyPair(TweetNaclFast.Signature.KeyPair keyPair) {
        this.keyPair = keyPair;
    }

    public void setPublicKey(byte[] publicKey) {
        this.publicKey = publicKey;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setWc(long wc) {
        this.wc = wc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenericSmartContract)) {
            return false;
        }
        GenericSmartContract other = (GenericSmartContract)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWc() != other.getWc()) {
            return false;
        }
        TweetNaclFast.Signature.KeyPair this$keyPair = this.getKeyPair();
        TweetNaclFast.Signature.KeyPair other$keyPair = other.getKeyPair();
        if (this$keyPair == null ? other$keyPair != null : !this$keyPair.equals(other$keyPair)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        Tonlib this$tonlib = this.getTonlib();
        Tonlib other$tonlib = other.getTonlib();
        return !(this$tonlib == null ? other$tonlib != null : !this$tonlib.equals(other$tonlib));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenericSmartContract;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $wc = this.getWc();
        result = result * 59 + (int)($wc >>> 32 ^ $wc);
        TweetNaclFast.Signature.KeyPair $keyPair = this.getKeyPair();
        result = result * 59 + ($keyPair == null ? 43 : $keyPair.hashCode());
        result = result * 59 + Arrays.hashCode(this.getPublicKey());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        Tonlib $tonlib = this.getTonlib();
        result = result * 59 + ($tonlib == null ? 43 : $tonlib.hashCode());
        return result;
    }

    public String toString() {
        return "GenericSmartContract(keyPair=" + String.valueOf(this.getKeyPair()) + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ", code=" + this.getCode() + ", data=" + this.getData() + ", tonlib=" + String.valueOf(this.getTonlib()) + ", wc=" + this.getWc() + ")";
    }

    private static class CustomGenericSmartContractBuilder
    extends GenericSmartContractBuilder {
        private CustomGenericSmartContractBuilder() {
        }

        @Override
        public GenericSmartContract build() {
            if (Objects.isNull(this.publicKey) && Objects.isNull(this.keyPair)) {
                this.keyPair = Utils.generateSignatureKeyPair();
            }
            return super.build();
        }
    }

    public static class GenericSmartContractBuilder {
        private TweetNaclFast.Signature.KeyPair keyPair;
        private byte[] publicKey;
        private String code;
        private String data;
        private Tonlib tonlib;
        private long wc;

        GenericSmartContractBuilder() {
        }

        public GenericSmartContractBuilder keyPair(TweetNaclFast.Signature.KeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        public GenericSmartContractBuilder publicKey(byte[] publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        public GenericSmartContractBuilder code(String code) {
            this.code = code;
            return this;
        }

        public GenericSmartContractBuilder data(String data) {
            this.data = data;
            return this;
        }

        public GenericSmartContractBuilder tonlib(Tonlib tonlib) {
            this.tonlib = tonlib;
            return this;
        }

        public GenericSmartContractBuilder wc(long wc) {
            this.wc = wc;
            return this;
        }

        public GenericSmartContract build() {
            return new GenericSmartContract(this.keyPair, this.publicKey, this.code, this.data, this.tonlib, this.wc);
        }

        public String toString() {
            return "GenericSmartContract.GenericSmartContractBuilder(keyPair=" + String.valueOf(this.keyPair) + ", publicKey=" + Arrays.toString(this.publicKey) + ", code=" + this.code + ", data=" + this.data + ", tonlib=" + String.valueOf(this.tonlib) + ", wc=" + this.wc + ")";
        }
    }
}

