/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.func;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ton.java.utils.Utils;

public class FuncRunner {
    private static final Logger log = LoggerFactory.getLogger(FuncRunner.class);
    public String funcExecutablePath;
    private Boolean printInfo;
    public static String funcExecutable = "";

    public static FuncRunnerBuilder builder() {
        return new CustomFuncRunnerBuilder();
    }

    public String run(String workdir, String ... params) {
        Pair<Process, String> result = this.execute(funcExecutable, workdir, params);
        if (result != null && result.getRight() != null) {
            return (String)result.getRight();
        }
        return "";
    }

    public String getFuncPath() {
        return Utils.detectAbsolutePath((String)"func", (boolean)false);
    }

    public Pair<Process, String> execute(String pathToBinary, String workDir, String ... command) {
        Object[] withBinaryCommand = new String[]{pathToBinary};
        withBinaryCommand = (String[])ArrayUtils.addAll((Object[])withBinaryCommand, (Object[])command);
        try {
            if (this.printInfo.booleanValue()) {
                log.info("execute: " + String.join((CharSequence)" ", (CharSequence[])withBinaryCommand));
            }
            ProcessBuilder pb = new ProcessBuilder((String[])withBinaryCommand).redirectErrorStream(true);
            pb.directory(new File(workDir));
            Process p = pb.start();
            p.waitFor(1L, TimeUnit.SECONDS);
            String resultInput = IOUtils.toString((InputStream)p.getInputStream(), (Charset)Charset.defaultCharset());
            p.getInputStream().close();
            p.getErrorStream().close();
            p.getOutputStream().close();
            if (p.exitValue() == 2 || p.exitValue() == 0) {
                return Pair.of((Object)p, (Object)resultInput);
            }
            log.error("exit value {}", (Object)p.exitValue());
            log.error(resultInput);
            throw new Exception("Error running " + String.valueOf(withBinaryCommand));
        }
        catch (IOException e) {
            log.info(e.getMessage());
            return null;
        }
        catch (Exception e) {
            log.info(e.getMessage());
            throw new RuntimeException(e);
        }
    }

    FuncRunner(String funcExecutablePath, Boolean printInfo) {
        this.funcExecutablePath = funcExecutablePath;
        this.printInfo = printInfo;
    }

    private static class CustomFuncRunnerBuilder
    extends FuncRunnerBuilder {
        private CustomFuncRunnerBuilder() {
        }

        @Override
        public FuncRunner build() {
            if (Objects.isNull(this.printInfo)) {
                this.printInfo = true;
            }
            if (StringUtils.isEmpty((CharSequence)this.funcExecutablePath)) {
                if (this.printInfo.booleanValue()) {
                    log.info("Checking if Func is installed...");
                }
                String errorMsg = "You can specify full path via FuncRunner.builder().funcExecutablePath(Utils.getFuncGithubUrl()).\nOr make sure you have Func installed. See https://github.com/ton-blockchain/packages for instructions.";
                try {
                    ProcessBuilder pb = new ProcessBuilder("func", "-h").redirectErrorStream(true);
                    Process p = pb.start();
                    p.waitFor(1L, TimeUnit.SECONDS);
                    if (p.exitValue() != 2) {
                        throw new Error("Cannot execute simple Func command.\n" + errorMsg);
                    }
                    String funcAbsolutePath = Utils.detectAbsolutePath((String)"func", (boolean)false);
                    if (this.printInfo.booleanValue()) {
                        log.info("Func found at " + funcAbsolutePath);
                    }
                    funcExecutable = "func";
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                    throw new Error("Cannot execute simple Func command.\n" + errorMsg);
                }
            } else {
                this.funcExecutablePath = Utils.getLocalOrDownload((String)this.funcExecutablePath);
                if (this.printInfo.booleanValue()) {
                    log.info("Using " + this.funcExecutablePath);
                }
                funcExecutable = this.funcExecutablePath;
            }
            return super.build();
        }
    }

    public static class FuncRunnerBuilder {
        private String funcExecutablePath;
        private Boolean printInfo;

        FuncRunnerBuilder() {
        }

        public FuncRunnerBuilder funcExecutablePath(String funcExecutablePath) {
            this.funcExecutablePath = funcExecutablePath;
            return this;
        }

        public FuncRunnerBuilder printInfo(Boolean printInfo) {
            this.printInfo = printInfo;
            return this;
        }

        public FuncRunner build() {
            return new FuncRunner(this.funcExecutablePath, this.printInfo);
        }

        public String toString() {
            return "FuncRunner.FuncRunnerBuilder(funcExecutablePath=" + this.funcExecutablePath + ", printInfo=" + this.printInfo + ")";
        }
    }
}

