/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.Node;
import org.ton.java.cell.PatriciaTreeNode;
import org.ton.java.cell.TonHashMap;

public class TonPfxHashMap
extends TonHashMap {
    public TonPfxHashMap(int keySize) {
        super(keySize);
    }

    @Override
    public List<Node> deserializeEdge(CellSlice edge, int keySize, BitString key) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        BitString l = this.deserializeLabel(edge, keySize - key.toBitString().length());
        key.writeBitString(l);
        boolean pfx = edge.loadBit();
        if (!pfx) {
            Cell value = CellBuilder.beginCell().storeSlice(edge).endCell();
            nodes.add(new Node(key, value));
            return nodes;
        }
        for (int j = 0; j < edge.refs.size(); ++j) {
            CellSlice forkEdge = CellSlice.beginParse(edge.refs.get(j));
            BitString forkKey = key.clone();
            forkKey.writeBit(Boolean.valueOf(j != 0));
            nodes.addAll(this.deserializeEdge(forkEdge, keySize, forkKey));
        }
        return nodes;
    }

    @Override
    void deserialize(CellSlice c, Function<BitString, Object> keyParser, Function<Cell, Object> valueParser) {
        List<Node> nodes = this.deserializeEdge(c, this.keySize, new BitString(this.keySize));
        for (Node node : nodes) {
            this.elements.put(keyParser.apply(node.key), valueParser.apply(node.value));
        }
    }

    @Override
    void serialize_edge(PatriciaTreeNode node, CellBuilder builder) {
        if (node == null) {
            return;
        }
        if (node.leafNode != null) {
            BitString bs = node.leafNode.key.readBits(node.leafNode.key.getUsedBits());
            node.prefix = bs.toBitString();
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            builder.storeBit(false);
            builder.storeCell(node.leafNode.value);
        } else {
            this.serialize_label(node.prefix, node.maxPrefixLength, builder);
            builder.storeBit(true);
            CellBuilder leftCell = CellBuilder.beginCell();
            this.serialize_edge(node.left, leftCell);
            CellBuilder rightCell = CellBuilder.beginCell();
            this.serialize_edge(node.right, rightCell);
            builder.storeRef(leftCell.endCell());
            builder.storeRef(rightCell.endCell());
        }
    }

    @Override
    public Cell serialize(Function<Object, BitString> keyParser, Function<Object, Cell> valueParser) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry entry : this.elements.entrySet()) {
            BitString key = keyParser.apply(entry.getKey());
            Cell value = valueParser.apply(entry.getValue());
            nodes.add(new Node(key, value));
        }
        if (nodes.isEmpty()) {
            throw new Error("TonPfxHashMap does not support empty dict. Consider using TonPfxHashMapE");
        }
        PatriciaTreeNode root = this.flatten(this.splitTree(nodes), this.keySize);
        CellBuilder b = CellBuilder.beginCell();
        this.serialize_edge(root, b);
        return b.endCell();
    }
}

