/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.apache.commons.lang3.tuple.Pair;
import org.ton.java.bitstring.BitString;
import org.ton.java.cell.Cell;
import org.ton.java.cell.CellBuilder;
import org.ton.java.cell.CellSlice;
import org.ton.java.cell.Node;
import org.ton.java.cell.PatriciaTreeNode;
import org.ton.java.cell.TonHashMapAug;

public class TonHashMapAugE
extends TonHashMapAug {
    public TonHashMapAugE(int keySize) {
        super(keySize);
    }

    @Override
    public Cell serialize(Function<Object, BitString> keyParser, Function<Object, Object> valueParser, Function<Object, Object> extraParser, BiFunction<Object, Object, Object> forkExtra) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (Map.Entry entry : this.elements.entrySet()) {
            BitString key = keyParser.apply(entry.getKey());
            Cell value = (Cell)valueParser.apply(((Pair)entry.getValue()).getLeft());
            Cell extra = (Cell)extraParser.apply(((Pair)entry.getValue()).getRight());
            Cell both = CellBuilder.beginCell().storeSlice(CellSlice.beginParse(value)).storeSlice(CellSlice.beginParse(extra)).endCell();
            nodes.add(new Node(key, both));
        }
        if (nodes.isEmpty()) {
            return CellBuilder.beginCell().storeBit(false).endCell();
        }
        PatriciaTreeNode root = this.flatten(this.splitTree(nodes), this.keySize);
        CellBuilder b = CellBuilder.beginCell();
        this.serialize_edge(root, b, forkExtra);
        return CellBuilder.beginCell().storeBit(true).storeRef(b.endCell()).endCell();
    }
}

