/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.cell;

import java.util.Arrays;
import org.ton.java.utils.Utils;

public class ByteReader {
    int[] data;
    public int pos;

    public long getDataSize() {
        return this.data.length;
    }

    public ByteReader(byte[] data) {
        this.data = Utils.signedBytesToUnsigned((byte[])data);
    }

    public ByteReader(int[] data) {
        this.data = Arrays.copyOfRange(data, 0, data.length);
    }

    public int[] readBytes(long num) {
        this.pos = (int)((long)this.pos + num);
        int[] ret = Arrays.copyOfRange(this.data, 0, (int)num);
        this.data = Arrays.copyOfRange(this.data, (int)num, this.data.length);
        return ret;
    }

    public int[] preReadBytes(long num) {
        return Arrays.copyOfRange(this.data, 0, (int)num);
    }

    public int[] readBytes() {
        this.pos += this.data.length;
        int[] ret = Arrays.copyOfRange(this.data, 0, this.data.length);
        this.data = new int[0];
        return ret;
    }

    public int[] preReadBytes() {
        return Arrays.copyOfRange(this.data, 0, this.data.length);
    }

    public int[] readBytesPos(long num) {
        int[] ret = Arrays.copyOfRange(this.data, this.pos, (int)num);
        this.pos = (int)((long)this.pos + num);
        return ret;
    }

    public int[] readBytesReversed(long num) {
        return Utils.reverseIntArray((int[])this.readBytes(num));
    }

    public byte[] readSignedBytes(long num) {
        this.pos = (int)((long)this.pos + num);
        byte[] ret = Arrays.copyOfRange(Utils.unsignedBytesToSigned((int[])this.data), 0, (int)num);
        this.data = Arrays.copyOfRange(this.data, (int)num, this.data.length);
        return ret;
    }

    public byte[] preReadSignedBytes(long num) {
        return Arrays.copyOfRange(Utils.unsignedBytesToSigned((int[])this.data), 0, (int)num);
    }

    public byte[] readSignedBytesReversed(long num) {
        return Utils.reverseByteArray((byte[])this.readSignedBytes(num));
    }

    public byte[] preReadSignedBytesReversed(long num) {
        return Utils.reverseByteArray((byte[])this.preReadSignedBytes(num));
    }

    public short readShortLittleEndian() {
        return Utils.bytesToShort((byte[])this.readSignedBytesReversed(2L));
    }

    public short preReadShortLittleEndian() {
        return Utils.bytesToShort((byte[])this.preReadSignedBytesReversed(2L));
    }

    public int readIntLittleEndian() {
        return Utils.bytesToInt((byte[])this.readSignedBytesReversed(4L));
    }

    public int preReadIntLittleEndian() {
        return Utils.bytesToInt((byte[])this.preReadSignedBytesReversed(4L));
    }

    public long readLongLittleEndian() {
        return Utils.bytesToLong((byte[])this.readSignedBytesReversed(8L));
    }

    public long preReadLongLittleEndian() {
        return Utils.bytesToLong((byte[])this.preReadSignedBytesReversed(8L));
    }

    public int readByte() {
        ++this.pos;
        int[] ret = Arrays.copyOfRange(this.data, 0, 1);
        this.data = Arrays.copyOfRange(this.data, 1, this.data.length);
        return ret[0];
    }

    public int preReadByte() {
        return Arrays.copyOfRange(this.data, 0, 1)[0];
    }

    public byte readSignedByte() {
        ++this.pos;
        int[] ret = Arrays.copyOfRange(this.data, 0, 1);
        this.data = Arrays.copyOfRange(this.data, 1, this.data.length);
        return (byte)ret[0];
    }

    public byte preReadSignedByte() {
        return (byte)Arrays.copyOfRange(this.data, 0, 1)[0];
    }
}

