/*
 * Decompiled with CFR 0.152.
 */
package org.ton.java.address;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Objects;
import org.ton.java.address.AddressType;
import org.ton.java.utils.Utils;

public class Address
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final byte BOUNCEABLE_TAG = 17;
    private static final byte NON_BOUNCEABLE_TAG = 81;
    private static final int TEST_FLAG = 128;
    private static final byte FLAG_TEST_ONLY = 1;
    private static final byte FLAG_USER_FRIENDLY = 2;
    private static final byte FLAG_BOUNCEABLE = 4;
    private static final byte FLAG_WALLET = 8;
    private static final byte FLAG_URL_SAFE = 16;
    public byte wc;
    public byte[] hashPart;
    private byte flags = 0;
    public AddressType addressType;

    private Address() {
    }

    public Address(String address) {
        boolean hasColon;
        if (Objects.isNull(address)) {
            throw new IllegalArgumentException("Address is null");
        }
        boolean bl = hasColon = address.indexOf(58) != -1;
        if (!(hasColon || address.indexOf(45) == -1 && address.indexOf(95) == -1)) {
            this.setFlag((byte)16, true);
            address = address.replace('-', '+').replace('_', '/');
        }
        if (hasColon) {
            this.parseRawAddress(address);
        } else {
            this.setFlag((byte)2, true);
            Address parseResult = Address.parseFriendlyAddress(address);
            this.wc = parseResult.wc;
            this.hashPart = parseResult.hashPart;
            this.flags = parseResult.flags;
        }
    }

    private void parseRawAddress(String address) {
        int colonIndex = address.indexOf(58);
        if (colonIndex != address.lastIndexOf(58)) {
            throw new Error("Invalid address " + address);
        }
        String wcPart = address.substring(0, colonIndex);
        Object hexPart = address.substring(colonIndex + 1);
        byte wcInternal = Byte.parseByte(wcPart);
        if (wcInternal != 0 && wcInternal != -1) {
            throw new Error("Invalid address wc " + address);
        }
        if (((String)hexPart).length() == 63) {
            hexPart = "0" + (String)hexPart;
        } else if (((String)hexPart).length() == 1) {
            hexPart = "000000000000000000000000000000000000000000000000000000000000000" + (String)hexPart;
        }
        if (((String)hexPart).length() != 64) {
            throw new Error("Invalid address hex " + address);
        }
        this.wc = wcInternal;
        this.hashPart = Utils.hexToSignedBytes((String)hexPart);
        this.setFlag((byte)8, true);
    }

    public Address(Address address) {
        if (Objects.isNull(address)) {
            throw new IllegalArgumentException("Address is null");
        }
        this.wc = address.wc;
        this.hashPart = address.hashPart;
        this.flags = address.flags;
        this.addressType = address.addressType;
    }

    public static Address of(String address) {
        return new Address(address);
    }

    public static Address of(byte[] hashCrc) {
        return Address.of((byte)17, -1, hashCrc);
    }

    public static Address of(byte flags, int wc, byte[] hashCrc) {
        int flagsByte = flags & 0xFF;
        boolean isTestOnly = false;
        if ((flagsByte & 0x80) != 0) {
            isTestOnly = true;
            flagsByte = (byte)(flagsByte ^ 0x80);
        }
        if (flagsByte != 17 && flagsByte != 81) {
            throw new Error("Unknown address tag");
        }
        int workchain = (wc & 0xFF) == 255 ? -1 : (int)((byte)wc);
        boolean isBounceable = flagsByte == 17;
        Address addr = new Address();
        addr.wc = (byte)workchain;
        addr.hashPart = hashCrc;
        addr.setFlag((byte)1, isTestOnly);
        addr.setFlag((byte)4, isBounceable);
        addr.setFlag((byte)8, !isBounceable);
        return addr;
    }

    public static Address of(Address address) {
        return new Address(address);
    }

    private void setFlag(byte flagBit, boolean value) {
        this.flags = value ? (byte)(this.flags | flagBit) : (byte)(this.flags & ~flagBit);
    }

    private boolean hasFlag(byte flagBit) {
        return (this.flags & flagBit) != 0;
    }

    public boolean isTestOnly() {
        return this.hasFlag((byte)1);
    }

    public boolean isUserFriendly() {
        return this.hasFlag((byte)2);
    }

    public boolean isBounceable() {
        return this.hasFlag((byte)4);
    }

    public boolean isWallet() {
        return this.hasFlag((byte)8);
    }

    public boolean isUrlSafe() {
        return this.hasFlag((byte)16);
    }

    public String toDecimal() {
        return new BigInteger(Utils.bytesToHex((byte[])this.hashPart), 16).toString(10);
    }

    public BigInteger toBigInteger() {
        return new BigInteger(Utils.bytesToHex((byte[])this.hashPart), 16);
    }

    public String toHex() {
        return Utils.bytesToHex((byte[])this.hashPart);
    }

    public void saveToFile(String filename) throws IOException {
        byte[] result = new byte[this.hashPart.length + 4];
        System.arraycopy(this.hashPart, 0, result, 0, this.hashPart.length);
        ByteBuffer.wrap(result, this.hashPart.length, 4).putInt(this.wc);
        Files.write(Paths.get(filename, new String[0]), result, new OpenOption[0]);
    }

    public String toString() {
        return this.toBounceable();
    }

    public String toString(boolean isUserFriendly) {
        return this.toString(isUserFriendly, this.isUrlSafe(), this.isBounceable(), this.isTestOnly());
    }

    public String toString(boolean isUserFriendly, boolean isUrlSafe) {
        return this.toString(isUserFriendly, isUrlSafe, this.isBounceable(), this.isTestOnly());
    }

    public String toString(boolean isUserFriendly, boolean isUrlSafe, boolean isBounceable) {
        return this.toString(isUserFriendly, isUrlSafe, isBounceable, this.isTestOnly());
    }

    public String toBounceable() {
        return this.toString(true, true, true, false);
    }

    public String toBounceableTestnet() {
        return this.toString(true, true, true, true);
    }

    public String toRaw() {
        return this.toString(false, true, true, false);
    }

    public String toNonBounceable() {
        return this.toString(true, true, false, false);
    }

    public String toNonBounceableTestnet() {
        return this.toString(true, true, false, true);
    }

    public String toString(boolean isUserFriendly, boolean isUrlSafe, boolean isBounceable, boolean isTestOnly) {
        int tag;
        if (!isUserFriendly) {
            return this.wc + ":" + Utils.bytesToHex((byte[])this.hashPart);
        }
        int n = tag = isBounceable ? 17 : 81;
        if (isTestOnly) {
            tag |= 0x80;
        }
        byte[] addr = new byte[34];
        addr[0] = (byte)tag;
        addr[1] = this.wc;
        System.arraycopy(this.hashPart, 0, addr, 2, 32);
        byte[] crc16 = Utils.getCRC16ChecksumAsBytes((byte[])addr);
        byte[] addressWithChecksum = new byte[36];
        System.arraycopy(addr, 0, addressWithChecksum, 0, 34);
        System.arraycopy(crc16, 0, addressWithChecksum, 34, 2);
        return isUrlSafe ? Utils.bytesToBase64SafeUrl((byte[])addressWithChecksum) : Utils.bytesToBase64((byte[])addressWithChecksum);
    }

    public static boolean isValid(String address) {
        try {
            Address.of(address);
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static Address parseFriendlyAddress(String addressString) {
        if (addressString.length() != 48) {
            throw new Error("User-friendly address should contain strictly 48 characters");
        }
        byte[] data = Utils.base64ToBytes((String)addressString);
        if (data.length != 36) {
            throw new Error("Unknown address type: byte length is not equal to 36");
        }
        byte[] addr = new byte[34];
        byte[] crc = new byte[2];
        System.arraycopy(data, 0, addr, 0, 34);
        System.arraycopy(data, 34, crc, 0, 2);
        byte[] calculatedCrc16 = Utils.getCRC16ChecksumAsBytes((byte[])addr);
        if (calculatedCrc16[0] != crc[0] || calculatedCrc16[1] != crc[1]) {
            throw new Error("Wrong crc16 hashsum");
        }
        int tag = addr[0] & 0xFF;
        boolean isTestOnly = false;
        boolean isBounceable = false;
        if ((tag & 0x80) != 0) {
            isTestOnly = true;
            tag = (byte)(tag ^ 0x80);
        }
        if (tag != 17 && tag != 81) {
            throw new Error("Unknown address tag");
        }
        isBounceable = tag == 17;
        byte workchain = (addr[1] & 0xFF) == 255 ? (byte)-1 : addr[1];
        if (workchain != 0 && workchain != -1) {
            throw new Error("Invalid address wc " + workchain);
        }
        byte[] hashPart = new byte[32];
        System.arraycopy(addr, 2, hashPart, 0, 32);
        Address parsedAddress = new Address();
        parsedAddress.wc = workchain;
        parsedAddress.hashPart = hashPart;
        parsedAddress.setFlag((byte)1, isTestOnly);
        parsedAddress.setFlag((byte)4, isBounceable);
        parsedAddress.setFlag((byte)8, !isBounceable);
        parsedAddress.addressType = AddressType.STD_ADDRESS;
        return parsedAddress;
    }

    public long getShardAsLong() {
        int[] hash = this.getHash();
        long shardIdxLong = hash[0] >> 4;
        return BigInteger.valueOf(shardIdxLong).shiftLeft(60).longValue();
    }

    public BigInteger getShardAsBigInt() {
        int[] hash = this.getHash();
        long shardIdxLong = hash[0] >> 4;
        return BigInteger.valueOf(shardIdxLong).shiftLeft(60);
    }

    public int[] getHash() {
        return Utils.signedBytesToUnsigned((byte[])this.hashPart);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Address other = (Address)obj;
        return this.wc == other.wc && Arrays.equals(this.hashPart, other.hashPart);
    }

    public int hashCode() {
        int result = this.wc;
        result = 31 * result + Arrays.hashCode(this.hashPart);
        return result;
    }
}

