/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.databinding.adapter;

import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.lifecycle.LifecycleOwner;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.holder.TypedViewHolder;
import io.github.naverz.antonio.databinding.AntonioBindingModel;
import io.github.naverz.antonio.databinding.holder.AntonioAutoBindingViewHolder;
import java.util.HashMap;
import java.util.Map;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public class DataBindingAdapterHelper<ITEM extends AntonioModel, VH extends TypedViewHolder<ITEM>> {
    @NonNull
    private final Map<Integer, AntonioBindingModel> layoutIdWithBindingModel = new HashMap<Integer, AntonioBindingModel>();
    @Nullable
    final Map<Integer, Object> additionalVariables;
    @Nullable
    final LifecycleOwner lifecycleOwner;

    public DataBindingAdapterHelper(@Nullable Map<Integer, Object> additionalVariables, @Nullable LifecycleOwner lifecycleOwner) {
        this.additionalVariables = additionalVariables;
        this.lifecycleOwner = lifecycleOwner;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public VH createViewBindingIfIsAutoBindingModel(@NonNull ViewGroup parent, int layoutId) {
        AntonioBindingModel model = this.layoutIdWithBindingModel.get(layoutId);
        if (model == null) {
            return null;
        }
        return (VH)((Object)new AntonioAutoBindingViewHolder(layoutId, parent, model.bindingVariableId(), this.additionalVariables, this.lifecycleOwner));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public Integer findLayoutId(@Nullable ITEM item) {
        if (!(item instanceof AntonioBindingModel)) {
            return null;
        }
        AntonioBindingModel model = (AntonioBindingModel)item;
        if (!this.layoutIdWithBindingModel.containsKey(model.layoutId())) {
            this.layoutIdWithBindingModel.put(model.layoutId(), (AntonioBindingModel)item);
        }
        return model.layoutId();
    }
}

