/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core.state;

import androidx.annotation.RestrictTo;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.github.naverz.antonio.AntonioSettings;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.adapter.AdapterDependency;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u001bJ\"\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001b2\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0003J\u0016\u0010%\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bJ\u0016\u0010&\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u001bJ\u000e\u0010'\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001bJ\u0016\u0010(\u001a\u00020\u00182\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006J\u000e\u0010)\u001a\u00020\u00182\u0006\u0010*\u001a\u00020\u0011J\u0010\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u0014H\u0007J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0016J\u000e\u0010/\u001a\u00020\u00182\u0006\u00100\u001a\u000201R.\u0010\u0007\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\u000e\u0010\u0005\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lio/github/naverz/antonio/core/state/RecyclerViewState;", "ITEM", "Lio/github/naverz/antonio/core/AntonioModel;", "", "()V", "<set-?>", "Lio/github/naverz/antonio/core/adapter/AdapterDependency;", "adapterDependency", "getAdapterDependency", "()Lio/github/naverz/antonio/core/adapter/AdapterDependency;", "currentList", "", "getCurrentList", "()Ljava/util/List;", "setCurrentList", "(Ljava/util/List;)V", "hasStableIdLastState", "", "Ljava/lang/Boolean;", "mainThreadExecutor", "Ljava/util/concurrent/Executor;", "strategyForStore", "Landroidx/recyclerview/widget/RecyclerView$Adapter$StateRestorationPolicy;", "notifyDataSetChanged", "", "notifyItemChanged", "position", "", "payload", "notifyItemInserted", "notifyItemMoved", "fromPosition", "toPosition", "notifyItemRangeChanged", "positionStart", "itemCount", "payloads", "notifyItemRangeInserted", "notifyItemRangeRemoved", "notifyItemRemoved", "setAdapterDependency", "setHasStableIds", "enable", "setMainThreadExecutor", "executor", "setStateRestorationPolicy", "strategy", "submitDiff", "diffResult", "Landroidx/recyclerview/widget/DiffUtil$DiffResult;", "antonio-core_release"})
@SourceDebugExtension(value={"SMAP\nRecyclerViewState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RecyclerViewState.kt\nio/github/naverz/antonio/core/state/RecyclerViewState\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,157:1\n1#2:158\n*E\n"})
public class RecyclerViewState<ITEM extends AntonioModel> {
    @NotNull
    private List<ITEM> currentList = new ArrayList();
    @Nullable
    private Boolean hasStableIdLastState;
    @NotNull
    private Executor mainThreadExecutor;
    @Nullable
    private AdapterDependency<ITEM> adapterDependency;
    @Nullable
    private RecyclerView.Adapter.StateRestorationPolicy strategyForStore;

    public RecyclerViewState() {
        Executor executor = AntonioSettings.getExecutorBuilder().call();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"call(...)");
        this.mainThreadExecutor = executor;
    }

    @NotNull
    public final List<ITEM> getCurrentList() {
        return this.currentList;
    }

    public final void setCurrentList(@NotNull List<ITEM> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.currentList = list;
    }

    @Nullable
    public final AdapterDependency<ITEM> getAdapterDependency() {
        return this.adapterDependency;
    }

    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public final void setMainThreadExecutor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.mainThreadExecutor = executor;
    }

    public final void setStateRestorationPolicy(@NotNull RecyclerView.Adapter.StateRestorationPolicy strategy) {
        Intrinsics.checkNotNullParameter((Object)strategy, (String)"strategy");
        Runnable runnable = () -> RecyclerViewState.setStateRestorationPolicy$lambda$0(this, strategy);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void setHasStableIds(boolean enable) {
        Runnable runnable = () -> RecyclerViewState.setHasStableIds$lambda$1(this, enable);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void setAdapterDependency(@Nullable AdapterDependency<ITEM> adapterDependency) {
        if (adapterDependency == null) {
            AdapterDependency<ITEM> adapterDependency2 = this.adapterDependency;
            if (adapterDependency2 != null) {
                adapterDependency2.setCurrentList(new ArrayList());
            }
        } else {
            RecyclerView.Adapter.StateRestorationPolicy stateRestorationPolicy = this.strategyForStore;
            if (stateRestorationPolicy != null) {
                RecyclerView.Adapter.StateRestorationPolicy it = stateRestorationPolicy;
                boolean bl = false;
                adapterDependency.setStateRestorationPolicy(it);
            }
            Boolean bl = this.hasStableIdLastState;
            if (bl != null) {
                boolean it = bl;
                boolean bl2 = false;
                adapterDependency.setHasStableIds(it);
            }
            adapterDependency.setCurrentList(this.currentList);
        }
        this.adapterDependency = adapterDependency;
    }

    public final void notifyDataSetChanged() {
        Runnable runnable = () -> RecyclerViewState.notifyDataSetChanged$lambda$4(this);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void notifyItemChanged(int position, @Nullable Object payload) {
        Runnable runnable = () -> RecyclerViewState.notifyItemChanged$lambda$5(this, position, payload);
        this.mainThreadExecutor.execute(runnable);
    }

    public static /* synthetic */ void notifyItemChanged$default(RecyclerViewState recyclerViewState, int n, Object object, int n2, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyItemChanged");
        }
        if ((n2 & 2) != 0) {
            object = null;
        }
        recyclerViewState.notifyItemChanged(n, object);
    }

    public final void notifyItemInserted(int position) {
        Runnable runnable = () -> RecyclerViewState.notifyItemInserted$lambda$6(this, position);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void notifyItemMoved(int fromPosition, int toPosition) {
        Runnable runnable = () -> RecyclerViewState.notifyItemMoved$lambda$7(this, fromPosition, toPosition);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void notifyItemRangeChanged(int positionStart, int itemCount, @Nullable Object payloads) {
        Runnable runnable = () -> RecyclerViewState.notifyItemRangeChanged$lambda$8(this, positionStart, itemCount, payloads);
        this.mainThreadExecutor.execute(runnable);
    }

    public static /* synthetic */ void notifyItemRangeChanged$default(RecyclerViewState recyclerViewState, int n, int n2, Object object, int n3, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: notifyItemRangeChanged");
        }
        if ((n3 & 4) != 0) {
            object = null;
        }
        recyclerViewState.notifyItemRangeChanged(n, n2, object);
    }

    public final void notifyItemRangeInserted(int positionStart, int itemCount) {
        Runnable runnable = () -> RecyclerViewState.notifyItemRangeInserted$lambda$9(this, positionStart, itemCount);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void notifyItemRangeRemoved(int positionStart, int itemCount) {
        Runnable runnable = () -> RecyclerViewState.notifyItemRangeRemoved$lambda$10(this, positionStart, itemCount);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void notifyItemRemoved(int position) {
        Runnable runnable = () -> RecyclerViewState.notifyItemRemoved$lambda$11(this, position);
        this.mainThreadExecutor.execute(runnable);
    }

    public final void submitDiff(@NotNull DiffUtil.DiffResult diffResult) {
        Intrinsics.checkNotNullParameter((Object)diffResult, (String)"diffResult");
        Runnable runnable = () -> RecyclerViewState.submitDiff$lambda$12(this, diffResult);
        this.mainThreadExecutor.execute(runnable);
    }

    private static final void setStateRestorationPolicy$lambda$0(RecyclerViewState this$0, RecyclerView.Adapter.StateRestorationPolicy $strategy) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$strategy, (String)"$strategy");
            this$0.strategyForStore = $strategy;
            AdapterDependency adapterDependency = this$0.adapterDependency;
            if (adapterDependency == null) break block0;
            adapterDependency.setStateRestorationPolicy($strategy);
        }
    }

    private static final void setHasStableIds$lambda$1(RecyclerViewState this$0, boolean $enable) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.hasStableIdLastState = $enable;
            AdapterDependency adapterDependency = this$0.adapterDependency;
            if (adapterDependency == null) break block0;
            adapterDependency.setHasStableIds($enable);
        }
    }

    private static final void notifyDataSetChanged$lambda$4(RecyclerViewState this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyDataSetChanged();
    }

    private static final void notifyItemChanged$lambda$5(RecyclerViewState this$0, int $position, Object $payload) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemChanged($position, $payload);
    }

    private static final void notifyItemInserted$lambda$6(RecyclerViewState this$0, int $position) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemInserted($position);
    }

    private static final void notifyItemMoved$lambda$7(RecyclerViewState this$0, int $fromPosition, int $toPosition) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemMoved($fromPosition, $toPosition);
    }

    private static final void notifyItemRangeChanged$lambda$8(RecyclerViewState this$0, int $positionStart, int $itemCount, Object $payloads) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemRangeChanged($positionStart, $itemCount, $payloads);
    }

    private static final void notifyItemRangeInserted$lambda$9(RecyclerViewState this$0, int $positionStart, int $itemCount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemRangeInserted($positionStart, $itemCount);
    }

    private static final void notifyItemRangeRemoved$lambda$10(RecyclerViewState this$0, int $positionStart, int $itemCount) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemRangeRemoved($positionStart, $itemCount);
    }

    private static final void notifyItemRemoved$lambda$11(RecyclerViewState this$0, int $position) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.notifyItemRemoved($position);
    }

    private static final void submitDiff$lambda$12(RecyclerViewState this$0, DiffUtil.DiffResult $diffResult) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$diffResult, (String)"$diffResult");
        AdapterDependency adapterDependency = this$0.adapterDependency;
        if (adapterDependency == null) {
            return;
        }
        AdapterDependency diffAdapterDependency = adapterDependency;
        diffAdapterDependency.setCurrentList(this$0.currentList);
        diffAdapterDependency.submitDiffResult($diffResult);
    }
}

