/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core.adapter;

import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.PagerAdapter;
import io.github.naverz.antonio.AntonioSettings;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.Exceptions;
import io.github.naverz.antonio.core.adapter.AntonioCorePagerAdapter;
import io.github.naverz.antonio.core.adapter.PagerAdapterDependency;
import io.github.naverz.antonio.core.container.ContainerType;
import io.github.naverz.antonio.core.container.PagerViewContainer;
import io.github.naverz.antonio.core.view.PagerViewDependency;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0002\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u000f\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J \u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001e2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010,\u001a\u00020\u001eH\u0016J\u0012\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0010\u0010.\u001a\u00020/2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0018\u00100\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u001eH\u0016J\u0018\u0010\b\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016RJ\u0010\b\u001a2\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\r\u0012\u0013\u0012\u00110\u000e\u00a2\u0006\f\b\u000b\u0012\b\b\f\u0012\u0004\b\b(\u000f\u0012\u0004\u0012\u00020\u00100\tX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\u0011\"\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u0015X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR&\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001f0\u001dX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\"\u0010\"\u001a\n\u0012\u0004\u0012\u00020$\u0018\u00010#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0017\"\u0004\b&\u0010\u0019\u00a8\u00061"}, d2={"Lio/github/naverz/antonio/core/adapter/AntonioCorePagerAdapter;", "ITEM", "Lio/github/naverz/antonio/core/AntonioModel;", "Landroidx/viewpager/widget/PagerAdapter;", "Lio/github/naverz/antonio/core/adapter/PagerAdapterDependency;", "pagerViewContainer", "Lio/github/naverz/antonio/core/container/PagerViewContainer;", "(Lio/github/naverz/antonio/core/container/PagerViewContainer;)V", "isViewFromObject", "Lkotlin/Function2;", "Landroid/view/View;", "Lkotlin/ParameterName;", "name", "view", "", "any", "", "()Lkotlin/jvm/functions/Function2;", "setViewFromObject", "(Lkotlin/jvm/functions/Function2;)V", "itemList", "", "getItemList", "()Ljava/util/List;", "setItemList", "(Ljava/util/List;)V", "getPagerViewContainer", "()Lio/github/naverz/antonio/core/container/PagerViewContainer;", "positionToDependency", "", "", "Lio/github/naverz/antonio/core/view/PagerViewDependency;", "getPositionToDependency", "()Ljava/util/Map;", "titles", "", "", "getTitles", "setTitles", "destroyItem", "", "container", "Landroid/view/ViewGroup;", "position", "getCount", "getPageTitle", "getPageWidth", "", "instantiateItem", "antonio-core_release"})
public abstract class AntonioCorePagerAdapter<ITEM extends AntonioModel>
extends PagerAdapter
implements PagerAdapterDependency<ITEM> {
    @NotNull
    private final PagerViewContainer pagerViewContainer;
    @NotNull
    private final Map<Integer, PagerViewDependency<ITEM>> positionToDependency;
    @NotNull
    private List<ITEM> itemList;
    @Nullable
    private List<? extends CharSequence> titles;
    @NotNull
    private Function2<? super View, Object, Boolean> isViewFromObject;

    public AntonioCorePagerAdapter(@NotNull PagerViewContainer pagerViewContainer) {
        Intrinsics.checkNotNullParameter((Object)pagerViewContainer, (String)"pagerViewContainer");
        this.pagerViewContainer = pagerViewContainer;
        this.positionToDependency = new LinkedHashMap();
        this.itemList = new ArrayList();
        this.isViewFromObject = isViewFromObject.1.INSTANCE;
    }

    public /* synthetic */ AntonioCorePagerAdapter(PagerViewContainer pagerViewContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            PagerViewContainer pagerViewContainer2 = AntonioSettings.pagerViewContainer;
            Intrinsics.checkNotNullExpressionValue((Object)pagerViewContainer2, (String)"pagerViewContainer");
            pagerViewContainer = pagerViewContainer2;
        }
        this(pagerViewContainer);
    }

    @NotNull
    public PagerViewContainer getPagerViewContainer() {
        return this.pagerViewContainer;
    }

    @NotNull
    protected final Map<Integer, PagerViewDependency<ITEM>> getPositionToDependency() {
        return this.positionToDependency;
    }

    @Override
    @NotNull
    public List<ITEM> getItemList() {
        return this.itemList;
    }

    @Override
    public void setItemList(@NotNull List<ITEM> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.itemList = list;
    }

    @Override
    @Nullable
    public List<CharSequence> getTitles() {
        return this.titles;
    }

    @Override
    public void setTitles(@Nullable List<? extends CharSequence> list) {
        this.titles = list;
    }

    @Override
    @NotNull
    public Function2<View, Object, Boolean> isViewFromObject() {
        return this.isViewFromObject;
    }

    @Override
    public void setViewFromObject(@NotNull Function2<? super View, Object, Boolean> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.isViewFromObject = function2;
    }

    public int getCount() {
        return this.getItemList().size();
    }

    public boolean isViewFromObject(@NotNull View view, @NotNull Object any) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)any, (String)"any");
        return (Boolean)this.isViewFromObject().invoke((Object)view, any);
    }

    @NotNull
    public Object instantiateItem(@NotNull ViewGroup container, int position) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        AntonioModel item = (AntonioModel)this.getItemList().get(position);
        PagerViewDependency<Object> dependency = this.positionToDependency.get(position);
        if (dependency == null) {
            PagerViewDependency<?> pagerViewDependency = this.getPagerViewContainer().get((Class)item.getClass());
            if (pagerViewDependency == null || (pagerViewDependency = pagerViewDependency.build()) == null) {
                throw new IllegalStateException(Exceptions.errorRegisterFirst(item.getClass(), ContainerType.PAGER_VIEW));
            }
            PagerViewDependency<?> buildDependency = pagerViewDependency;
            dependency = buildDependency;
            Integer n = position;
            this.positionToDependency.put(n, buildDependency);
        }
        Integer n = this.getPagerViewContainer().getViewType(item.getClass());
        if (n == null) {
            throw new IllegalStateException("An unknown error is found. Please, Issue up on Github (https://github.com/naverz/Antonio).");
        }
        int viewType = n;
        try {
            object = dependency.instantiateItem(container, position, viewType, item);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(item, dependency), e);
        }
        return object;
    }

    public void destroyItem(@NotNull ViewGroup container, int position, @NotNull Object any) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            AntonioModel item = (AntonioModel)this.getItemList().get(position);
            PagerViewDependency<AntonioModel> pagerViewDependency = this.positionToDependency.get(position);
            if (pagerViewDependency == null) break block0;
            pagerViewDependency.destroyItem(container, position, item, any);
        }
    }

    @Nullable
    public CharSequence getPageTitle(int position) {
        List<CharSequence> list = this.getTitles();
        if (list == null || (list = (CharSequence)CollectionsKt.getOrNull(list, (int)position)) == null) {
            list = super.getPageTitle(position);
        }
        return list;
    }

    public float getPageWidth(int position) {
        AntonioModel item = (AntonioModel)this.getItemList().get(position);
        PagerViewDependency<AntonioModel> pagerViewDependency = this.positionToDependency.get(position);
        return pagerViewDependency != null ? pagerViewDependency.getPageWidth(position, item) : super.getPageWidth(position);
    }

    public AntonioCorePagerAdapter() {
        this(null, 1, null);
    }
}

