/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core.adapter;

import android.content.res.Resources;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.ListAdapter;
import androidx.recyclerview.widget.RecyclerView;
import io.github.naverz.antonio.AntonioSettings;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.Exceptions;
import io.github.naverz.antonio.core.ViewHolderBuilder;
import io.github.naverz.antonio.core.adapter.ListAdapterDependency;
import io.github.naverz.antonio.core.container.ContainerType;
import io.github.naverz.antonio.core.container.ViewHolderContainer;
import io.github.naverz.antonio.core.holder.TypedViewHolder;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u001d\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u0010\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J\u001e\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0011\u001a\u00020\u000eH\u0016J,\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017H\u0016J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eH\u0016J\u0016\u0010\u001d\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010\u001e\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010\u001f\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lio/github/naverz/antonio/core/adapter/AntonioCoreListAdapter;", "ITEM", "Lio/github/naverz/antonio/core/AntonioModel;", "Lio/github/naverz/antonio/core/adapter/ListAdapterDependency;", "Landroidx/recyclerview/widget/ListAdapter;", "Lio/github/naverz/antonio/core/holder/TypedViewHolder;", "diffItemCallback", "Landroidx/recyclerview/widget/DiffUtil$ItemCallback;", "viewHolderContainer", "Lio/github/naverz/antonio/core/container/ViewHolderContainer;", "(Landroidx/recyclerview/widget/DiffUtil$ItemCallback;Lio/github/naverz/antonio/core/container/ViewHolderContainer;)V", "getViewHolderContainer", "()Lio/github/naverz/antonio/core/container/ViewHolderContainer;", "getItemCount", "", "getItemId", "", "position", "getItemViewType", "onBindViewHolder", "", "holder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewAttachedToWindow", "onViewDetachedFromWindow", "onViewRecycled", "antonio-core_release"})
public abstract class AntonioCoreListAdapter<ITEM extends AntonioModel>
extends ListAdapter<ITEM, TypedViewHolder<ITEM>>
implements ListAdapterDependency<ITEM> {
    @NotNull
    private final ViewHolderContainer viewHolderContainer;

    public AntonioCoreListAdapter(@NotNull DiffUtil.ItemCallback<ITEM> diffItemCallback, @NotNull ViewHolderContainer viewHolderContainer) {
        Intrinsics.checkNotNullParameter(diffItemCallback, (String)"diffItemCallback");
        Intrinsics.checkNotNullParameter((Object)viewHolderContainer, (String)"viewHolderContainer");
        super(diffItemCallback);
        this.viewHolderContainer = viewHolderContainer;
    }

    public /* synthetic */ AntonioCoreListAdapter(DiffUtil.ItemCallback itemCallback, ViewHolderContainer viewHolderContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ViewHolderContainer viewHolderContainer2 = AntonioSettings.viewHolderContainer;
            Intrinsics.checkNotNullExpressionValue((Object)viewHolderContainer2, (String)"viewHolderContainer");
            viewHolderContainer = viewHolderContainer2;
        }
        this(itemCallback, viewHolderContainer);
    }

    @NotNull
    public ViewHolderContainer getViewHolderContainer() {
        return this.viewHolderContainer;
    }

    public int getItemViewType(int position) {
        Integer n = this.getViewHolderContainer().getViewType(this.getCurrentList().get(position).getClass());
        if (n == null) {
            throw new IllegalStateException(Exceptions.errorRegisterFirst(this.getCurrentList().get(position).getClass(), ContainerType.VIEW_HOLDER));
        }
        return n;
    }

    public long getItemId(int position) {
        Long l = ((AntonioModel)this.getCurrentList().get(position)).getModelId();
        return l != null ? l.longValue() : super.getItemId(position);
    }

    public void onViewRecycled(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onViewRecycled();
    }

    public void onViewAttachedToWindow(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow(holder);
    }

    public void onBindViewHolder(@NotNull TypedViewHolder<ITEM> holder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        try {
            holder.onBindViewHolder((AntonioModel)this.getCurrentList().get(position), position, payloads);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(this.getCurrentList().get(position), holder), e);
        }
    }

    @NotNull
    public TypedViewHolder<ITEM> onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ViewHolderBuilder viewHolderBuilder = this.getViewHolderContainer().get(viewType);
        if (viewHolderBuilder == null) {
            String string;
            try {
                string = parent.getContext().getResources().getResourceName(viewType);
            }
            catch (Resources.NotFoundException e) {
                string = String.valueOf(viewType);
            }
            String string2 = "There is no related view holder dependency with the view type[" + string + "] in your viewHolderContainer [" + this.getViewHolderContainer() + "]";
            throw new IllegalStateException(string2);
        }
        ViewHolderBuilder dependency = viewHolderBuilder;
        TypedViewHolder<?> uncheckedHolder = dependency.build(parent);
        Intrinsics.checkNotNull(uncheckedHolder, (String)"null cannot be cast to non-null type io.github.naverz.antonio.core.holder.TypedViewHolder<ITEM of io.github.naverz.antonio.core.adapter.AntonioCoreListAdapter>");
        return uncheckedHolder;
    }

    public void onBindViewHolder(@NotNull TypedViewHolder<ITEM> holder, int position) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        try {
            holder.onBindViewHolder((AntonioModel)this.getCurrentList().get(position), position, null);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(this.getCurrentList().get(position), holder), e);
        }
    }

    public int getItemCount() {
        return this.getCurrentList().size();
    }
}

