/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core.adapter;

import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.lifecycle.Lifecycle;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import io.github.naverz.antonio.AntonioSettings;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.Exceptions;
import io.github.naverz.antonio.core.adapter.AdapterDependency;
import io.github.naverz.antonio.core.adapter.AntonioCoreFragmentStateAdapterKt;
import io.github.naverz.antonio.core.container.ContainerType;
import io.github.naverz.antonio.core.container.FragmentContainer;
import io.github.naverz.antonio.core.fragment.AntonioFragment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001f\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eB'\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0013B\u0017\b\u0016\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014B\u0017\b\u0016\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0015B\u001f\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010#\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020%2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016R \u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\t\u001a\u00020\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"\u00a8\u0006/"}, d2={"Lio/github/naverz/antonio/core/adapter/AntonioCoreFragmentStateAdapter;", "ITEM", "Lio/github/naverz/antonio/core/AntonioModel;", "Landroidx/viewpager2/adapter/FragmentStateAdapter;", "Lio/github/naverz/antonio/core/adapter/AdapterDependency;", "fragmentActivity", "Landroidx/fragment/app/FragmentActivity;", "implementedItemID", "", "fragmentContainer", "Lio/github/naverz/antonio/core/container/FragmentContainer;", "(Landroidx/fragment/app/FragmentActivity;ZLio/github/naverz/antonio/core/container/FragmentContainer;)V", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/Fragment;ZLio/github/naverz/antonio/core/container/FragmentContainer;)V", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "lifecycle", "Landroidx/lifecycle/Lifecycle;", "(Landroidx/fragment/app/FragmentManager;Landroidx/lifecycle/Lifecycle;ZLio/github/naverz/antonio/core/container/FragmentContainer;)V", "(Landroidx/fragment/app/FragmentActivity;Z)V", "(Landroidx/fragment/app/Fragment;Z)V", "(Landroidx/fragment/app/FragmentManager;Landroidx/lifecycle/Lifecycle;Z)V", "currentList", "", "getCurrentList", "()Ljava/util/List;", "setCurrentList", "(Ljava/util/List;)V", "getFragmentContainer", "()Lio/github/naverz/antonio/core/container/FragmentContainer;", "getFragmentManager", "()Landroidx/fragment/app/FragmentManager;", "getImplementedItemID", "()Z", "containsItem", "itemId", "", "createFragment", "position", "", "getItemCount", "getItemId", "submitDiffResult", "", "diffResult", "Landroidx/recyclerview/widget/DiffUtil$DiffResult;", "antonio-core_release"})
@SourceDebugExtension(value={"SMAP\nAntonioCoreFragmentStateAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AntonioCoreFragmentStateAdapter.kt\nio/github/naverz/antonio/core/adapter/AntonioCoreFragmentStateAdapter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,173:1\n1747#2,3:174\n*S KotlinDebug\n*F\n+ 1 AntonioCoreFragmentStateAdapter.kt\nio/github/naverz/antonio/core/adapter/AntonioCoreFragmentStateAdapter\n*L\n150#1:174,3\n*E\n"})
public abstract class AntonioCoreFragmentStateAdapter<ITEM extends AntonioModel>
extends FragmentStateAdapter
implements AdapterDependency<ITEM> {
    private final boolean implementedItemID;
    @NotNull
    private final FragmentContainer fragmentContainer;
    @NotNull
    private final FragmentManager fragmentManager;
    @NotNull
    private List<? extends ITEM> currentList;

    protected final boolean getImplementedItemID() {
        return this.implementedItemID;
    }

    @NotNull
    protected final FragmentContainer getFragmentContainer() {
        return this.fragmentContainer;
    }

    @NotNull
    protected final FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull FragmentActivity fragmentActivity, boolean implementedItemID, @NotNull FragmentContainer fragmentContainer) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        Intrinsics.checkNotNullParameter((Object)fragmentContainer, (String)"fragmentContainer");
        super(fragmentActivity);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        this.fragmentContainer = fragmentContainer;
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
        this.fragmentManager = fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull Fragment fragment, boolean implementedItemID, @NotNull FragmentContainer fragmentContainer) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Intrinsics.checkNotNullParameter((Object)fragmentContainer, (String)"fragmentContainer");
        super(fragment);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        this.fragmentContainer = fragmentContainer;
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
        this.fragmentManager = fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull FragmentManager fragmentManager, @NotNull Lifecycle lifecycle, boolean implementedItemID, @NotNull FragmentContainer fragmentContainer) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        Intrinsics.checkNotNullParameter((Object)fragmentContainer, (String)"fragmentContainer");
        super(fragmentManager, lifecycle);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        this.fragmentContainer = fragmentContainer;
        this.fragmentManager = fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull FragmentActivity fragmentActivity, boolean implementedItemID) {
        Intrinsics.checkNotNullParameter((Object)fragmentActivity, (String)"fragmentActivity");
        super(fragmentActivity);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        FragmentContainer fragmentContainer = AntonioSettings.fragmentContainer;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainer, (String)"fragmentContainer");
        this.fragmentContainer = fragmentContainer;
        FragmentManager fragmentManager = fragmentActivity.getSupportFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getSupportFragmentManager(...)");
        this.fragmentManager = fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull Fragment fragment, boolean implementedItemID) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        super(fragment);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        FragmentContainer fragmentContainer = AntonioSettings.fragmentContainer;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainer, (String)"fragmentContainer");
        this.fragmentContainer = fragmentContainer;
        FragmentManager fragmentManager = fragment.getChildFragmentManager();
        Intrinsics.checkNotNullExpressionValue((Object)fragmentManager, (String)"getChildFragmentManager(...)");
        this.fragmentManager = fragmentManager;
    }

    public AntonioCoreFragmentStateAdapter(@NotNull FragmentManager fragmentManager, @NotNull Lifecycle lifecycle, boolean implementedItemID) {
        Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
        Intrinsics.checkNotNullParameter((Object)lifecycle, (String)"lifecycle");
        super(fragmentManager, lifecycle);
        this.currentList = new ArrayList();
        this.implementedItemID = implementedItemID;
        FragmentContainer fragmentContainer = AntonioSettings.fragmentContainer;
        Intrinsics.checkNotNullExpressionValue((Object)fragmentContainer, (String)"fragmentContainer");
        this.fragmentContainer = fragmentContainer;
        this.fragmentManager = fragmentManager;
    }

    @Override
    @NotNull
    public List<ITEM> getCurrentList() {
        return this.currentList;
    }

    @Override
    public void setCurrentList(@NotNull List<? extends ITEM> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.currentList = list;
    }

    @Override
    public void submitDiffResult(@NotNull DiffUtil.DiffResult diffResult) {
        Intrinsics.checkNotNullParameter((Object)diffResult, (String)"diffResult");
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getItemId(int position) {
        long l;
        if (this.implementedItemID) {
            Long l2 = ((AntonioModel)this.getCurrentList().get(position)).getModelId();
            if (l2 == null) throw new IllegalStateException("If you set the implementedItemID flag true, You must implement itemId in your all of AntonioModel");
            l = l2;
        } else {
            l = position;
        }
        long itemId = l;
        return AntonioCoreFragmentStateAdapterKt.access$getCreatedMomentOfThisProcess$p() + itemId;
    }

    public boolean containsItem(long itemId) {
        boolean bl;
        block5: {
            if (this.implementedItemID) {
                Iterable $this$any$iv = this.getCurrentList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        AntonioModel it = (AntonioModel)element$iv;
                        boolean bl2 = false;
                        Long l = it.getModelId();
                        boolean bl3 = l != null ? l + AntonioCoreFragmentStateAdapterKt.access$getCreatedMomentOfThisProcess$p() == itemId : false;
                        if (!bl3) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            } else {
                bl = itemId >= AntonioCoreFragmentStateAdapterKt.access$getCreatedMomentOfThisProcess$p() && itemId < (long)this.getItemCount() + AntonioCoreFragmentStateAdapterKt.access$getCreatedMomentOfThisProcess$p();
            }
        }
        return bl;
    }

    public int getItemCount() {
        return this.getCurrentList().size();
    }

    @NotNull
    public Fragment createFragment(int position) {
        AntonioFragment<?> dependency;
        AntonioFragment<?> antonioFragment;
        AntonioModel data = (AntonioModel)this.getCurrentList().get(position);
        AntonioFragment<?> antonioFragment2 = this.fragmentContainer.get((Class)data.getClass());
        if (antonioFragment2 == null || (antonioFragment2 = antonioFragment2.build()) == null) {
            throw new IllegalStateException(Exceptions.errorRegisterFirst(data.getClass(), ContainerType.FRAGMENT));
        }
        AntonioFragment<?> $this$createFragment_u24lambda_u241 = antonioFragment = (dependency = antonioFragment2);
        boolean bl = false;
        try {
            $this$createFragment_u24lambda_u241.setData(position, data);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(data, $this$createFragment_u24lambda_u241), e);
        }
        return antonioFragment;
    }
}

