/*
 * Decompiled with CFR 0.152.
 */
package io.github.naverz.antonio.core.adapter;

import android.content.res.Resources;
import android.view.ViewGroup;
import androidx.recyclerview.widget.DiffUtil;
import androidx.recyclerview.widget.RecyclerView;
import io.github.naverz.antonio.AntonioSettings;
import io.github.naverz.antonio.core.AntonioModel;
import io.github.naverz.antonio.core.Exceptions;
import io.github.naverz.antonio.core.ViewHolderBuilder;
import io.github.naverz.antonio.core.adapter.AdapterDependency;
import io.github.naverz.antonio.core.container.ContainerType;
import io.github.naverz.antonio.core.container.ViewHolderContainer;
import io.github.naverz.antonio.core.holder.TypedViewHolder;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00050\u0004B\u000f\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u0010\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J\u001e\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0015\u001a\u00020\u0012H\u0016J,\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u0015\u001a\u00020\u00122\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0016J\u001e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0012H\u0016J\u0016\u0010!\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010\"\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0016\u0010#\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u0016J\u0010\u0010$\u001a\u00020\u00182\u0006\u0010%\u001a\u00020&H\u0016R \u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006'"}, d2={"Lio/github/naverz/antonio/core/adapter/AntonioCoreAdapter;", "ITEM", "Lio/github/naverz/antonio/core/AntonioModel;", "Lio/github/naverz/antonio/core/adapter/AdapterDependency;", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "Lio/github/naverz/antonio/core/holder/TypedViewHolder;", "viewHolderContainer", "Lio/github/naverz/antonio/core/container/ViewHolderContainer;", "(Lio/github/naverz/antonio/core/container/ViewHolderContainer;)V", "currentList", "", "getCurrentList", "()Ljava/util/List;", "setCurrentList", "(Ljava/util/List;)V", "getViewHolderContainer", "()Lio/github/naverz/antonio/core/container/ViewHolderContainer;", "getItemCount", "", "getItemId", "", "position", "getItemViewType", "onBindViewHolder", "", "holder", "payloads", "", "", "onCreateViewHolder", "parent", "Landroid/view/ViewGroup;", "viewType", "onViewAttachedToWindow", "onViewDetachedFromWindow", "onViewRecycled", "submitDiffResult", "diffResult", "Landroidx/recyclerview/widget/DiffUtil$DiffResult;", "antonio-core_release"})
public abstract class AntonioCoreAdapter<ITEM extends AntonioModel>
extends RecyclerView.Adapter<TypedViewHolder<ITEM>>
implements AdapterDependency<ITEM> {
    @NotNull
    private final ViewHolderContainer viewHolderContainer;
    @NotNull
    private List<? extends ITEM> currentList;

    public AntonioCoreAdapter(@NotNull ViewHolderContainer viewHolderContainer) {
        Intrinsics.checkNotNullParameter((Object)viewHolderContainer, (String)"viewHolderContainer");
        this.viewHolderContainer = viewHolderContainer;
        this.currentList = new ArrayList();
    }

    public /* synthetic */ AntonioCoreAdapter(ViewHolderContainer viewHolderContainer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            ViewHolderContainer viewHolderContainer2 = AntonioSettings.viewHolderContainer;
            Intrinsics.checkNotNullExpressionValue((Object)viewHolderContainer2, (String)"viewHolderContainer");
            viewHolderContainer = viewHolderContainer2;
        }
        this(viewHolderContainer);
    }

    @NotNull
    public ViewHolderContainer getViewHolderContainer() {
        return this.viewHolderContainer;
    }

    @Override
    @NotNull
    public List<ITEM> getCurrentList() {
        return this.currentList;
    }

    @Override
    public void setCurrentList(@NotNull List<? extends ITEM> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.currentList = list;
    }

    @Override
    public void submitDiffResult(@NotNull DiffUtil.DiffResult diffResult) {
        Intrinsics.checkNotNullParameter((Object)diffResult, (String)"diffResult");
        diffResult.dispatchUpdatesTo((RecyclerView.Adapter)this);
    }

    public int getItemViewType(int position) {
        Integer n = this.getViewHolderContainer().getViewType(this.getCurrentList().get(position).getClass());
        if (n == null) {
            throw new IllegalStateException(Exceptions.errorRegisterFirst(this.getCurrentList().get(position).getClass(), ContainerType.VIEW_HOLDER));
        }
        return n;
    }

    public long getItemId(int position) {
        Long l = ((AntonioModel)this.getCurrentList().get(position)).getModelId();
        return l != null ? l.longValue() : super.getItemId(position);
    }

    public void onViewRecycled(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewRecycled((RecyclerView.ViewHolder)holder);
        holder.onViewRecycled();
    }

    public void onViewAttachedToWindow(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewAttachedToWindow((RecyclerView.ViewHolder)holder);
        holder.onViewAttachedToWindow(holder);
    }

    public void onViewDetachedFromWindow(@NotNull TypedViewHolder<ITEM> holder) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        super.onViewDetachedFromWindow((RecyclerView.ViewHolder)holder);
        holder.onViewDetachedFromWindow(holder);
    }

    public void onBindViewHolder(@NotNull TypedViewHolder<ITEM> holder, int position, @NotNull List<Object> payloads) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        Intrinsics.checkNotNullParameter(payloads, (String)"payloads");
        try {
            holder.onBindViewHolder((AntonioModel)this.getCurrentList().get(position), position, payloads);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(this.getCurrentList().get(position), holder), e);
        }
    }

    @NotNull
    public TypedViewHolder<ITEM> onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        ViewHolderBuilder viewHolderBuilder = this.getViewHolderContainer().get(viewType);
        if (viewHolderBuilder == null) {
            String string;
            try {
                string = parent.getContext().getResources().getResourceName(viewType);
            }
            catch (Resources.NotFoundException e) {
                string = String.valueOf(viewType);
            }
            String string2 = "There is no related view holder dependency with the view type[" + string + "] in your viewHolderContainer [" + this.getViewHolderContainer() + "]";
            throw new IllegalStateException(string2);
        }
        ViewHolderBuilder dependency = viewHolderBuilder;
        TypedViewHolder<?> uncheckedHolder = dependency.build(parent);
        Intrinsics.checkNotNull(uncheckedHolder, (String)"null cannot be cast to non-null type io.github.naverz.antonio.core.holder.TypedViewHolder<ITEM of io.github.naverz.antonio.core.adapter.AntonioCoreAdapter>");
        return uncheckedHolder;
    }

    public void onBindViewHolder(@NotNull TypedViewHolder<ITEM> holder, int position) {
        Intrinsics.checkNotNullParameter(holder, (String)"holder");
        try {
            holder.onBindViewHolder((AntonioModel)this.getCurrentList().get(position), position, null);
        }
        catch (ClassCastException e) {
            throw new IllegalStateException(Exceptions.errorClassCast(this.getCurrentList().get(position), holder), e);
        }
    }

    public int getItemCount() {
        return this.getCurrentList().size();
    }

    public AntonioCoreAdapter() {
        this(null, 1, null);
    }
}

